/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.avatar;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.avatar.AvatarVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.server.AbstractStreamResource;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Objects;

@Tag(value="vaadin-avatar")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="23.5.12"), @NpmPackage(value="@vaadin/avatar", version="23.5.12"), @NpmPackage(value="@vaadin/vaadin-avatar", version="23.5.12")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/avatar/src/vaadin-avatar.js")})
public class Avatar
extends Component
implements HasStyle,
HasSize,
HasThemeVariant<AvatarVariant> {
    private AbstractStreamResource imageResource;
    private AvatarI18n i18n;

    public Avatar() {
    }

    public Avatar(String name) {
        this.setName(name);
    }

    public Avatar(String name, String url) {
        this.setName(name);
        this.setImage(url);
    }

    public AvatarI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(AvatarI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)i18n);
        this.getElement().setPropertyJson("i18n", (JsonValue)i18nObject);
    }

    public String getName() {
        return this.getElement().getProperty("name");
    }

    public void setName(String name) {
        this.getElement().setProperty("name", name);
    }

    public String getAbbreviation() {
        return this.getElement().getProperty("abbr");
    }

    public void setAbbreviation(String abbr) {
        this.getElement().setProperty("abbr", abbr);
    }

    public String getImage() {
        return this.getElement().getAttribute("img");
    }

    public AbstractStreamResource getImageResource() {
        return this.imageResource;
    }

    public void setImage(String url) {
        this.imageResource = null;
        if (url == null) {
            this.getElement().removeAttribute("img");
        } else {
            this.getElement().setAttribute("img", url);
        }
    }

    public void setImageResource(AbstractStreamResource resource) {
        this.imageResource = resource;
        if (resource == null) {
            this.getElement().removeAttribute("img");
            return;
        }
        this.getElement().setAttribute("img", resource);
    }

    public Integer getColorIndex() {
        String colorIndex = this.getElement().getProperty("colorIndex");
        if (colorIndex != null && !colorIndex.isEmpty()) {
            return Integer.parseInt(colorIndex);
        }
        return null;
    }

    public void setColorIndex(Integer colorIndex) {
        this.getElement().setProperty("colorIndex", (double)colorIndex.intValue());
    }

    public boolean isTooltipEnabled() {
        return this.getElement().getProperty("withTooltip", false);
    }

    public void setTooltipEnabled(boolean tooltipEnabled) {
        this.getElement().setProperty("withTooltip", tooltipEnabled);
    }

    public void addThemeVariants(AvatarVariant ... variants) {
        super.addThemeVariants((ThemeVariant[])variants);
    }

    public void removeThemeVariants(AvatarVariant ... variants) {
        super.removeThemeVariants((ThemeVariant[])variants);
    }

    public static class AvatarI18n
    implements Serializable {
        private String anonymous;

        public String getAnonymous() {
            return this.anonymous;
        }

        public AvatarI18n setAnonymous(String anonymous) {
            Objects.requireNonNull(anonymous, "The translation should not be null");
            this.anonymous = anonymous;
            return this;
        }
    }
}

