/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.avatar;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.avatar.AvatarGroupVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.HasOverlayClassName;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-avatar-group")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.1.6"), @NpmPackage(value="@vaadin/avatar-group", version="24.1.6")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/avatar-group/src/vaadin-avatar-group.js")})
public class AvatarGroup
extends Component
implements HasOverlayClassName,
HasStyle,
HasSize,
HasThemeVariant<AvatarGroupVariant> {
    private List<AvatarGroupItem> items = Collections.emptyList();
    private boolean pendingUpdate = false;
    private AvatarGroupI18n i18n;

    public AvatarGroup() {
    }

    public AvatarGroup(Collection<AvatarGroupItem> items) {
        this.setItems(items);
    }

    public AvatarGroup(AvatarGroupItem ... items) {
        this.setItems(items);
    }

    public void setItems(Collection<AvatarGroupItem> items) {
        this.items.forEach(item -> item.setHost(null));
        this.items = new ArrayList<AvatarGroupItem>(items);
        items.stream().forEach(item -> item.setHost(this));
        this.setClientItems();
    }

    public void setItems(AvatarGroupItem ... items) {
        this.setItems(Arrays.asList(items));
    }

    private void setClientItems() {
        if (!this.pendingUpdate) {
            this.pendingUpdate = true;
            this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)ctx -> {
                this.getElement().setPropertyJson("items", (JsonValue)this.createItemsJsonArray(this.items));
                this.pendingUpdate = false;
            }));
        }
    }

    private JsonArray createItemsJsonArray(Collection<AvatarGroupItem> items) {
        JsonArray jsonItems = Json.createArray();
        for (AvatarGroupItem item : items) {
            JsonObject jsonItem = Json.createObject();
            if (item.getName() != null) {
                jsonItem.put("name", item.getName());
            }
            if (item.getAbbreviation() != null) {
                jsonItem.put("abbr", item.getAbbreviation());
            }
            if (item.getImage() != null) {
                jsonItem.put("img", item.getImage());
            }
            if (item.getColorIndex() != null) {
                jsonItem.put("colorIndex", (double)item.getColorIndex().intValue());
            }
            jsonItems.set(jsonItems.length(), (JsonValue)jsonItem);
        }
        return jsonItems;
    }

    public void add(AvatarGroupItem ... items) {
        this.setItems(Stream.concat(this.items.stream(), Arrays.stream(items)).collect(Collectors.toList()));
    }

    public void remove(AvatarGroupItem ... items) {
        List<AvatarGroupItem> itemsToRemove = Arrays.asList(items);
        this.setItems(this.items.stream().filter(item -> !itemsToRemove.contains(item)).collect(Collectors.toList()));
    }

    public List<AvatarGroupItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public AvatarGroupI18n getI18n() {
        return this.i18n;
    }

    public void setI18n(AvatarGroupI18n i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)i18n);
        i18nObject.remove("manyActiveUsers");
        i18nObject.remove("oneActiveUser");
        JsonObject activeUsers = Json.createObject();
        activeUsers.put("many", i18n.getManyActiveUsers());
        activeUsers.put("one", i18n.getOneActiveUser());
        i18nObject.put("activeUsers", (JsonValue)activeUsers);
        this.getElement().setPropertyJson("i18n", (JsonValue)i18nObject);
    }

    public void setMaxItemsVisible(Integer max) {
        this.getElement().setProperty("maxItemsVisible", (double)max.intValue());
    }

    public Integer getMaxItemsVisible() {
        String max = this.getElement().getProperty("maxItemsVisible");
        if (max != null && !max.isEmpty()) {
            return Integer.parseInt(max);
        }
        return null;
    }

    public static class AvatarGroupItem
    implements Serializable {
        private String name;
        private String abbr;
        private String img;
        private Integer colorIndex;
        private AvatarGroup host;
        private StreamRegistration resourceRegistration;
        private Registration pendingRegistration;
        private Command pendingHandle;
        private AbstractStreamResource imageResource;

        public AvatarGroupItem() {
        }

        public AvatarGroupItem(String name) {
            this.setName(name);
        }

        public AvatarGroupItem(String name, String url) {
            this.setName(name);
            this.setImage(url);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            if (this.getHost() != null) {
                this.getHost().setClientItems();
            }
        }

        public String getAbbreviation() {
            return this.abbr;
        }

        public void setAbbreviation(String abbr) {
            this.abbr = abbr;
            if (this.getHost() != null) {
                this.getHost().setClientItems();
            }
        }

        public String getImage() {
            return this.img;
        }

        public AbstractStreamResource getImageResource() {
            return this.imageResource;
        }

        public void setImage(String url) {
            this.unsetResource();
            this.img = url;
            if (this.getHost() != null) {
                this.getHost().setClientItems();
            }
        }

        public void setImageResource(AbstractStreamResource resource) {
            this.imageResource = resource;
            if (resource == null) {
                this.unsetResource();
                return;
            }
            this.doSetResource(resource);
            if (this.getHost() != null && this.getHost().getElement().getNode().isAttached()) {
                this.registerResource(resource);
            } else {
                this.deferRegistration(resource);
            }
            if (this.getHost() != null) {
                this.getHost().setClientItems();
            }
        }

        private void doSetResource(AbstractStreamResource resource) {
            URI targetUri;
            if (VaadinSession.getCurrent() != null) {
                StreamResourceRegistry resourceRegistry = VaadinSession.getCurrent().getResourceRegistry();
                targetUri = resourceRegistry.getTargetURI(resource);
            } else {
                targetUri = StreamResourceRegistry.getURI((AbstractStreamResource)resource);
            }
            this.img = targetUri.toASCIIString();
        }

        private void unregisterResource() {
            StreamRegistration registration = this.resourceRegistration;
            Registration handle = this.pendingRegistration;
            if (handle != null) {
                handle.remove();
            }
            if (registration != null) {
                registration.unregister();
            }
            this.img = null;
        }

        private void deferRegistration(AbstractStreamResource resource) {
            if (this.pendingRegistration != null) {
                return;
            }
            this.pendingHandle = (Command & Serializable)() -> {
                this.doSetResource(resource);
                this.registerResource(resource);
            };
            if (this.getHost() != null) {
                this.attachPendingRegistration(this.pendingHandle);
                this.pendingHandle = null;
            }
        }

        private void attachPendingRegistration(Command pendingHandle) {
            Registration handle;
            if (this.getHost().getElement().getNode().isAttached()) {
                pendingHandle.execute();
                return;
            }
            this.pendingRegistration = handle = this.getHost().getElement().getNode().addAttachListener(pendingHandle);
        }

        private void registerResource(AbstractStreamResource resource) {
            StreamRegistration registration;
            assert (this.resourceRegistration == null);
            this.resourceRegistration = registration = this.getSession().getResourceRegistry().registerResource(resource);
            Registration handle = this.pendingRegistration;
            if (handle != null) {
                handle.remove();
            }
            this.pendingRegistration = this.getHost().getElement().getNode().addDetachListener(new Command(){

                public void execute() {
                    this.unsetResource();
                }
            });
        }

        private void unsetResource() {
            this.imageResource = null;
            StreamRegistration registration = this.resourceRegistration;
            Optional<AbstractStreamResource> resource = Optional.empty();
            if (registration != null) {
                resource = Optional.ofNullable(registration.getResource());
            }
            this.unregisterResource();
            resource.ifPresent(this::deferRegistration);
        }

        private VaadinSession getSession() {
            NodeOwner owner = this.getHost().getElement().getNode().getOwner();
            assert (owner instanceof StateTree);
            return ((StateTree)owner).getUI().getSession();
        }

        public Integer getColorIndex() {
            return this.colorIndex;
        }

        public void setColorIndex(Integer colorIndex) {
            this.colorIndex = colorIndex;
            if (this.getHost() != null) {
                this.getHost().setClientItems();
            }
        }

        private AvatarGroup getHost() {
            return this.host;
        }

        private void setHost(AvatarGroup host) {
            this.host = host;
            if (this.pendingHandle != null) {
                this.attachPendingRegistration(this.pendingHandle);
                this.pendingHandle = null;
            }
        }
    }

    public static class AvatarGroupI18n
    implements Serializable {
        private String anonymous;
        private HashMap<String, String> activeUsers = new HashMap();

        public String getAnonymous() {
            return this.anonymous;
        }

        public AvatarGroupI18n setAnonymous(String anonymous) {
            Objects.requireNonNull(anonymous, "The translation should not be null");
            this.anonymous = anonymous;
            return this;
        }

        public String getOneActiveUser() {
            return this.activeUsers.get("one");
        }

        public AvatarGroupI18n setOneActiveUser(String oneActiveUser) {
            Objects.requireNonNull(oneActiveUser, "The translation should not be null");
            this.activeUsers.put("one", oneActiveUser);
            return this;
        }

        public String getManyActiveUsers() {
            return this.activeUsers.get("many");
        }

        public AvatarGroupI18n setManyActiveUsers(String manyActiveUsers) {
            Objects.requireNonNull(manyActiveUsers, "The translation should not be null");
            this.activeUsers.put("many", manyActiveUsers);
            return this;
        }
    }
}

