/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.board;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasOrderedComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.board.internal.FunctionCaller;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import java.util.Optional;

@Tag(value="vaadin-board-row")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.5.12"), @NpmPackage(value="@vaadin/board", version="24.5.12")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/board/src/vaadin-board-row.js")})
public class Row
extends Component
implements HasStyle,
HasSize,
HasOrderedComponents {
    static final String COLSPAN_ATTRIBUTE = "board-cols";
    private boolean redrawTriggered;

    public Row() {
    }

    public Row(Component ... components) {
        this.add(components);
    }

    public void add(Component ... components) {
        this.throwIfTooManyColumns(components.length);
        super.add(components);
    }

    public void add(Component component, int cols) {
        this.add(component);
        this.setComponentSpan(component, cols);
    }

    public void addNestedRow(Row row) {
        this.add((Component)row, 1);
    }

    public int getComponentSpan(Component component) {
        this.throwIfNotChild(component);
        String attr = component.getElement().getAttribute(COLSPAN_ATTRIBUTE);
        if (attr == null) {
            return 1;
        }
        return Integer.parseInt(attr);
    }

    public void setComponentSpan(Component component, int columns) {
        this.throwIfNotChild(component);
        this.throwIfTooManyColumns(columns - this.getComponentSpan(component));
        if (columns == 1) {
            component.getElement().removeAttribute(COLSPAN_ATTRIBUTE);
        } else {
            component.getElement().setAttribute(COLSPAN_ATTRIBUTE, "" + columns);
        }
        FunctionCaller.callOnceOnClientReponse(this, "redraw");
    }

    private void throwIfNotChild(Component component) {
        if (!Row.isDirectChild(this, component)) {
            throw new IllegalArgumentException("The given component is not a child of this row");
        }
    }

    private void throwIfTooManyColumns(int aboutToBeAdded) {
        if (this.getColumns() + aboutToBeAdded > 4) {
            throw new IllegalArgumentException("A row can only contain 4 columns");
        }
    }

    private int getColumns() {
        return this.getChildren().map(this::getComponentSpan).reduce(Integer::sum).orElse(0);
    }

    private static boolean isDirectChild(Component parent, Component component) {
        Optional componentParent = component.getParent();
        return componentParent.isPresent() && componentParent.get() == parent;
    }
}

