/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.apache.deltaspike.core.util.context.AbstractContext;
import org.apache.deltaspike.core.util.context.ContextualStorage;

abstract class AbstractContextualStorageManager<K>
implements Serializable {
    @Inject
    private BeanManager beanManager;
    private final boolean concurrent;
    private final Map<K, ContextualStorage> storageMap;

    protected AbstractContextualStorageManager(boolean concurrent) {
        this.storageMap = concurrent ? new ConcurrentHashMap<K, ContextualStorage>() : new HashMap<K, ContextualStorage>();
        this.concurrent = concurrent;
    }

    protected ContextualStorage getContextualStorage(K key, boolean createIfNotExist) {
        if (createIfNotExist) {
            return this.storageMap.computeIfAbsent(key, this::newContextualStorage);
        }
        return this.storageMap.get(key);
    }

    protected ContextualStorage newContextualStorage(K key) {
        return new ContextualStorage(this.beanManager, this.concurrent, true);
    }

    @PreDestroy
    protected void destroyAll() {
        Collection<ContextualStorage> storages = this.storageMap.values();
        for (ContextualStorage storage : storages) {
            AbstractContext.destroyAllActive((ContextualStorage)storage);
        }
        this.storageMap.clear();
    }

    protected void destroy(K key) {
        ContextualStorage storage = this.storageMap.remove(key);
        if (storage != null) {
            AbstractContext.destroyAllActive((ContextualStorage)storage);
        }
    }

    protected Set<K> getKeySet() {
        return Collections.unmodifiableSet(this.storageMap.keySet());
    }
}

