/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.context;

import com.vaadin.cdi.annotation.NormalUIScoped;
import com.vaadin.cdi.annotation.RouteScopeOwner;
import com.vaadin.cdi.annotation.RouteScoped;
import com.vaadin.cdi.context.AbstractContextualStorageManager;
import com.vaadin.flow.router.AfterNavigationEvent;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.context.AbstractContext;
import org.apache.deltaspike.core.util.context.ContextualStorage;

public class RouteScopedContext
extends AbstractContext {
    private ContextualStorageManager contextManager;
    private Supplier<Boolean> isUIContextActive;
    private BeanManager beanManager;

    public RouteScopedContext(BeanManager beanManager) {
        super(beanManager);
    }

    public void init(BeanManager beanManager, Supplier<Boolean> isUIContextActive) {
        this.contextManager = (ContextualStorageManager)BeanProvider.getContextualReference((BeanManager)beanManager, ContextualStorageManager.class, (boolean)false, (Annotation[])new Annotation[0]);
        this.beanManager = beanManager;
        this.isUIContextActive = isUIContextActive;
    }

    public Class<? extends Annotation> getScope() {
        return RouteScoped.class;
    }

    public boolean isActive() {
        return this.isUIContextActive.get();
    }

    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        Class key = this.convertToKey(contextual);
        return this.contextManager.getContextualStorage(key, createIfNotExist);
    }

    private Class convertToKey(Contextual<?> contextual) {
        if (!(contextual instanceof Bean)) {
            if (contextual instanceof PassivationCapable) {
                String id = ((PassivationCapable)contextual).getId();
                contextual = this.beanManager.getPassivationCapableBean(id);
            } else {
                throw new IllegalArgumentException(contextual.getClass().getName() + " is not of type " + Bean.class.getName());
            }
        }
        Bean bean = contextual;
        return bean.getQualifiers().stream().filter(annotation -> annotation instanceof RouteScopeOwner).map(annotation -> ((RouteScopeOwner)annotation).value()).findFirst().orElse(bean.getBeanClass());
    }

    @NormalUIScoped
    public static class ContextualStorageManager
    extends AbstractContextualStorageManager<Class> {
        public ContextualStorageManager() {
            super(false);
        }

        private void onAfterNavigation(@Observes(notifyObserver=Reception.IF_EXISTS) AfterNavigationEvent event) {
            Set activeChain = event.getActiveChain().stream().map(Object::getClass).collect(Collectors.toSet());
            Set<Class> missingFromChain = this.getKeySet().stream().filter(routeCompClass -> !activeChain.contains(routeCompClass)).collect(Collectors.toSet());
            missingFromChain.forEach(this::destroy);
        }
    }
}

