/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.context;

import com.vaadin.cdi.annotation.UIScoped;
import com.vaadin.cdi.annotation.VaadinSessionScoped;
import com.vaadin.cdi.context.AbstractContextualStorageManager;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.VaadinSession;
import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.context.AbstractContext;
import org.apache.deltaspike.core.util.context.ContextualStorage;

public class UIScopedContext
extends AbstractContext {
    private ContextualStorageManager contextualStorageManager;

    public UIScopedContext(BeanManager beanManager) {
        super(beanManager);
    }

    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        return this.contextualStorageManager.getContextualStorage(createIfNotExist);
    }

    public void init(BeanManager beanManager) {
        this.contextualStorageManager = (ContextualStorageManager)BeanProvider.getContextualReference((BeanManager)beanManager, ContextualStorageManager.class, (boolean)false, (Annotation[])new Annotation[0]);
    }

    public Class<? extends Annotation> getScope() {
        return UIScoped.class;
    }

    public boolean isActive() {
        return VaadinSession.getCurrent() != null && UI.getCurrent() != null && this.contextualStorageManager != null;
    }

    @VaadinSessionScoped
    public static class ContextualStorageManager
    extends AbstractContextualStorageManager<Integer> {
        public ContextualStorageManager() {
            super(false);
        }

        public ContextualStorage getContextualStorage(boolean createIfNotExist) {
            Integer uiId = UI.getCurrent().getUIId();
            return super.getContextualStorage(uiId, createIfNotExist);
        }

        @Override
        protected ContextualStorage newContextualStorage(Integer uiId) {
            UI.getCurrent().addDetachListener(this::destroy);
            return super.newContextualStorage(uiId);
        }

        @Override
        private void destroy(DetachEvent event) {
            int uiId = event.getUI().getUIId();
            super.destroy(uiId);
        }
    }
}

