/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.cdi.context;

import com.vaadin.cdi.CdiVaadinServlet;
import com.vaadin.cdi.annotation.VaadinServiceScoped;
import com.vaadin.cdi.context.AbstractContextualStorageManager;
import com.vaadin.cdi.util.AbstractContext;
import com.vaadin.cdi.util.BeanProvider;
import com.vaadin.cdi.util.ContextualStorage;
import com.vaadin.flow.server.ServiceDestroyEvent;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;

public class VaadinServiceScopedContext
extends AbstractContext {
    private ContextualStorageManager contextManager;

    public VaadinServiceScopedContext(BeanManager beanManager) {
        super(beanManager);
    }

    public void init(BeanManager beanManager) {
        this.contextManager = BeanProvider.getContextualReference(beanManager, ContextualStorageManager.class, false, new Annotation[0]);
    }

    @Override
    protected ContextualStorage getContextualStorage(Contextual<?> contextual, boolean createIfNotExist) {
        CdiVaadinServlet servlet = (CdiVaadinServlet)VaadinServlet.getCurrent();
        String servletName = servlet != null ? servlet.getServletName() : CdiVaadinServlet.getCurrentServletName();
        return this.contextManager.getContextualStorage(servletName, createIfNotExist);
    }

    public Class<? extends Annotation> getScope() {
        return VaadinServiceScoped.class;
    }

    public boolean isActive() {
        VaadinServlet servlet = VaadinServlet.getCurrent();
        return servlet instanceof CdiVaadinServlet || servlet == null && CdiVaadinServlet.getCurrentServletName() != null;
    }

    @ApplicationScoped
    public static class ContextualStorageManager
    extends AbstractContextualStorageManager<String> {
        public ContextualStorageManager() {
            super(true);
        }

        private void onServiceDestroy(@Observes(notifyObserver=Reception.IF_EXISTS) ServiceDestroyEvent event) {
            if (!(event.getSource() instanceof VaadinServletService)) {
                return;
            }
            VaadinServletService service = (VaadinServletService)event.getSource();
            String servletName = service.getServlet().getServletName();
            this.destroy(servletName);
        }
    }
}

