/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vaadin.flow.component.charts.model.AbstractSeries;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DataProviderSeries<T>
extends AbstractSeries {
    @JsonIgnore
    private final DataProvider<T, ?> dataProvider;
    public static final String X_ATTRIBUTE = "x";
    public static final String Y_ATTRIBUTE = "y";
    private static final String NAME_ATTRIBUTE = "name";
    public static final String HIGH_PROPERTY = "high";
    public static final String LOW_PROPERTY = "low";
    public static final String OPEN_PROPERTY = "open";
    public static final String CLOSE_PROPERTY = "close";
    @JsonIgnore
    private final Map<String, SerializableFunction<T, Object>> chartAttributeToCallback;
    @JsonIgnore
    private boolean automaticChartUpdateEnabled = true;
    @JsonIgnore
    private Registration dataProviderRegistration;
    @JsonIgnore
    private DataProviderListener<T> listener = (DataProviderListener & Serializable)event -> this.updateSeries();

    public DataProviderSeries(DataProvider<T, ?> dataProvider) {
        this.dataProvider = dataProvider;
        this.chartAttributeToCallback = new HashMap<String, SerializableFunction<T, Object>>();
        this.dataProviderRegistration = dataProvider.addDataProviderListener(this.listener);
    }

    public DataProviderSeries(DataProvider<T, ?> dataProvider, SerializableFunction<T, Object> callBack) {
        this(dataProvider);
        this.setY(callBack);
    }

    public void setProperty(String propertyName, SerializableFunction<T, Object> callBack) {
        this.chartAttributeToCallback.put(propertyName, callBack);
    }

    public void setX(SerializableFunction<T, Object> callBack) {
        this.setProperty(X_ATTRIBUTE, callBack);
    }

    public void setY(SerializableFunction<T, Object> callBack) {
        this.setProperty(Y_ATTRIBUTE, callBack);
    }

    public void setPointName(SerializableFunction<T, Object> callBack) {
        this.setProperty(NAME_ATTRIBUTE, callBack);
    }

    public void setLow(SerializableFunction<T, Object> callBack) {
        this.setProperty(LOW_PROPERTY, callBack);
    }

    public void setHigh(SerializableFunction<T, Object> callBack) {
        this.setProperty(HIGH_PROPERTY, callBack);
    }

    public void setOpen(SerializableFunction<T, Object> callBack) {
        this.setProperty(OPEN_PROPERTY, callBack);
    }

    public void setClose(SerializableFunction<T, Object> callBack) {
        this.setProperty(CLOSE_PROPERTY, callBack);
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.dataProvider;
    }

    public List<Map<String, Optional<Object>>> getValues() {
        return this.dataProvider.fetch(new Query()).map(item -> this.chartAttributeToCallback.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() != null ? Optional.ofNullable(((SerializableFunction)entry.getValue()).apply(item)) : Optional.empty()))).collect(Collectors.toList());
    }

    public Set<String> getChartAttributes() {
        return this.chartAttributeToCallback.keySet();
    }

    public boolean isAutomaticChartUpdateEnabled() {
        return this.automaticChartUpdateEnabled;
    }

    public void setAutomaticChartUpdateEnabled(boolean automaticChartUpdateEnabled) {
        this.automaticChartUpdateEnabled = automaticChartUpdateEnabled;
        if (automaticChartUpdateEnabled) {
            if (this.dataProviderRegistration == null) {
                this.dataProviderRegistration = this.dataProvider.addDataProviderListener(this.listener);
            }
        } else if (this.dataProviderRegistration != null) {
            this.dataProviderRegistration.remove();
            this.dataProviderRegistration = null;
        }
    }
}

