/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.charts.ChartVariant;
import com.vaadin.flow.component.charts.ProxyChangeForwarder;
import com.vaadin.flow.component.charts.events.ChartAddSeriesEvent;
import com.vaadin.flow.component.charts.events.ChartAfterPrintEvent;
import com.vaadin.flow.component.charts.events.ChartBeforePrintEvent;
import com.vaadin.flow.component.charts.events.ChartClickEvent;
import com.vaadin.flow.component.charts.events.ChartDrillupAllEvent;
import com.vaadin.flow.component.charts.events.ChartDrillupEvent;
import com.vaadin.flow.component.charts.events.ChartLoadEvent;
import com.vaadin.flow.component.charts.events.ChartRedrawEvent;
import com.vaadin.flow.component.charts.events.ChartSelectionEvent;
import com.vaadin.flow.component.charts.events.DrilldownEvent;
import com.vaadin.flow.component.charts.events.PointClickEvent;
import com.vaadin.flow.component.charts.events.PointDragEvent;
import com.vaadin.flow.component.charts.events.PointDragStartEvent;
import com.vaadin.flow.component.charts.events.PointDropEvent;
import com.vaadin.flow.component.charts.events.PointLegendItemClickEvent;
import com.vaadin.flow.component.charts.events.PointMouseOutEvent;
import com.vaadin.flow.component.charts.events.PointMouseOverEvent;
import com.vaadin.flow.component.charts.events.PointRemoveEvent;
import com.vaadin.flow.component.charts.events.PointSelectEvent;
import com.vaadin.flow.component.charts.events.PointUnselectEvent;
import com.vaadin.flow.component.charts.events.PointUpdateEvent;
import com.vaadin.flow.component.charts.events.SeriesAfterAnimateEvent;
import com.vaadin.flow.component.charts.events.SeriesCheckboxClickEvent;
import com.vaadin.flow.component.charts.events.SeriesClickEvent;
import com.vaadin.flow.component.charts.events.SeriesHideEvent;
import com.vaadin.flow.component.charts.events.SeriesLegendItemClickEvent;
import com.vaadin.flow.component.charts.events.SeriesMouseOutEvent;
import com.vaadin.flow.component.charts.events.SeriesMouseOverEvent;
import com.vaadin.flow.component.charts.events.SeriesShowEvent;
import com.vaadin.flow.component.charts.events.XAxesExtremesSetEvent;
import com.vaadin.flow.component.charts.events.YAxesExtremesSetEvent;
import com.vaadin.flow.component.charts.events.internal.ConfigurationChangeListener;
import com.vaadin.flow.component.charts.model.AbstractConfigurationObject;
import com.vaadin.flow.component.charts.model.ChartType;
import com.vaadin.flow.component.charts.model.Configuration;
import com.vaadin.flow.component.charts.model.DataSeries;
import com.vaadin.flow.component.charts.model.DataSeriesItem;
import com.vaadin.flow.component.charts.model.DrilldownCallback;
import com.vaadin.flow.component.charts.model.Series;
import com.vaadin.flow.component.charts.util.ChartSerialization;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JreJsonFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-chart")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.8.0"), @NpmPackage(value="@vaadin/charts", version="24.8.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/charts/src/vaadin-chart.js")})
public class Chart
extends Component
implements HasStyle,
HasSize,
HasTheme {
    private Configuration configuration;
    private Registration configurationUpdateRegistration;
    private transient JreJsonFactory jsonFactory = new JreJsonFactory();
    private final ConfigurationChangeListener changeListener = new ProxyChangeForwarder(this);
    private static final List<ChartType> TIMELINE_NOT_SUPPORTED = Arrays.asList(ChartType.PIE, ChartType.GAUGE, ChartType.SOLIDGAUGE, ChartType.PYRAMID, ChartType.FUNNEL, ChartType.ORGANIZATION, ChartType.GANTT);
    private DrillCallbackHandler drillCallbackHandler;
    private DrilldownCallback drilldownCallback;

    public Chart() {
        this.configuration = new Configuration();
    }

    public Chart(ChartType type) {
        this();
        this.getConfiguration().getChart().setType(type);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.beforeClientResponse(attachEvent.getUI(), false);
    }

    private void beforeClientResponse(UI ui, boolean resetConfiguration) {
        if (this.configurationUpdateRegistration != null) {
            this.configurationUpdateRegistration.remove();
        }
        this.configurationUpdateRegistration = ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            this.drawChart(resetConfiguration);
            this.reportUsage();
            if (this.configuration != null) {
                this.configuration.addChangeListener(this.changeListener);
            }
            this.configurationUpdateRegistration = null;
        });
    }

    private void reportUsage() {
        ChartType type = this.getConfiguration().getChart().getType();
        if (type == ChartType.GANTT) {
            UsageStatistics.markAsUsed((String)"flow-components/chart/gantt", null);
        }
    }

    JreJsonFactory getJsonFactory() {
        if (this.jsonFactory == null) {
            this.jsonFactory = new JreJsonFactory();
        }
        return this.jsonFactory;
    }

    public void drawChart() {
        this.drawChart(false);
    }

    public void drawChart(boolean resetConfiguration) {
        this.validateTimelineAndConfiguration();
        JsonObject configurationNode = (JsonObject)this.getJsonFactory().parse(ChartSerialization.toJSON(this.configuration));
        this.getElement().callJsFunction("updateConfiguration", new Serializable[]{configurationNode, Boolean.valueOf(resetConfiguration)});
    }

    public void setTimeline(Boolean timeline) {
        this.getElement().setProperty("timeline", timeline.booleanValue());
    }

    private void validateTimelineAndConfiguration() {
        ChartType type;
        if (this.getElement().getProperty("timeline", false) && TIMELINE_NOT_SUPPORTED.contains(type = this.getConfiguration().getChart().getType())) {
            throw new IllegalArgumentException("Timeline is not supported for chart type '" + type + "'");
        }
    }

    public void setVisibilityTogglingDisabled(boolean disabled) {
        this.getElement().setProperty("_visibilityTogglingDisabled", disabled);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        if (this.configuration != null) {
            this.configuration.removeChangeListener(this.changeListener);
        }
        this.configuration = configuration;
        if (this.getElement().getNode().isAttached()) {
            this.getUI().ifPresent(ui -> this.beforeClientResponse((UI)ui, true));
        }
    }

    public DrilldownCallback getDrilldownCallback() {
        return this.drilldownCallback;
    }

    public void setDrilldownCallback(DrilldownCallback drilldownCallback) {
        this.drilldownCallback = drilldownCallback;
        this.updateDrillHandler();
    }

    private void updateDrillHandler() {
        boolean hasCallback;
        boolean bl = hasCallback = this.getDrilldownCallback() != null;
        if (hasCallback && this.drillCallbackHandler == null) {
            this.drillCallbackHandler = new DrillCallbackHandler();
            this.drillCallbackHandler.register();
        } else if (!hasCallback && this.drillCallbackHandler != null && this.drillCallbackHandler.canBeUnregistered()) {
            this.drillCallbackHandler.unregister();
            this.drillCallbackHandler = null;
        }
    }

    public Registration addChartAddSeriesListener(ComponentEventListener<ChartAddSeriesEvent> listener) {
        return this.addListener(ChartAddSeriesEvent.class, listener);
    }

    public Registration addChartAfterPrintListener(ComponentEventListener<ChartAfterPrintEvent> listener) {
        return this.addListener(ChartAfterPrintEvent.class, listener);
    }

    public Registration addChartBeforePrintListener(ComponentEventListener<ChartBeforePrintEvent> listener) {
        return this.addListener(ChartBeforePrintEvent.class, listener);
    }

    public Registration addChartClickListener(ComponentEventListener<ChartClickEvent> listener) {
        return this.addListener(ChartClickEvent.class, listener);
    }

    public Registration addChartDrillupListener(ComponentEventListener<ChartDrillupEvent> listener) {
        return this.addListener(ChartDrillupEvent.class, listener);
    }

    public Registration addChartDrillupAllListener(ComponentEventListener<ChartDrillupAllEvent> listener) {
        return this.addListener(ChartDrillupAllEvent.class, listener);
    }

    public Registration addChartLoadListener(ComponentEventListener<ChartLoadEvent> listener) {
        return this.addListener(ChartLoadEvent.class, listener);
    }

    public Registration addChartRedrawListener(ComponentEventListener<ChartRedrawEvent> listener) {
        return this.addListener(ChartRedrawEvent.class, listener);
    }

    public Registration addCheckBoxClickListener(ComponentEventListener<SeriesCheckboxClickEvent> listener) {
        return this.addListener(SeriesCheckboxClickEvent.class, listener);
    }

    public Registration addDrilldownListener(ComponentEventListener<DrilldownEvent> listener) {
        return this.addListener(DrilldownEvent.class, listener);
    }

    public Registration addChartSelectionListener(ComponentEventListener<ChartSelectionEvent> listener) {
        return this.addListener(ChartSelectionEvent.class, listener);
    }

    public Registration addSeriesLegendItemClickListener(ComponentEventListener<SeriesLegendItemClickEvent> listener) {
        return this.addListener(SeriesLegendItemClickEvent.class, listener);
    }

    public Registration addPointLegendItemClickListener(ComponentEventListener<PointLegendItemClickEvent> listener) {
        return this.addListener(PointLegendItemClickEvent.class, listener);
    }

    public Registration addSeriesAfterAnimateListener(ComponentEventListener<SeriesAfterAnimateEvent> listener) {
        return this.addListener(SeriesAfterAnimateEvent.class, listener);
    }

    public Registration addSeriesClickListener(ComponentEventListener<SeriesClickEvent> listener) {
        return this.addListener(SeriesClickEvent.class, listener);
    }

    public Registration addSeriesHideListener(ComponentEventListener<SeriesHideEvent> listener) {
        return this.addListener(SeriesHideEvent.class, listener);
    }

    public Registration addSeriesMouseOutListener(ComponentEventListener<SeriesMouseOutEvent> listener) {
        return this.addListener(SeriesMouseOutEvent.class, listener);
    }

    public Registration addSeriesMouseOverListener(ComponentEventListener<SeriesMouseOverEvent> listener) {
        return this.addListener(SeriesMouseOverEvent.class, listener);
    }

    public Registration addSeriesShowListener(ComponentEventListener<SeriesShowEvent> listener) {
        return this.addListener(SeriesShowEvent.class, listener);
    }

    public Registration addPointClickListener(ComponentEventListener<PointClickEvent> listener) {
        return this.addListener(PointClickEvent.class, listener);
    }

    public Registration addPointMouseOutListener(ComponentEventListener<PointMouseOutEvent> listener) {
        return this.addListener(PointMouseOutEvent.class, listener);
    }

    public Registration addPointMouseOverListener(ComponentEventListener<PointMouseOverEvent> listener) {
        return this.addListener(PointMouseOverEvent.class, listener);
    }

    public Registration addPointRemoveListener(ComponentEventListener<PointRemoveEvent> listener) {
        return this.addListener(PointRemoveEvent.class, listener);
    }

    public Registration addPointSelectListener(ComponentEventListener<PointSelectEvent> listener) {
        return this.addListener(PointSelectEvent.class, listener);
    }

    public Registration addPointUnselectListener(ComponentEventListener<PointUnselectEvent> listener) {
        return this.addListener(PointUnselectEvent.class, listener);
    }

    public Registration addPointUpdateListener(ComponentEventListener<PointUpdateEvent> listener) {
        return this.addListener(PointUpdateEvent.class, listener);
    }

    public Registration addPointDragStartListener(ComponentEventListener<PointDragStartEvent> listener) {
        return this.addListener(PointDragStartEvent.class, listener);
    }

    public Registration addPointDropListener(ComponentEventListener<PointDropEvent> listener) {
        return this.addListener(PointDropEvent.class, listener);
    }

    public Registration addPointDragListener(ComponentEventListener<PointDragEvent> listener) {
        return this.addListener(PointDragEvent.class, listener);
    }

    public Registration addXAxesExtremesSetListener(ComponentEventListener<XAxesExtremesSetEvent> listener) {
        return this.addListener(XAxesExtremesSetEvent.class, listener);
    }

    public Registration addYAxesExtremesSetListener(ComponentEventListener<YAxesExtremesSetEvent> listener) {
        return this.addListener(YAxesExtremesSetEvent.class, listener);
    }

    public void addThemeVariants(ChartVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(ChartVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(ChartVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(ChartVariant::getVariantName).collect(Collectors.toList()));
    }

    private class DrillCallbackHandler
    implements Serializable {
        private final Deque<Series> stack = new LinkedList<Series>();
        private Registration drilldownRegistration;
        private Registration drillupRegistration;

        private DrillCallbackHandler() {
        }

        private void register() {
            this.drilldownRegistration = Chart.this.addDrilldownListener((ComponentEventListener<DrilldownEvent>)((ComponentEventListener & Serializable)this::onDrilldown));
            this.drillupRegistration = Chart.this.addChartDrillupListener((ComponentEventListener<ChartDrillupEvent>)((ComponentEventListener & Serializable)this::onDrillup));
        }

        private void unregister() {
            this.stack.clear();
            this.drilldownRegistration.remove();
            this.drillupRegistration.remove();
            this.drilldownRegistration = null;
            this.drillupRegistration = null;
        }

        private void onDrilldown(DrilldownEvent details) {
            if (Chart.this.getDrilldownCallback() == null) {
                return;
            }
            int seriesIndex = details.getSeriesItemIndex();
            int pointIndex = details.getItemIndex();
            Series series = this.resolveSeriesFor(seriesIndex);
            DataSeriesItem item = null;
            if (series instanceof DataSeries) {
                DataSeries dataSeries = (DataSeries)series;
                item = dataSeries.get(pointIndex);
            }
            DrilldownCallback.DrilldownDetails chartDrilldownEvent = new DrilldownCallback.DrilldownDetails(series, item, pointIndex);
            Series drilldownSeries = Chart.this.getDrilldownCallback().handleDrilldown(chartDrilldownEvent);
            if (drilldownSeries != null) {
                this.stack.push(drilldownSeries);
                this.callClientSideAddSeriesAsDrilldown(seriesIndex, pointIndex, drilldownSeries);
            }
        }

        private void onDrillup(ChartDrillupEvent e) {
            this.stack.pop();
            Chart.this.updateDrillHandler();
        }

        private boolean canBeUnregistered() {
            return this.stack.isEmpty();
        }

        private void callClientSideAddSeriesAsDrilldown(int seriesIndex, int pointIndex, Series drilldownSeries) {
            Chart.this.getElement().executeJs("this.__callChartFunction($0, this.configuration.series[$1].data[$2], $3)", new Serializable[]{"addSeriesAsDrilldown", Integer.valueOf(seriesIndex), Integer.valueOf(pointIndex), this.toJsonValue((AbstractConfigurationObject)((Object)drilldownSeries))});
        }

        private JsonValue toJsonValue(AbstractConfigurationObject series) {
            return Chart.this.getJsonFactory().parse(ChartSerialization.toJSON(series));
        }

        private Series resolveSeriesFor(int seriesIndex) {
            if (this.stack.isEmpty()) {
                return Chart.this.getConfiguration().getSeries().get(seriesIndex);
            }
            return this.stack.peek();
        }
    }
}

