package com.vaadin.flow.component.charts.model;

/*-
 * #%L
 * Vaadin Charts for Flow
 * %%
 * Copyright (C) 2014 - 2018 Vaadin Ltd
 * %%
 * This program is available under Commercial Vaadin Add-On License 3.0
 * (CVALv3).
 * 
 * See the file licensing.txt distributed with this software for more
 * information about licensing.
 * 
 * You should have received a copy of the CVALv3 along with this program.
 * If not, see <https://vaadin.com/license/cval-3>.
 * #L%
 */

import javax.annotation.Generated;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * <p>
 * The Y axis or value axis. In case of multiple axes, the yAxis node is an
 * array of configuration objects.
 * </p>
 * <p>
 * See <a class="internal" href="#axis.object">the Axis object</a> for
 * programmatic access to the axis.
 * </p>
 */
@Generated(value = "This class is generated and shouldn't be modified", comments = "Incorrect and missing API should be reported to https://github.com/vaadin/vaadin-charts-flow/issues/new")
public class YAxis extends Axis {

	private Boolean allowDecimals;
	private Boolean alternateGridColor;
	private Number angle;
	private Breaks[] breaks;
	private ArrayList<String> categories;
	private Number ceiling;
	private String className;
	private Crosshair crosshair;
	private DateTimeLabelFormats dateTimeLabelFormats;
	private String description;
	private Boolean endOnTick;
	private Number floor;
	private String gridLineInterpolation;
	private Number gridZIndex;
	private String id;
	private Labels labels;
	private Number linkedTo;
	private Number maxPadding;
	private Number minPadding;
	private Number minRange;
	private Number minTickInterval;
	private String minorTickInterval;
	private Number minorTickLength;
	private TickPosition minorTickPosition;
	private Number offset;
	private Boolean opposite;
	private ArrayList<PlotBand> plotBands;
	private ArrayList<PlotLine> plotLines;
	private Boolean reversed;
	private Boolean reversedStacks;
	private Boolean showEmpty;
	private Boolean showFirstLabel;
	private Boolean showLastLabel;
	private Number softMax;
	private Number softMin;
	private StackLabels stackLabels;
	private Number startOfWeek;
	private Boolean startOnTick;
	private Number tickAmount;
	private Number tickInterval;
	private Number tickLength;
	private Number tickPixelInterval;
	private TickPosition tickPosition;
	private Number[] tickPositions;
	private TickmarkPlacement tickmarkPlacement;
	private AxisTitle title;
	private AxisType type;
	private Boolean uniqueNames;
	private ArrayList<TimeUnitMultiples> units;
	private Boolean visible;
	private String height;
	private Boolean ordinal;
	private Number range;
	private Scrollbar scrollbar;
	private String top;
	private Number pane;
	private ArrayList<Stop> stops;

	public YAxis() {
	}

	/**
	 * @see #setAllowDecimals(Boolean)
	 */
	public Boolean getAllowDecimals() {
		return allowDecimals;
	}

	/**
	 * Whether to allow decimals in this axis' ticks. When counting integers,
	 * like persons or hits on a web page, decimals should be avoided in the
	 * labels.
	 * <p>
	 * Defaults to: true
	 */
	public void setAllowDecimals(Boolean allowDecimals) {
		this.allowDecimals = allowDecimals;
	}

	/**
	 * @see #setAlternateGridColor(Boolean)
	 */
	public Boolean getAlternateGridColor() {
		return alternateGridColor;
	}

	/**
	 * When using an alternate grid color, a band is painted across the plot
	 * area between every other grid line.
	 */
	public void setAlternateGridColor(Boolean alternateGridColor) {
		this.alternateGridColor = alternateGridColor;
	}

	/**
	 * @see #setAngle(Number)
	 */
	public Number getAngle() {
		return angle;
	}

	/**
	 * In a polar chart, this is the angle of the Y axis in degrees, where 0 is
	 * up and 90 is right. The angle determines the position of the axis line
	 * and the labels, though the coordinate system is unaffected.
	 * <p>
	 * Defaults to: 0
	 */
	public void setAngle(Number angle) {
		this.angle = angle;
	}

	/**
	 * @see #setBreaks(Breaks[])
	 */
	public Breaks[] getBreaks() {
		return breaks;
	}

	/**
	 * An array defining breaks in the axis, the sections defined will be left
	 * out and all the points shifted closer to each other. Requires that the
	 * broken-axis.js module is loaded.
	 */
	public void setBreaks(Breaks[] breaks) {
		this.breaks = breaks;
	}

	/**
	 * @see #setCategories(String...)
	 */
	public String[] getCategories() {
		if (categories == null) {
			return new String[]{};
		}
		String[] arr = new String[categories.size()];
		categories.toArray(arr);
		return arr;
	}

	/**
	 * <p>
	 * If categories are present for the xAxis, names are used instead of
	 * numbers for that axis. Since Highcharts 3.0, categories can also be
	 * extracted by giving each point a <a href="#series.data">name</a> and
	 * setting axis <a href="#xAxis.type">type</a> to <code>category</code>.
	 * However, if you have multiple series, best practice remains defining the
	 * <code>categories</code> array.
	 * </p>
	 * 
	 * <p>
	 * Example:
	 * 
	 * <pre>
	 * categories: ['Apples', 'Bananas', 'Oranges']
	 * </pre>
	 * 
	 * Defaults to <code>null</code>
	 * </p>
	 */
	public void setCategories(String... categories) {
		this.categories = new ArrayList<String>(Arrays.asList(categories));
	}

	/**
	 * Adds category to the categories array
	 * 
	 * @param category
	 *            to add
	 * @see #setCategories(String...)
	 */
	public void addCategory(String category) {
		if (this.categories == null) {
			this.categories = new ArrayList<String>();
		}
		this.categories.add(category);
	}

	/**
	 * Removes first occurrence of category in categories array
	 * 
	 * @param category
	 *            to remove
	 * @see #setCategories(String...)
	 */
	public void removeCategory(String category) {
		this.categories.remove(category);
	}

	/**
	 * @see #setCeiling(Number)
	 */
	public Number getCeiling() {
		return ceiling;
	}

	/**
	 * The highest allowed value for automatically computed axis extremes.
	 */
	public void setCeiling(Number ceiling) {
		this.ceiling = ceiling;
	}

	/**
	 * @see #setClassName(String)
	 */
	public String getClassName() {
		return className;
	}

	/**
	 * A class name that opens for styling the axis by CSS, especially in
	 * Highcharts <a href=
	 * "http://www.highcharts.com/docs/chart-design-and-style/style-by-css"
	 * >styled mode</a>. The class name is applied to group elements for the
	 * grid, axis elements and labels.
	 */
	public void setClassName(String className) {
		this.className = className;
	}

	/**
	 * @see #setCrosshair(Crosshair)
	 */
	public Crosshair getCrosshair() {
		if (crosshair == null) {
			crosshair = new Crosshair();
		}
		return crosshair;
	}

	/**
	 * <p>
	 * Configure a crosshair that follows either the mouse pointer or the
	 * hovered point.
	 * </p>
	 * 
	 * <p>
	 * In <a href=
	 * "http://www.highcharts.com/docs/chart-design-and-style/style-by-css"
	 * >styled mode</a>, the crosshairs are styled in the
	 * <code>.highcharts-crosshair</code>,
	 * <code>.highcharts-crosshair-thin</code> or
	 * <code>.highcharts-xaxis-category</code> classes.
	 * </p>
	 * <p>
	 * Defaults to: false
	 */
	public void setCrosshair(Crosshair crosshair) {
		this.crosshair = crosshair;
	}

	/**
	 * @see #setDateTimeLabelFormats(DateTimeLabelFormats)
	 */
	public DateTimeLabelFormats getDateTimeLabelFormats() {
		if (dateTimeLabelFormats == null) {
			dateTimeLabelFormats = new DateTimeLabelFormats();
		}
		return dateTimeLabelFormats;
	}

	/**
	 * For a datetime axis, the scale will automatically adjust to the
	 * appropriate unit. This member gives the default string representations
	 * used for each unit. For intermediate values, different units may be used,
	 * for example the <code>day</code> unit can be used on midnight and
	 * <code>hour</code> unit be used for intermediate values on the same axis.
	 * For an overview of the replacement codes, see <a
	 * href="#Highcharts.dateFormat">dateFormat</a>.
	 * 
	 * Defaults to:
	 * 
	 * <pre>
	 * {
	 * 		millisecond: '%H:%M:%S.%L',
	 * 		second: '%H:%M:%S',
	 * 		minute: '%H:%M',
	 * 		hour: '%H:%M',
	 * 		day: '%e. %b',
	 * 		week: '%e. %b',
	 * 		month: '%b \'%y',
	 * 		year: '%Y'
	 * 	}
	 * </pre>
	 */
	public void setDateTimeLabelFormats(
			DateTimeLabelFormats dateTimeLabelFormats) {
		this.dateTimeLabelFormats = dateTimeLabelFormats;
	}

	/**
	 * @see #setDescription(String)
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <p>
	 * <i>Requires Accessibility module</i>
	 * </p>
	 * 
	 * <p>
	 * Description of the axis to screen reader users.
	 * </p>
	 * <p>
	 * Defaults to: undefined
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @see #setEndOnTick(Boolean)
	 */
	public Boolean getEndOnTick() {
		return endOnTick;
	}

	/**
	 * Whether to force the axis to end on a tick. Use this option with the
	 * <code>maxPadding</code> option to control the axis end.
	 * <p>
	 * Defaults to: true
	 */
	public void setEndOnTick(Boolean endOnTick) {
		this.endOnTick = endOnTick;
	}

	/**
	 * @see #setFloor(Number)
	 */
	public Number getFloor() {
		return floor;
	}

	/**
	 * The lowest allowed value for automatically computed axis extremes.
	 * <p>
	 * Defaults to: null
	 */
	public void setFloor(Number floor) {
		this.floor = floor;
	}

	/**
	 * @see #setGridLineInterpolation(String)
	 */
	public String getGridLineInterpolation() {
		return gridLineInterpolation;
	}

	/**
	 * Polar charts only. Whether the grid lines should draw as a polygon with
	 * straight lines between categories, or as circles. Can be either
	 * <code>circle</code> or <code>polygon</code>.
	 * <p>
	 * Defaults to: null
	 */
	public void setGridLineInterpolation(String gridLineInterpolation) {
		this.gridLineInterpolation = gridLineInterpolation;
	}

	/**
	 * @see #setGridZIndex(Number)
	 */
	public Number getGridZIndex() {
		return gridZIndex;
	}

	/**
	 * The Z index of the grid lines.
	 * <p>
	 * Defaults to: 1
	 */
	public void setGridZIndex(Number gridZIndex) {
		this.gridZIndex = gridZIndex;
	}

	/**
	 * @see #setId(String)
	 */
	public String getId() {
		return id;
	}

	/**
	 * An id for the axis. This can be used after render time to get a pointer
	 * to the axis object through <code>chart.get()</code>.
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @see #setLabels(Labels)
	 */
	public Labels getLabels() {
		if (labels == null) {
			labels = new Labels();
		}
		return labels;
	}

	public void setLabels(Labels labels) {
		this.labels = labels;
	}

	/**
	 * @see #setLinkedTo(Number)
	 */
	public Number getLinkedTo() {
		return linkedTo;
	}

	/**
	 * Index of another axis that this axis is linked to. When an axis is linked
	 * to a master axis, it will take the same extremes as the master, but as
	 * assigned by min or max or by setExtremes. It can be used to show
	 * additional info, or to ease reading the chart by duplicating the scales.
	 */
	public void setLinkedTo(Number linkedTo) {
		this.linkedTo = linkedTo;
	}

	/**
	 * @see #setMaxPadding(Number)
	 */
	public Number getMaxPadding() {
		return maxPadding;
	}

	/**
	 * Padding of the max value relative to the length of the axis. A padding of
	 * 0.05 will make a 100px axis 5px longer. This is useful when you don't
	 * want the highest data value to appear on the edge of the plot area.
	 * <p>
	 * Defaults to: 0.05
	 */
	public void setMaxPadding(Number maxPadding) {
		this.maxPadding = maxPadding;
	}

	/**
	 * @see #setMinPadding(Number)
	 */
	public Number getMinPadding() {
		return minPadding;
	}

	/**
	 * Padding of the min value relative to the length of the axis. A padding of
	 * 0.05 will make a 100px axis 5px longer. This is useful when you don't
	 * want the lowest data value to appear on the edge of the plot area.
	 * <p>
	 * Defaults to: 0.05
	 */
	public void setMinPadding(Number minPadding) {
		this.minPadding = minPadding;
	}

	/**
	 * @see #setMinRange(Number)
	 */
	public Number getMinRange() {
		return minRange;
	}

	/**
	 * <p>
	 * The minimum range to display on this axis. The entire axis will not be
	 * allowed to span over a smaller interval than this. For example, for a
	 * datetime axis the main unit is milliseconds. If minRange is set to
	 * 3600000, you can't zoom in more than to one hour.
	 * </p>
	 * 
	 * <p>
	 * The default minRange for the x axis is five times the smallest interval
	 * between any of the data points.
	 * </p>
	 * 
	 * <p>
	 * On a logarithmic axis, the unit for the minimum range is the power. So a
	 * minRange of 1 means that the axis can be zoomed to 10-100, 100-1000,
	 * 1000-10000 etc.
	 * </p>
	 * 
	 * <p>
	 * Note that the <code>minPadding</code>, <code>maxPadding</code>,
	 * <code>startOnTick</code> and <code>endOnTick</code> settings also affect
	 * how the extremes of the axis are computed.
	 * </p>
	 */
	public void setMinRange(Number minRange) {
		this.minRange = minRange;
	}

	/**
	 * @see #setMinTickInterval(Number)
	 */
	public Number getMinTickInterval() {
		return minTickInterval;
	}

	/**
	 * The minimum tick interval allowed in axis values. For example on zooming
	 * in on an axis with daily data, this can be used to prevent the axis from
	 * showing hours. Defaults to the closest distance between two points on the
	 * axis.
	 */
	public void setMinTickInterval(Number minTickInterval) {
		this.minTickInterval = minTickInterval;
	}

	/**
	 * @see #setMinorTickInterval(String)
	 */
	public String getMinorTickInterval() {
		return minorTickInterval;
	}

	/**
	 * <p>
	 * Tick interval in scale units for the minor ticks. On a linear axis, if
	 * <code>"auto"</code>, the minor tick interval is calculated as a fifth of
	 * the tickInterval. If <code>null</code>, minor ticks are not shown.
	 * </p>
	 * <p>
	 * On logarithmic axes, the unit is the power of the value. For example,
	 * setting the minorTickInterval to 1 puts one tick on each of 0.1, 1, 10,
	 * 100 etc. Setting the minorTickInterval to 0.1 produces 9 ticks between 1
	 * and 10, 10 and 100 etc. A minorTickInterval of "auto" on a log axis
	 * results in a best guess, attempting to enter approximately 5 minor ticks
	 * between each major tick.
	 * </p>
	 * 
	 * <p>
	 * If user settings dictate minor ticks to become too dense, they don't make
	 * sense, and will be ignored to prevent performance problems.</a>
	 * 
	 * <p>
	 * On axes using <a href="#xAxis.categories">categories</a>, minor ticks are
	 * not supported.
	 * </p>
	 */
	public void setMinorTickInterval(String minorTickInterval) {
		this.minorTickInterval = minorTickInterval;
	}

	/**
	 * @see #setMinorTickLength(Number)
	 */
	public Number getMinorTickLength() {
		return minorTickLength;
	}

	/**
	 * The pixel length of the minor tick marks.
	 * <p>
	 * Defaults to: 2
	 */
	public void setMinorTickLength(Number minorTickLength) {
		this.minorTickLength = minorTickLength;
	}

	/**
	 * @see #setMinorTickPosition(TickPosition)
	 */
	public TickPosition getMinorTickPosition() {
		return minorTickPosition;
	}

	/**
	 * The position of the minor tick marks relative to the axis line. Can be
	 * one of <code>inside</code> and <code>outside</code>.
	 * <p>
	 * Defaults to: outside
	 */
	public void setMinorTickPosition(TickPosition minorTickPosition) {
		this.minorTickPosition = minorTickPosition;
	}

	/**
	 * @see #setOffset(Number)
	 */
	public Number getOffset() {
		return offset;
	}

	/**
	 * The distance in pixels from the plot area to the axis line. A positive
	 * offset moves the axis with it's line, labels and ticks away from the plot
	 * area. This is typically used when two or more axes are displayed on the
	 * same side of the plot. With multiple axes the offset is dynamically
	 * adjusted to avoid collision, this can be overridden by setting offset
	 * explicitly.
	 * <p>
	 * Defaults to: 0
	 */
	public void setOffset(Number offset) {
		this.offset = offset;
	}

	/**
	 * @see #setOpposite(Boolean)
	 */
	public Boolean getOpposite() {
		return opposite;
	}

	/**
	 * Whether to display the axis on the opposite side of the normal. The
	 * normal is on the left side for vertical axes and bottom for horizontal,
	 * so the opposite sides will be right and top respectively. This is
	 * typically used with dual or multiple axes.
	 * <p>
	 * Defaults to: false
	 */
	public void setOpposite(Boolean opposite) {
		this.opposite = opposite;
	}

	/**
	 * @see #setPlotBands(PlotBand...)
	 */
	public PlotBand[] getPlotBands() {
		if (plotBands == null) {
			return new PlotBand[]{};
		}
		PlotBand[] arr = new PlotBand[plotBands.size()];
		plotBands.toArray(arr);
		return arr;
	}

	/**
	 * An array of objects defining plot bands on the Y axis.
	 */
	public void setPlotBands(PlotBand... plotBands) {
		this.plotBands = new ArrayList<PlotBand>(Arrays.asList(plotBands));
	}

	/**
	 * Adds plotBand to the plotBands array
	 * 
	 * @param plotBand
	 *            to add
	 * @see #setPlotBands(PlotBand...)
	 */
	public void addPlotBand(PlotBand plotBand) {
		if (this.plotBands == null) {
			this.plotBands = new ArrayList<PlotBand>();
		}
		this.plotBands.add(plotBand);
	}

	/**
	 * Removes first occurrence of plotBand in plotBands array
	 * 
	 * @param plotBand
	 *            to remove
	 * @see #setPlotBands(PlotBand...)
	 */
	public void removePlotBand(PlotBand plotBand) {
		this.plotBands.remove(plotBand);
	}

	/**
	 * @see #setPlotLines(PlotLine...)
	 */
	public PlotLine[] getPlotLines() {
		if (plotLines == null) {
			return new PlotLine[]{};
		}
		PlotLine[] arr = new PlotLine[plotLines.size()];
		plotLines.toArray(arr);
		return arr;
	}

	/**
	 * An array of objects representing plot lines on the X axis
	 */
	public void setPlotLines(PlotLine... plotLines) {
		this.plotLines = new ArrayList<PlotLine>(Arrays.asList(plotLines));
	}

	/**
	 * Adds plotLine to the plotLines array
	 * 
	 * @param plotLine
	 *            to add
	 * @see #setPlotLines(PlotLine...)
	 */
	public void addPlotLine(PlotLine plotLine) {
		if (this.plotLines == null) {
			this.plotLines = new ArrayList<PlotLine>();
		}
		this.plotLines.add(plotLine);
	}

	/**
	 * Removes first occurrence of plotLine in plotLines array
	 * 
	 * @param plotLine
	 *            to remove
	 * @see #setPlotLines(PlotLine...)
	 */
	public void removePlotLine(PlotLine plotLine) {
		this.plotLines.remove(plotLine);
	}

	/**
	 * @see #setReversed(Boolean)
	 */
	public Boolean getReversed() {
		return reversed;
	}

	/**
	 * Whether to reverse the axis so that the highest number is closest to the
	 * origin. If the chart is inverted, the x axis is reversed by default.
	 * <p>
	 * Defaults to: false
	 */
	public void setReversed(Boolean reversed) {
		this.reversed = reversed;
	}

	/**
	 * @see #setReversedStacks(Boolean)
	 */
	public Boolean getReversedStacks() {
		return reversedStacks;
	}

	/**
	 * If <code>true</code>, the first series in a stack will be drawn on top in
	 * a positive, non-reversed Y axis. If <code>false</code>, the first series
	 * is in the base of the stack.
	 * <p>
	 * Defaults to: true
	 */
	public void setReversedStacks(Boolean reversedStacks) {
		this.reversedStacks = reversedStacks;
	}

	/**
	 * @see #setShowEmpty(Boolean)
	 */
	public Boolean getShowEmpty() {
		return showEmpty;
	}

	/**
	 * Whether to show the axis line and title when the axis has no data.
	 * <p>
	 * Defaults to: true
	 */
	public void setShowEmpty(Boolean showEmpty) {
		this.showEmpty = showEmpty;
	}

	/**
	 * @see #setShowFirstLabel(Boolean)
	 */
	public Boolean getShowFirstLabel() {
		return showFirstLabel;
	}

	/**
	 * Whether to show the first tick label.
	 * <p>
	 * Defaults to: true
	 */
	public void setShowFirstLabel(Boolean showFirstLabel) {
		this.showFirstLabel = showFirstLabel;
	}

	/**
	 * @see #setShowLastLabel(Boolean)
	 */
	public Boolean getShowLastLabel() {
		return showLastLabel;
	}

	/**
	 * Whether to show the last tick label. Defaults to <code>true</code> on
	 * cartesian charts, and <code>false</code> on polar charts.
	 */
	public void setShowLastLabel(Boolean showLastLabel) {
		this.showLastLabel = showLastLabel;
	}

	/**
	 * @see #setSoftMax(Number)
	 */
	public Number getSoftMax() {
		return softMax;
	}

	/**
	 * A soft maximum for the axis. If the series data maximum is less than
	 * this, the axis will stay at this maximum, but if the series data maximum
	 * is higher, the axis will flex to show all data.
	 */
	public void setSoftMax(Number softMax) {
		this.softMax = softMax;
	}

	/**
	 * @see #setSoftMin(Number)
	 */
	public Number getSoftMin() {
		return softMin;
	}

	/**
	 * A soft minimum for the axis. If the series data minimum is greater than
	 * this, the axis will stay at this minimum, but if the series data minimum
	 * is lower, the axis will flex to show all data.
	 */
	public void setSoftMin(Number softMin) {
		this.softMin = softMin;
	}

	/**
	 * @see #setStackLabels(StackLabels)
	 */
	public StackLabels getStackLabels() {
		if (stackLabels == null) {
			stackLabels = new StackLabels();
		}
		return stackLabels;
	}

	/**
	 * The stack labels show the total value for each bar in a stacked column or
	 * bar chart. The label will be placed on top of positive columns and below
	 * negative columns. In case of an inverted column chart or a bar chart the
	 * label is placed to the right of positive bars and to the left of negative
	 * bars.
	 */
	public void setStackLabels(StackLabels stackLabels) {
		this.stackLabels = stackLabels;
	}

	/**
	 * @see #setStartOfWeek(Number)
	 */
	public Number getStartOfWeek() {
		return startOfWeek;
	}

	/**
	 * For datetime axes, this decides where to put the tick between weeks. 0 =
	 * Sunday, 1 = Monday.
	 * <p>
	 * Defaults to: 1
	 */
	public void setStartOfWeek(Number startOfWeek) {
		this.startOfWeek = startOfWeek;
	}

	/**
	 * @see #setStartOnTick(Boolean)
	 */
	public Boolean getStartOnTick() {
		return startOnTick;
	}

	/**
	 * Whether to force the axis to start on a tick. Use this option with the
	 * <code>maxPadding</code> option to control the axis start.
	 * <p>
	 * Defaults to: true
	 */
	public void setStartOnTick(Boolean startOnTick) {
		this.startOnTick = startOnTick;
	}

	/**
	 * @see #setTickAmount(Number)
	 */
	public Number getTickAmount() {
		return tickAmount;
	}

	/**
	 * <p>
	 * The amount of ticks to draw on the axis. This opens up for aligning the
	 * ticks of multiple charts or panes within a chart. This option overrides
	 * the <code>tickPixelInterval</code> option.
	 * </p>
	 * <p>
	 * This option only has an effect on linear axes. Datetime, logarithmic or
	 * category axes are not affected.
	 * </p>
	 */
	public void setTickAmount(Number tickAmount) {
		this.tickAmount = tickAmount;
	}

	/**
	 * @see #setTickInterval(Number)
	 */
	public Number getTickInterval() {
		return tickInterval;
	}

	/**
	 * <p>
	 * The interval of the tick marks in axis units. When <code>null</code>, the
	 * tick interval is computed to approximately follow the <a
	 * href="#xAxis.tickPixelInterval">tickPixelInterval</a> on linear and
	 * datetime axes. On categorized axes, a <code>null</code> tickInterval will
	 * default to 1, one category. Note that datetime axes are based on
	 * milliseconds, so for example an interval of one day is expressed as
	 * <code>24 * 3600 * 1000</code>.
	 * </p>
	 * <p>
	 * On logarithmic axes, the tickInterval is based on powers, so a
	 * tickInterval of 1 means one tick on each of 0.1, 1, 10, 100 etc. A
	 * tickInterval of 2 means a tick of 0.1, 10, 1000 etc. A tickInterval of
	 * 0.2 puts a tick on 0.1, 0.2, 0.4, 0.6, 0.8, 1, 2, 4, 6, 8, 10, 20, 40
	 * etc.
	 * </p>
	 * 
	 * <p>
	 * If the tickInterval is too dense for labels to be drawn, Highcharts may
	 * remove ticks.
	 * </p>
	 * 
	 * <p>
	 * If the chart has multiple axes, the <a
	 * href="#chart.alignTicks">alignTicks</a> option may interfere with the
	 * <code>tickInterval</code> setting.
	 * </p>
	 */
	public void setTickInterval(Number tickInterval) {
		this.tickInterval = tickInterval;
	}

	/**
	 * @see #setTickLength(Number)
	 */
	public Number getTickLength() {
		return tickLength;
	}

	/**
	 * The pixel length of the main tick marks.
	 * <p>
	 * Defaults to: 10
	 */
	public void setTickLength(Number tickLength) {
		this.tickLength = tickLength;
	}

	/**
	 * @see #setTickPixelInterval(Number)
	 */
	public Number getTickPixelInterval() {
		return tickPixelInterval;
	}

	/**
	 * <p>
	 * If tickInterval is <code>null</code> this option sets the approximate
	 * pixel interval of the tick marks. Not applicable to categorized axis.
	 * </p>
	 * 
	 * <p>
	 * The tick interval is also influenced by the <a
	 * href="#xAxis.minTickInterval">minTickInterval</a> option, that, by
	 * default prevents ticks from being denser than the data points.
	 * </p>
	 * 
	 * <p>
	 * Defaults to <code>72</code> for the Y axis and <code>100</code> for the X
	 * axis.
	 * </p>
	 */
	public void setTickPixelInterval(Number tickPixelInterval) {
		this.tickPixelInterval = tickPixelInterval;
	}

	/**
	 * @see #setTickPosition(TickPosition)
	 */
	public TickPosition getTickPosition() {
		return tickPosition;
	}

	/**
	 * The position of the major tick marks relative to the axis line. Can be
	 * one of <code>inside</code> and <code>outside</code>.
	 * <p>
	 * Defaults to: outside
	 */
	public void setTickPosition(TickPosition tickPosition) {
		this.tickPosition = tickPosition;
	}

	/**
	 * @see #setTickPositions(Number[])
	 */
	public Number[] getTickPositions() {
		return tickPositions;
	}

	/**
	 * An array defining where the ticks are laid out on the axis. This
	 * overrides the default behaviour of <a
	 * href="#xAxis.tickPixelInterval">tickPixelInterval</a> and <a
	 * href="#xAxis.tickInterval">tickInterval</a>.
	 */
	public void setTickPositions(Number[] tickPositions) {
		this.tickPositions = tickPositions;
	}

	/**
	 * @see #setTickmarkPlacement(TickmarkPlacement)
	 */
	public TickmarkPlacement getTickmarkPlacement() {
		return tickmarkPlacement;
	}

	/**
	 * For categorized axes only. If <code>on</code> the tick mark is placed in
	 * the center of the category, if <code>between</code> the tick mark is
	 * placed between categories. The default is <code>between</code> if the
	 * <code>tickInterval</code> is 1, else <code>on</code>.
	 * <p>
	 * Defaults to: null
	 */
	public void setTickmarkPlacement(TickmarkPlacement tickmarkPlacement) {
		this.tickmarkPlacement = tickmarkPlacement;
	}

	/**
	 * @see #setTitle(AxisTitle)
	 */
	public AxisTitle getTitle() {
		if (title == null) {
			title = new AxisTitle();
		}
		return title;
	}

	public void setTitle(AxisTitle title) {
		this.title = title;
	}

	/**
	 * @see #setType(AxisType)
	 */
	public AxisType getType() {
		return type;
	}

	/**
	 * The type of axis. Can be one of <code>linear</code>,
	 * <code>logarithmic</code>, <code>datetime</code> or <code>category</code>.
	 * In a datetime axis, the numbers are given in milliseconds, and tick marks
	 * are placed on appropriate values like full hours or days. In a category
	 * axis, the <a href="#series<line>.data.name">point names</a> of the
	 * chart's series are used for categories, if not a <a
	 * href="#xAxis.categories">categories</a> array is defined.
	 * <p>
	 * Defaults to: linear
	 */
	public void setType(AxisType type) {
		this.type = type;
	}

	/**
	 * @see #setUniqueNames(Boolean)
	 */
	public Boolean getUniqueNames() {
		return uniqueNames;
	}

	/**
	 * Applies only when the axis <code>type</code> is <code>category</code>.
	 * When <code>uniqueNames</code> is true, points are placed on the X axis
	 * according to their names. If the same point name is repeated in the same
	 * or another series, the point is placed on the same X position as other
	 * points of the same name. When <code>uniqueNames</code> is false, the
	 * points are laid out in increasing X positions regardless of their names,
	 * and the X axis category will take the name of the last point in each
	 * position.
	 * <p>
	 * Defaults to: true
	 */
	public void setUniqueNames(Boolean uniqueNames) {
		this.uniqueNames = uniqueNames;
	}

	/**
	 * @see #setUnits(TimeUnitMultiples...)
	 */
	public TimeUnitMultiples[] getUnits() {
		if (units == null) {
			return new TimeUnitMultiples[]{};
		}
		TimeUnitMultiples[] arr = new TimeUnitMultiples[units.size()];
		units.toArray(arr);
		return arr;
	}

	/**
	 * Datetime axis only. An array determining what time intervals the ticks
	 * are allowed to fall on. Each array item is an array where the first value
	 * is the time unit and the second value another array of allowed multiples.
	 * Defaults to:
	 * 
	 * <pre>
	 * units: [[
	 * 		'millisecond', // unit name
	 * 		[1, 2, 5, 10, 20, 25, 50, 100, 200, 500] // allowed multiples
	 * 	], [
	 * 		'second',
	 * 		[1, 2, 5, 10, 15, 30]
	 * 	], [
	 * 		'minute',
	 * 		[1, 2, 5, 10, 15, 30]
	 * 	], [
	 * 		'hour',
	 * 		[1, 2, 3, 4, 6, 8, 12]
	 * 	], [
	 * 		'day',
	 * 		[1]
	 * 	], [
	 * 		'week',
	 * 		[1]
	 * 	], [
	 * 		'month',
	 * 		[1, 3, 6]
	 * 	], [
	 * 		'year',
	 * 		null
	 * 	]]
	 * </pre>
	 */
	public void setUnits(TimeUnitMultiples... units) {
		this.units = new ArrayList<TimeUnitMultiples>(Arrays.asList(units));
	}

	/**
	 * Adds unit to the units array
	 * 
	 * @param unit
	 *            to add
	 * @see #setUnits(TimeUnitMultiples...)
	 */
	public void addUnit(TimeUnitMultiples unit) {
		if (this.units == null) {
			this.units = new ArrayList<TimeUnitMultiples>();
		}
		this.units.add(unit);
	}

	/**
	 * Removes first occurrence of unit in units array
	 * 
	 * @param unit
	 *            to remove
	 * @see #setUnits(TimeUnitMultiples...)
	 */
	public void removeUnit(TimeUnitMultiples unit) {
		this.units.remove(unit);
	}

	/**
	 * @see #setVisible(Boolean)
	 */
	public Boolean getVisible() {
		return visible;
	}

	/**
	 * Whether axis, including axis title, line, ticks and labels, should be
	 * visible.
	 * <p>
	 * Defaults to: true
	 */
	public void setVisible(Boolean visible) {
		this.visible = visible;
	}

	/**
	 * @see #setHeight(String)
	 */
	public String getHeight() {
		return height;
	}

	/**
	 * <p>
	 * The height of the Y axis. If it's a number, it is interpreted as pixels.
	 * </p>
	 * <p>
	 * Since Highstock 2: If it's a percentage string, it is interpreted as
	 * percentages of the total plot height.
	 * </p>
	 * <p>
	 * Defaults to: null
	 */
	public void setHeight(String height) {
		this.height = height;
	}

	/**
	 * @see #setOrdinal(Boolean)
	 */
	public Boolean getOrdinal() {
		return ordinal;
	}

	/**
	 * In an ordinal axis, the points are equally spaced in the chart regardless
	 * of the actual time or x distance between them. This means that missing
	 * data for nights or weekends will not take up space in the chart.
	 * <p>
	 * Defaults to: true
	 */
	public void setOrdinal(Boolean ordinal) {
		this.ordinal = ordinal;
	}

	/**
	 * @see #setRange(Number)
	 */
	public Number getRange() {
		return range;
	}

	/**
	 * The zoomed range to display when only defining one or none of
	 * <code>min</code> or <code>max</code>. For example, to show the latest
	 * month, a range of one month can be set.
	 * <p>
	 * Defaults to: undefined
	 */
	public void setRange(Number range) {
		this.range = range;
	}

	/**
	 * @see #setScrollbar(Scrollbar)
	 */
	public Scrollbar getScrollbar() {
		if (scrollbar == null) {
			scrollbar = new Scrollbar();
		}
		return scrollbar;
	}

	/**
	 * <p>
	 * An optional scrollbar to display on the Y axis in response to limiting
	 * the minimum an maximum of the axis values.
	 * </p>
	 * 
	 * <p>
	 * In <a href=
	 * "http://www.highcharts.com/docs/chart-design-and-style/style-by-css"
	 * >styled mode</a>, all the presentational options for the scrollbar are
	 * replaced by the classes <code>.highcharts-scrollbar-thumb</code>,
	 * <code>.highcharts-scrollbar-arrow</code>,
	 * <code>.highcharts-scrollbar-button</code>,
	 * <code>.highcharts-scrollbar-rifles</code> and
	 * <code>.highcharts-scrollbar-track</code>.
	 * </p>
	 */
	public void setScrollbar(Scrollbar scrollbar) {
		this.scrollbar = scrollbar;
	}

	/**
	 * @see #setTop(String)
	 */
	public String getTop() {
		return top;
	}

	/**
	 * <p>
	 * The top position of the Y axis. If it's a number, it is interpreted as
	 * pixel position relative to the chart.
	 * </p>
	 * <p>
	 * Since Highstock 2: If it's a percentage string, it is interpreted as
	 * percentages of the plot height, offset from plot area top.
	 * </p>
	 * <p>
	 * Defaults to: null
	 */
	public void setTop(String top) {
		this.top = top;
	}

	public Number getPane() {
		return pane;
	}

	public void setPane(Number pane) {
		this.pane = pane;
	}

	public void setPane(Pane pane) {
		if (pane.getPaneIndex() == null) {
			throw new IllegalStateException(
					"Pane must be attached to configuration");
		}
		this.pane = pane.getPaneIndex();
	}

	public void setTitle(String title) {
		AxisTitle t = new AxisTitle();
		t.setText(title);
		this.setTitle(t);
	}

	public void setLinkedTo(YAxis axis) {
		linkedTo = axis.getAxisIndex();
	}

	/**
	 * @see #setStops(Stop...)
	 */
	public Stop[] getStops() {
		if (stops == null) {
			return new Stop[]{};
		}
		Stop[] arr = new Stop[stops.size()];
		stops.toArray(arr);
		return arr;
	}

	public void setStops(Stop... stops) {
		this.stops = new ArrayList<Stop>(Arrays.asList(stops));
	}

	/**
	 * Adds stop to the stops array
	 * 
	 * @param stop
	 *            to add
	 * @see #setStops(Stop...)
	 */
	public void addStop(Stop stop) {
		if (this.stops == null) {
			this.stops = new ArrayList<Stop>();
		}
		this.stops.add(stop);
	}

	/**
	 * Removes first occurrence of stop in stops array
	 * 
	 * @param stop
	 *            to remove
	 * @see #setStops(Stop...)
	 */
	public void removeStop(Stop stop) {
		this.stops.remove(stop);
	}
}
