/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.charts.ProxyChangeForwarder;
import com.vaadin.flow.component.charts.events.ChartAddSeriesEvent;
import com.vaadin.flow.component.charts.events.ChartAfterPrintEvent;
import com.vaadin.flow.component.charts.events.ChartBeforePrintEvent;
import com.vaadin.flow.component.charts.events.ChartClickEvent;
import com.vaadin.flow.component.charts.events.ChartDrillupAllEvent;
import com.vaadin.flow.component.charts.events.ChartDrillupEvent;
import com.vaadin.flow.component.charts.events.ChartLoadEvent;
import com.vaadin.flow.component.charts.events.ChartRedrawEvent;
import com.vaadin.flow.component.charts.events.ChartSelectionEvent;
import com.vaadin.flow.component.charts.events.DrilldownEvent;
import com.vaadin.flow.component.charts.events.PointClickEvent;
import com.vaadin.flow.component.charts.events.PointLegendItemClickEvent;
import com.vaadin.flow.component.charts.events.PointMouseOutEvent;
import com.vaadin.flow.component.charts.events.PointMouseOverEvent;
import com.vaadin.flow.component.charts.events.PointRemoveEvent;
import com.vaadin.flow.component.charts.events.PointSelectEvent;
import com.vaadin.flow.component.charts.events.PointUnselectEvent;
import com.vaadin.flow.component.charts.events.PointUpdateEvent;
import com.vaadin.flow.component.charts.events.SeriesAfterAnimateEvent;
import com.vaadin.flow.component.charts.events.SeriesCheckboxClickEvent;
import com.vaadin.flow.component.charts.events.SeriesClickEvent;
import com.vaadin.flow.component.charts.events.SeriesHideEvent;
import com.vaadin.flow.component.charts.events.SeriesLegendItemClickEvent;
import com.vaadin.flow.component.charts.events.SeriesMouseOutEvent;
import com.vaadin.flow.component.charts.events.SeriesMouseOverEvent;
import com.vaadin.flow.component.charts.events.SeriesShowEvent;
import com.vaadin.flow.component.charts.events.XAxesExtremesSetEvent;
import com.vaadin.flow.component.charts.events.YAxesExtremesSetEvent;
import com.vaadin.flow.component.charts.events.internal.ConfigurationChangeListener;
import com.vaadin.flow.component.charts.model.ChartType;
import com.vaadin.flow.component.charts.model.Configuration;
import com.vaadin.flow.component.charts.util.ChartSerialization;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.impl.JreJsonFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@Tag(value="vaadin-chart")
@NpmPackage(value="@vaadin/vaadin-charts", version="6.2.3")
@JsModule(value="@vaadin/vaadin-charts/vaadin-chart.js")
@HtmlImport(value="frontend://bower_components/vaadin-charts/vaadin-chart.html")
public class Chart
extends Component
implements HasStyle,
HasSize {
    private Configuration configuration;
    private transient JreJsonFactory jsonFactory = new JreJsonFactory();
    private final ConfigurationChangeListener changeListener = new ProxyChangeForwarder(this);
    private static final List<ChartType> TIMELINE_NOT_SUPPORTED = Arrays.asList(ChartType.PIE, ChartType.GAUGE, ChartType.SOLIDGAUGE, ChartType.PYRAMID, ChartType.FUNNEL);

    public Chart() {
        this.configuration = new Configuration();
    }

    public Chart(ChartType type) {
        this();
        this.getConfiguration().getChart().setType(type);
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        attachEvent.getUI().beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> {
            this.drawChart();
            if (this.configuration != null) {
                this.configuration.addChangeListener(this.changeListener);
            }
        });
    }

    JreJsonFactory getJsonFactory() {
        if (this.jsonFactory == null) {
            this.jsonFactory = new JreJsonFactory();
        }
        return this.jsonFactory;
    }

    public void drawChart() {
        this.drawChart(false);
    }

    public void drawChart(boolean resetConfiguration) {
        this.validateTimelineAndConfiguration();
        JsonObject configurationNode = (JsonObject)this.getJsonFactory().parse(ChartSerialization.toJSON(this.configuration));
        this.getElement().callFunction("update", new Serializable[]{configurationNode, Boolean.valueOf(resetConfiguration)});
    }

    public void setTimeline(Boolean timeline) {
        this.getElement().setProperty("timeline", timeline.booleanValue());
    }

    private void validateTimelineAndConfiguration() {
        ChartType type;
        if (this.getElement().getProperty("timeline", false) && TIMELINE_NOT_SUPPORTED.contains(type = this.getConfiguration().getChart().getType())) {
            throw new IllegalArgumentException("Timeline is not supported for chart type '" + type + "'");
        }
    }

    public void setVisibilityTogglingDisabled(boolean disabled) {
        this.getElement().setProperty("_visibilityTogglingDisabled", disabled);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Registration addChartAddSeriesListener(ComponentEventListener<ChartAddSeriesEvent> listener) {
        return this.addListener(ChartAddSeriesEvent.class, listener);
    }

    public Registration addChartAfterPrintListener(ComponentEventListener<ChartAfterPrintEvent> listener) {
        return this.addListener(ChartAfterPrintEvent.class, listener);
    }

    public Registration addChartBeforePrintListener(ComponentEventListener<ChartBeforePrintEvent> listener) {
        return this.addListener(ChartBeforePrintEvent.class, listener);
    }

    public Registration addChartClickListener(ComponentEventListener<ChartClickEvent> listener) {
        return this.addListener(ChartClickEvent.class, listener);
    }

    public Registration addChartDrillupListener(ComponentEventListener<ChartDrillupEvent> listener) {
        return this.addListener(ChartDrillupEvent.class, listener);
    }

    public Registration addChartDrillupAllListener(ComponentEventListener<ChartDrillupAllEvent> listener) {
        return this.addListener(ChartDrillupAllEvent.class, listener);
    }

    public Registration addChartLoadListener(ComponentEventListener<ChartLoadEvent> listener) {
        return this.addListener(ChartLoadEvent.class, listener);
    }

    public Registration addChartRedrawListener(ComponentEventListener<ChartRedrawEvent> listener) {
        return this.addListener(ChartRedrawEvent.class, listener);
    }

    public Registration addCheckBoxClickListener(ComponentEventListener<SeriesCheckboxClickEvent> listener) {
        return this.addListener(SeriesCheckboxClickEvent.class, listener);
    }

    public Registration addDrilldownListener(ComponentEventListener<DrilldownEvent> listener) {
        return this.addListener(DrilldownEvent.class, listener);
    }

    public Registration addChartSelectionListener(ComponentEventListener<ChartSelectionEvent> listener) {
        return this.addListener(ChartSelectionEvent.class, listener);
    }

    public Registration addSeriesLegendItemClickListener(ComponentEventListener<SeriesLegendItemClickEvent> listener) {
        return this.addListener(SeriesLegendItemClickEvent.class, listener);
    }

    public Registration addPointLegendItemClickListener(ComponentEventListener<PointLegendItemClickEvent> listener) {
        return this.addListener(PointLegendItemClickEvent.class, listener);
    }

    public Registration addSeriesAfterAnimateListener(ComponentEventListener<SeriesAfterAnimateEvent> listener) {
        return this.addListener(SeriesAfterAnimateEvent.class, listener);
    }

    public Registration addSeriesClickListener(ComponentEventListener<SeriesClickEvent> listener) {
        return this.addListener(SeriesClickEvent.class, listener);
    }

    public Registration addSeriesHideListener(ComponentEventListener<SeriesHideEvent> listener) {
        return this.addListener(SeriesHideEvent.class, listener);
    }

    public Registration addSeriesMouseOutListener(ComponentEventListener<SeriesMouseOutEvent> listener) {
        return this.addListener(SeriesMouseOutEvent.class, listener);
    }

    public Registration addSeriesMouseOverListener(ComponentEventListener<SeriesMouseOverEvent> listener) {
        return this.addListener(SeriesMouseOverEvent.class, listener);
    }

    public Registration addSeriesShowListener(ComponentEventListener<SeriesShowEvent> listener) {
        return this.addListener(SeriesShowEvent.class, listener);
    }

    public Registration addPointClickListener(ComponentEventListener<PointClickEvent> listener) {
        return this.addListener(PointClickEvent.class, listener);
    }

    public Registration addPointMouseOutListener(ComponentEventListener<PointMouseOutEvent> listener) {
        return this.addListener(PointMouseOutEvent.class, listener);
    }

    public Registration addPointMouseOverListener(ComponentEventListener<PointMouseOverEvent> listener) {
        return this.addListener(PointMouseOverEvent.class, listener);
    }

    public Registration addPointRemoveListener(ComponentEventListener<PointRemoveEvent> listener) {
        return this.addListener(PointRemoveEvent.class, listener);
    }

    public Registration addPointSelectListener(ComponentEventListener<PointSelectEvent> listener) {
        return this.addListener(PointSelectEvent.class, listener);
    }

    public Registration addPointUnselectListener(ComponentEventListener<PointUnselectEvent> listener) {
        return this.addListener(PointUnselectEvent.class, listener);
    }

    public Registration addPointUpdateListener(ComponentEventListener<PointUpdateEvent> listener) {
        return this.addListener(PointUpdateEvent.class, listener);
    }

    public Registration addXAxesExtremesSetListener(ComponentEventListener<XAxesExtremesSetEvent> listener) {
        return this.addListener(XAxesExtremesSetEvent.class, listener);
    }

    public Registration addYAxesExtremesSetListener(ComponentEventListener<YAxesExtremesSetEvent> listener) {
        return this.addListener(YAxesExtremesSetEvent.class, listener);
    }
}

