/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts;

import com.vaadin.flow.component.charts.Chart;
import com.vaadin.flow.component.charts.events.internal.AbstractSeriesEvent;
import com.vaadin.flow.component.charts.events.internal.AxisRescaledEvent;
import com.vaadin.flow.component.charts.events.internal.ConfigurationChangeListener;
import com.vaadin.flow.component.charts.events.internal.DataAddedEvent;
import com.vaadin.flow.component.charts.events.internal.DataRemovedEvent;
import com.vaadin.flow.component.charts.events.internal.DataUpdatedEvent;
import com.vaadin.flow.component.charts.events.internal.ItemSlicedEvent;
import com.vaadin.flow.component.charts.events.internal.SeriesAddedEvent;
import com.vaadin.flow.component.charts.events.internal.SeriesChangedEvent;
import com.vaadin.flow.component.charts.events.internal.SeriesStateEvent;
import com.vaadin.flow.component.charts.model.AbstractConfigurationObject;
import com.vaadin.flow.component.charts.model.AxisDimension;
import com.vaadin.flow.component.charts.util.ChartSerialization;
import java.io.Serializable;

class ProxyChangeForwarder
implements ConfigurationChangeListener {
    private final Chart chart;

    ProxyChangeForwarder(Chart chart) {
        this.chart = chart;
    }

    @Override
    public void dataAdded(DataAddedEvent event) {
        if (event.getItem() != null) {
            this.chart.getElement().callJsFunction("__callSeriesFunction", new Serializable[]{"addPoint", Integer.valueOf(this.getSeriesIndex(event)), this.chart.getJsonFactory().parse(ChartSerialization.toJSON(event.getItem())), Boolean.valueOf(true), Boolean.valueOf(event.isShift())});
        }
    }

    @Override
    public void dataRemoved(DataRemovedEvent event) {
        this.chart.getElement().callJsFunction("__callPointFunction", new Serializable[]{"remove", Integer.valueOf(this.getSeriesIndex(event)), Integer.valueOf(event.getIndex())});
    }

    @Override
    public void dataUpdated(DataUpdatedEvent event) {
        if (event.getValue() != null) {
            this.chart.getElement().callJsFunction("__callPointFunction", new Serializable[]{"update", Integer.valueOf(this.getSeriesIndex(event)), Integer.valueOf(event.getPointIndex()), Double.valueOf(event.getValue().doubleValue())});
        } else {
            this.chart.getElement().callJsFunction("__callPointFunction", new Serializable[]{"update", Integer.valueOf(this.getSeriesIndex(event)), Integer.valueOf(event.getPointIndex()), this.chart.getJsonFactory().parse(ChartSerialization.toJSON(event.getItem()))});
        }
    }

    @Override
    public void seriesStateChanged(SeriesStateEvent event) {
        if (event.isEnabled()) {
            this.chart.getElement().callJsFunction("__callSeriesFunction", new Serializable[]{"show", Integer.valueOf(this.getSeriesIndex(event))});
        } else {
            this.chart.getElement().callJsFunction("__callSeriesFunction", new Serializable[]{"hide", Integer.valueOf(this.getSeriesIndex(event))});
        }
    }

    @Override
    public void axisRescaled(AxisRescaledEvent event) {
        this.chart.getElement().callJsFunction("__callAxisFunction", new Serializable[]{"setExtremes", Integer.valueOf(event.getAxis()), Integer.valueOf(event.getAxisIndex()), Double.valueOf(event.getMinimum().doubleValue()), Double.valueOf(event.getMaximum().doubleValue()), Boolean.valueOf(event.isRedrawingNeeded()), Boolean.valueOf(event.isAnimated())});
    }

    @Override
    public void itemSliced(ItemSlicedEvent event) {
        this.chart.getElement().callJsFunction("__callPointFunction", new Serializable[]{"slice", Integer.valueOf(this.getSeriesIndex(event)), Integer.valueOf(event.getIndex()), Boolean.valueOf(event.isSliced()), Boolean.valueOf(event.isRedraw()), Boolean.valueOf(event.isAnimation())});
    }

    @Override
    public void seriesAdded(SeriesAddedEvent event) {
        this.chart.getElement().callJsFunction("__callChartFunction", new Serializable[]{"addSeries", this.chart.getJsonFactory().parse(ChartSerialization.toJSON((AbstractConfigurationObject)((Object)event.getSeries())))});
    }

    @Override
    public void seriesChanged(SeriesChangedEvent event) {
        this.chart.getElement().callJsFunction("__callSeriesFunction", new Serializable[]{"update", Integer.valueOf(this.getSeriesIndex(event)), this.chart.getJsonFactory().parse(ChartSerialization.toJSON((AbstractConfigurationObject)((Object)event.getSeries())))});
    }

    @Override
    public void resetZoom(boolean redraw, boolean animate) {
        int i;
        for (i = 0; i < this.chart.getConfiguration().getNumberOfxAxes(); ++i) {
            this.chart.getElement().callJsFunction("__callAxisFunction", new Serializable[]{"setExtremes", Integer.valueOf(AxisDimension.X_AXIS.getIndex()), Integer.valueOf(i), null, null, Boolean.valueOf(redraw), Boolean.valueOf(animate)});
        }
        for (i = 0; i < this.chart.getConfiguration().getNumberOfyAxes(); ++i) {
            this.chart.getElement().callJsFunction("__callAxisFunction", new Serializable[]{"setExtremes", Integer.valueOf(AxisDimension.Y_AXIS.getIndex()), Integer.valueOf(i), null, null, Boolean.valueOf(redraw), Boolean.valueOf(animate)});
        }
    }

    private int getSeriesIndex(AbstractSeriesEvent event) {
        return this.chart.getConfiguration().getSeries().indexOf(event.getSeries());
    }
}

