/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.checkbox;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.NotSupported;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.checkbox.CheckboxGroupVariant;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Tag(value="vaadin-checkbox-group")
@NpmPackage(value="@vaadin/vaadin-checkbox", version="21.0.2")
@JsModule(value="@vaadin/vaadin-checkbox/src/vaadin-checkbox-group.js")
public abstract class GeneratedVaadinCheckboxGroup<R extends GeneratedVaadinCheckboxGroup<R, T>, T>
extends AbstractSinglePropertyField<R, T>
implements HasStyle,
HasTheme {
    public void addThemeVariants(CheckboxGroupVariant ... variants) {
        this.getThemeNames().addAll((Collection)Stream.of(variants).map(CheckboxGroupVariant::getVariantName).collect(Collectors.toList()));
    }

    public void removeThemeVariants(CheckboxGroupVariant ... variants) {
        this.getThemeNames().removeAll((Collection)Stream.of(variants).map(CheckboxGroupVariant::getVariantName).collect(Collectors.toList()));
    }

    protected boolean isDisabledBoolean() {
        return this.getElement().getProperty("disabled", false);
    }

    protected void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    protected String getLabelString() {
        return this.getElement().getProperty("label");
    }

    protected void setLabel(String label) {
        this.getElement().setProperty("label", label == null ? "" : label);
    }

    protected String getErrorMessageString() {
        return this.getElement().getProperty("errorMessage");
    }

    protected void setErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage == null ? "" : errorMessage);
    }

    protected boolean isRequiredBoolean() {
        return this.getElement().getProperty("required", false);
    }

    protected void setRequired(boolean required) {
        this.getElement().setProperty("required", required);
    }

    @Synchronize(property="invalid", value={"invalid-changed"})
    protected boolean isInvalidBoolean() {
        return this.getElement().getProperty("invalid", false);
    }

    protected void setInvalid(boolean invalid) {
        this.getElement().setProperty("invalid", invalid);
    }

    @NotSupported
    protected void validate() {
    }

    protected Registration addInvalidChangeListener(ComponentEventListener<InvalidChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("invalid", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new InvalidChangeEvent<GeneratedVaadinCheckboxGroup>(this, event.isUserOriginated())));
    }

    public <P> GeneratedVaadinCheckboxGroup(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableFunction<P, T> presentationToModel, SerializableFunction<T, P> modelToPresentation) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (initialValue != null) {
            this.setPresentationValue(initialValue);
        }
    }

    public GeneratedVaadinCheckboxGroup(T initialValue, T defaultValue, boolean acceptNullValues) {
        super("value", defaultValue, acceptNullValues);
        if (initialValue != null) {
            this.setPresentationValue(initialValue);
        }
    }

    public <P> GeneratedVaadinCheckboxGroup(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableBiFunction<R, P, T> presentationToModel, SerializableBiFunction<R, T, P> modelToPresentation, boolean isInitialValueOptional) {
        super("value", defaultValue, elementPropertyType, presentationToModel, modelToPresentation);
        if (!(this.getElement().getProperty("value") != null && isInitialValueOptional || initialValue == null)) {
            this.setPresentationValue(initialValue);
        }
    }

    public <P> GeneratedVaadinCheckboxGroup(T initialValue, T defaultValue, Class<P> elementPropertyType, SerializableBiFunction<R, P, T> presentationToModel, SerializableBiFunction<R, T, P> modelToPresentation) {
        this(initialValue, defaultValue, elementPropertyType, presentationToModel, modelToPresentation, false);
    }

    public GeneratedVaadinCheckboxGroup() {
        this(null, null, null, (SerializableFunction)null, (SerializableFunction)null);
    }

    public static class InvalidChangeEvent<R extends GeneratedVaadinCheckboxGroup<R, ?>>
    extends ComponentEvent<R> {
        private final boolean invalid;

        public InvalidChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.invalid = ((GeneratedVaadinCheckboxGroup)((Object)source)).isInvalidBoolean();
        }

        public boolean isInvalid() {
            return this.invalid;
        }
    }
}

