/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.server;

import com.vaadin.classic.v8.server.Sizeable;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SizeWithUnit
implements Serializable {
    private static final String SIZE_REGEXP = "^(-?\\d*(?:\\.\\d+)?)(%|px|em|rem|ex|in|cm|mm|pt|pc)?$";
    private final float size;
    private final Sizeable.Unit unit;
    private static final Pattern SIZE_PATTERN = Pattern.compile("^(-?\\d*(?:\\.\\d+)?)(%|px|em|rem|ex|in|cm|mm|pt|pc)?$");

    public SizeWithUnit(float size, Sizeable.Unit unit) {
        this.size = size;
        this.unit = unit;
    }

    public float getSize() {
        return this.size;
    }

    public Sizeable.Unit getUnit() {
        return this.unit;
    }

    public static SizeWithUnit parseStringSize(String s, Sizeable.Unit defaultUnit) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty()) {
            return null;
        }
        float size = 0.0f;
        Sizeable.Unit unit = null;
        Matcher matcher = SIZE_PATTERN.matcher(s);
        if (matcher.find()) {
            size = Float.parseFloat(matcher.group(1));
            if (size < 0.0f) {
                size = -1.0f;
                unit = Sizeable.Unit.PIXELS;
            } else {
                String symbol = matcher.group(2);
                unit = symbol != null && !symbol.isEmpty() || defaultUnit == null ? Sizeable.Unit.getUnitFromSymbol(symbol) : defaultUnit;
            }
        } else {
            throw new IllegalArgumentException("Invalid size argument: \"" + s + "\" (should match " + SIZE_PATTERN.pattern() + ")");
        }
        return new SizeWithUnit(size, unit);
    }

    public static SizeWithUnit parseStringSize(String s) {
        return SizeWithUnit.parseStringSize(s, null);
    }
}

