/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.ui;

import com.vaadin.classic.v8.event.LayoutEvents;
import com.vaadin.classic.v8.server.SizeWithUnit;
import com.vaadin.classic.v8.server.Sizeable;
import com.vaadin.classic.v8.shared.ui.AlignmentInfo;
import com.vaadin.classic.v8.ui.AbstractComponent;
import com.vaadin.classic.v8.ui.AbstractLayout;
import com.vaadin.classic.v8.ui.AbstractSingleComponentContainer;
import com.vaadin.classic.v8.ui.Alignment;
import com.vaadin.classic.v8.ui.Layout;
import com.vaadin.classic.v8.ui.MarginInfo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementDetachListener;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractOrderedLayout
extends AbstractLayout
implements Layout.AlignmentHandler,
Layout.MarginHandler,
LayoutEvents.LayoutClickNotifier {
    private static final String SLOT_CLASS_NAME = "v-slot";
    static final String ALIGN_CLASS_PREFIX = "v-align-";
    private final boolean isVertical;
    private boolean isSpacing = false;
    private MarginInfo marginInfo;
    private Element expandWrapper = null;
    private boolean movingChildrenInternally;
    private boolean removingChildrenInternally;
    private Alignment defaultComponentAlignment = Alignment.TOP_LEFT;

    public AbstractOrderedLayout(boolean isVertical) {
        this.isVertical = isVertical;
        this.addInternalStyles("v-layout", isVertical ? "v-vertical" : "v-horizontal");
    }

    public AbstractOrderedLayout() {
        this(false);
    }

    @Override
    public void beforeClientResponse(boolean initial) {
        this.setMarginToElement();
        super.beforeClientResponse(initial);
        this.cleanupSlotsAndSpacing();
        this.setSlotClasses();
        this.setExpandRatiosToSlots();
    }

    @Override
    public void addComponent(Component component) {
        if (component.getParent().isPresent()) {
            AbstractSingleComponentContainer.removeFromParent(component);
        }
        if (component instanceof AbstractComponent) {
            ((AbstractComponent)component).setParent(null);
        }
        Element container = this.getContainer();
        if (this.isSpacing && container.getChildCount() > 0) {
            container.appendChild(new Element[]{this.createSpacing()});
        }
        container.appendChild(new Element[]{this.wrapInSlot(component)});
        this.setComponentAlignment(component, this.getDefaultComponentAlignment());
        this.addDetachListener(component);
        this.cleanupSlotsAndSpacing();
        this.fireComponentAttachEvent(component);
        this.markAsDirtyRecursive();
    }

    private void addDetachListener(Component component) {
        AtomicReference<Registration> holder = new AtomicReference<Registration>();
        holder.set(component.getElement().addDetachListener((ElementDetachListener & Serializable)event -> {
            if (this.movingChildrenInternally) {
                return;
            }
            if (!this.removingChildrenInternally) {
                this.cleanupSlotsAndSpacing();
                this.setExpandRatiosToSlots();
            }
            this.markAsDirtyRecursive();
            ((Registration)holder.get()).remove();
        }));
    }

    @Override
    public void add(Component ... components) {
        this.addComponents(components);
    }

    public void addComponentsAndExpand(Component ... components) {
        this.addComponents(components);
        if (this.isVertical) {
            if (this.getHeight() < 0.0f) {
                this.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
            }
        } else if (this.getWidth() < 0.0f) {
            this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        }
        for (Component component : components) {
            if (this.isVertical) {
                if (component instanceof HasSize) {
                    ((HasSize)component).setHeight(100.0f, Unit.PERCENTAGE);
                }
                if (component instanceof Sizeable) {
                    ((Sizeable)component).setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
                }
            } else {
                if (component instanceof HasSize) {
                    ((HasSize)component).setWidth(100.0f, Unit.PERCENTAGE);
                }
                if (component instanceof Sizeable) {
                    ((Sizeable)component).setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
                }
            }
            this.setExpandRatio(component, 1.0f);
        }
    }

    private void cleanupSlotsAndSpacing() {
        AtomicInteger index = new AtomicInteger();
        int lastComponentIndex = (int)(this.getChildren().count() * 2L - 2L);
        this.getContainer().getChildren().collect(Collectors.toList()).forEach(childElement -> {
            if (this.isSpacing && childElement.getClassList().contains((Object)"v-spacing") && index.get() % 2 == 1 && index.get() < lastComponentIndex || childElement.getChildCount() > 0) {
                index.incrementAndGet();
            } else {
                childElement.removeFromParent();
            }
        });
    }

    @Override
    protected void doSetHeight(SizeWithUnit height) {
        super.doSetHeight(height);
        if (!this.isVertical) {
            return;
        }
        if ((double)this.getHeight() > 0.0) {
            this.addExpandWrapper();
        } else {
            this.removeExpandWrapper();
        }
    }

    @Override
    protected void doSetWidth(SizeWithUnit width) {
        super.doSetWidth(width);
        if (this.isVertical) {
            return;
        }
        if ((double)this.getWidth() > 0.0) {
            this.addExpandWrapper();
        } else {
            this.removeExpandWrapper();
        }
    }

    public void setSpacing(boolean spacing) {
        if (spacing != this.isSpacing) {
            this.isSpacing = spacing;
            if (this.isSpacing) {
                this.addSpacingElements();
            } else {
                this.removeSpacingElements();
            }
        }
    }

    public boolean isSpacing() {
        return this.isSpacing;
    }

    @Override
    public void setMargin(boolean enabled) {
        this.setMargin(new MarginInfo(enabled));
    }

    @Override
    public void setMargin(MarginInfo marginInfo) {
        this.marginInfo = marginInfo;
        this.markAsDirty();
    }

    @Override
    public MarginInfo getMargin() {
        if (this.marginInfo == null) {
            this.marginInfo = new MarginInfo(false);
        }
        return this.marginInfo;
    }

    private void setMarginToElement() {
        if (this.marginInfo == null) {
            return;
        }
        this.toggleInternalStyle("v-margin-top", this.marginInfo.hasTop());
        this.toggleInternalStyle("v-margin-bottom", this.marginInfo.hasBottom());
        this.toggleInternalStyle("v-margin-left", this.marginInfo.hasLeft());
        this.toggleInternalStyle("v-margin-right", this.marginInfo.hasRight());
    }

    private void toggleInternalStyle(String style, boolean add) {
        if (add) {
            this.addInternalStyles(style);
        } else {
            this.removeInternalStyles(style);
        }
    }

    @Override
    public void remove(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            this.removeComponent(component);
        }
    }

    @Override
    public void removeComponent(Component component) {
        if (!this.isChild(component)) {
            return;
        }
        this.removingChildrenInternally = true;
        this.doRemoveComponent(component);
        this.removingChildrenInternally = false;
        this.markAsDirtyRecursive();
    }

    private void doRemoveComponent(Component component) {
        Element element = component.getElement();
        Element slot = element.getParent();
        Element container = this.getContainer();
        int slotIndex = container.indexOfChild(slot);
        int spacingIndex = slotIndex < container.getChildCount() - 1 ? slotIndex : slotIndex - 1;
        element.removeFromParent();
        slot.removeFromParent();
        if (this.isSpacing && spacingIndex > -1) {
            container.removeChild(spacingIndex);
        }
        this.fireComponentDetachEvent(component);
    }

    private Element wrapInSlot(Component component) {
        Element slot = ElementFactory.createDiv();
        slot.setAttribute("class", SLOT_CLASS_NAME);
        slot.appendChild(new Element[]{component.getElement()});
        return slot;
    }

    public void setExpandRatio(Component component, float ratio) {
        if (!this.isChild(component)) {
            throw new IllegalArgumentException("The given component is not a child of this layout");
        }
        if (ratio < 0.0f) {
            throw new IllegalArgumentException("Expand ratio can't be less than 0.0");
        }
        ComponentUtil.setData((Component)component, ExpandRatioKey.class, (Object)(ratio > 0.0f ? new ExpandRatioKey(ratio) : null));
        this.setExpandRatiosToSlots();
    }

    public float getExpandRatio(Component component) {
        if (!this.isChild(component)) {
            throw new IllegalArgumentException("The given component is not a child of this layout");
        }
        ExpandRatioKey expandRatio = (ExpandRatioKey)ComponentUtil.getData((Component)component, ExpandRatioKey.class);
        return expandRatio != null ? expandRatio.value : 0.0f;
    }

    private boolean isChild(Component component) {
        return component.getParent().isPresent() && component.getParent().get() == this;
    }

    private void setExpandRatiosToSlots() {
        boolean hasExpandRatio = this.getChildren().anyMatch(component -> this.getExpandRatio((Component)component) > 0.0f);
        this.getChildren().forEach(component -> {
            Element slot = component.getElement().getParent();
            if (hasExpandRatio) {
                float expandRatio = this.getExpandRatio((Component)component);
                slot.getStyle().set("flex-grow", String.valueOf(expandRatio));
            } else {
                slot.getStyle().remove("flex-grow");
            }
        });
    }

    private void addExpandWrapper() {
        if (this.expandWrapper == null) {
            this.expandWrapper = ElementFactory.createDiv();
            this.expandWrapper.getClassList().add((Object)"v-expand");
            this.movingChildrenInternally = true;
            this.expandWrapper.appendChild((Element[])this.getElement().getChildren().toArray(Element[]::new));
            this.getElement().appendChild(new Element[]{this.expandWrapper});
            this.movingChildrenInternally = false;
        }
    }

    private void removeExpandWrapper() {
        if (this.expandWrapper != null) {
            this.movingChildrenInternally = true;
            this.expandWrapper.removeFromParent();
            this.getElement().appendChild((Element[])this.expandWrapper.getChildren().toArray(Element[]::new));
            this.expandWrapper = null;
            this.movingChildrenInternally = false;
        }
    }

    private void removeSpacingElements() {
        this.getContainer().getChildren().collect(Collectors.toList()).stream().filter(child -> child.getClassList().contains((Object)"v-spacing")).forEach(Element::removeFromParent);
    }

    private void addSpacingElements() {
        for (int i = 1; i < this.getContainer().getChildCount(); i += 2) {
            this.getContainer().insertChild(i, new Element[]{this.createSpacing()});
        }
    }

    private Element createSpacing() {
        Element div = ElementFactory.createDiv();
        div.getClassList().add((Object)"v-spacing");
        return div;
    }

    private Element getContainer() {
        return this.expandWrapper == null ? this.getElement() : this.expandWrapper;
    }

    public Stream<Component> getChildren() {
        Element container = this.expandWrapper == null ? this.getElement() : this.expandWrapper;
        return container.getChildren().filter(child -> child.getChildCount() > 0).map(element -> element.getChild(0)).map(Element::getComponent).map(Optional::get);
    }

    public void addComponentAtIndex(int index, Component component) {
        this.addComponent(component, index);
    }

    public void addComponent(Component component, int index) throws IndexOutOfBoundsException {
        int componentCount = this.getComponentCount();
        if (index < 0 || index > componentCount) {
            throw new IndexOutOfBoundsException();
        }
        if (componentCount == 0 || index == componentCount) {
            this.addComponent(component);
            return;
        }
        if (component.getParent().isPresent()) {
            if (this.isChild(component) && index > this.getComponentIndex(component)) {
                --index;
            }
            AbstractSingleComponentContainer.removeFromParent(component);
        }
        if (component instanceof AbstractComponent) {
            ((AbstractComponent)component).setParent(null);
        }
        Element container = this.getContainer();
        if (this.isSpacing && this.getComponentCount() > 0) {
            container.insertChild(index *= 2, new Element[]{this.wrapInSlot(component), this.createSpacing()});
        } else {
            container.insertChild(index, new Element[]{this.wrapInSlot(component)});
        }
        this.setComponentAlignment(component, this.getDefaultComponentAlignment());
        this.addDetachListener(component);
        this.fireComponentAttachEvent(component);
        this.markAsDirtyRecursive();
    }

    public void addComponentAsFirst(Component component) {
        this.addComponent(component, 0);
    }

    @Override
    public void replaceComponent(Component oldComponent, Component newComponent) {
        if (!this.isChild(oldComponent)) {
            this.addComponent(newComponent);
            return;
        }
        if (this.isChild(newComponent)) {
            this.movingChildrenInternally = true;
            Element oldElement = oldComponent.getElement();
            Element newElement = newComponent.getElement();
            Element oldComponentSlot = oldElement.getParent();
            Element newComponentSlot = newElement.getParent();
            newComponentSlot.appendChild(new Element[]{oldElement});
            oldComponentSlot.appendChild(new Element[]{newElement});
            this.movingChildrenInternally = false;
            this.setSlotClasses();
            return;
        }
        this.addComponent(newComponent, this.getComponentIndex(oldComponent));
        this.setComponentAlignment(newComponent, this.getComponentAlignment(oldComponent));
        this.remove(oldComponent);
    }

    @Override
    public int getComponentCount() {
        return (int)this.getChildren().count();
    }

    public Component getComponent(int index) throws IndexOutOfBoundsException {
        return (Component)this.getChildren().collect(Collectors.toList()).get(index);
    }

    public int getComponentIndex(Component component) {
        return this.getChildren().collect(Collectors.toList()).indexOf(component);
    }

    protected void setSlotClasses() {
        this.getChildren().forEach(child -> {
            Element slot = child.getElement().getParent();
            if (child instanceof AbstractComponent) {
                StringBuilder sb = new StringBuilder(SLOT_CLASS_NAME);
                ((AbstractComponent)child).getCustomStyles().forEach(style -> sb.append(" ").append(SLOT_CLASS_NAME).append("-").append((String)style));
                slot.setAttribute("class", sb.toString());
            }
            ClassList classList = slot.getClassList();
            AlignmentInfo alignment = new AlignmentInfo(((AlignmentKey)ComponentUtil.getData((Component)child, AlignmentKey.class)).getValue().getBitMask());
            classList.set("v-align-center", alignment.isHorizontalCenter());
            classList.set("v-align-right", alignment.isRight());
            classList.set("v-align-middle", alignment.isVerticalCenter());
            classList.set("v-align-bottom", alignment.isBottom());
        });
    }

    @Override
    public void setComponentAlignment(Component childComponent, Alignment alignment) {
        if (!this.isChild(childComponent)) {
            throw new IllegalArgumentException("Component must be added to layout before using setComponentAlignment()");
        }
        ComponentUtil.setData((Component)childComponent, AlignmentKey.class, (Object)new AlignmentKey(alignment));
        this.markAsDirty();
    }

    @Override
    public Alignment getComponentAlignment(Component childComponent) {
        if (!this.isChild(childComponent)) {
            throw new IllegalArgumentException("The given component is not a child of this layout");
        }
        return ((AlignmentKey)ComponentUtil.getData((Component)childComponent, AlignmentKey.class)).getValue();
    }

    @Override
    public void setDefaultComponentAlignment(Alignment defaultComponentAlignment) {
        this.defaultComponentAlignment = defaultComponentAlignment;
    }

    @Override
    public Alignment getDefaultComponentAlignment() {
        return this.defaultComponentAlignment;
    }

    @Override
    public Registration addLayoutClickListener(LayoutEvents.LayoutClickListener listener) {
        return this.getEventBus().addListener(LayoutEvents.LayoutClickEvent.class, (ComponentEventListener)listener);
    }

    static class AlignmentKey {
        private final Alignment value;

        public AlignmentKey(Alignment value) {
            this.value = value;
        }

        public Alignment getValue() {
            return this.value;
        }
    }

    static class ExpandRatioKey {
        private final float value;

        public ExpandRatioKey(float value) {
            this.value = value;
        }
    }
}

