/*
 * Copyright (c) 2000-2022 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */
package com.vaadin.classic.v8.shared.ui;

/**
 * Holds constants with common CSS class names.
 */
public final class CssClassName {

    private CssClassName() {}

    /**
     * CSS class name for adding spacing between the children of a component container.
     */
    public static final String SPACING = "v-spacing";

    /**
     * CSS class name for slots.
     */
    public static final String SLOT = "v-slot";

    /**
     * Added to all layouts to denote they are layouts.
     */
    public static final String UI_LAYOUT = "v-layout";

    /**
     * Legacy widget class.
     */
    public static final String WIDGET = "v-widget";


    /**
     * CSS class name prefix for alignment classes.
     */
    public static final String ALIGN_PREFIX = "v-align-";
}
