/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.server;

import com.vaadin.classic.v8.server.ClientConnector;
import com.vaadin.classic.v8.server.Extension;
import com.vaadin.classic.v8.server.Helpers;
import com.vaadin.classic.v8.server.Resource;
import com.vaadin.classic.v8.shared.communication.ServerRpc;
import com.vaadin.classic.v8.shared.communication.SharedState;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableEventListener;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractClientConnector
extends Component
implements ClientConnector {
    private static final String PROJECT_NAME = "vaadin-classic-components";
    private static final String PROJECT_VERSION_PROP = "classic-components.version";
    private StateTree.ExecutionRegistration beforeClientResponseRegistration;
    private boolean initialResponse = true;

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.attach();
    }

    protected void onDetach(DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.detach();
        if (this.beforeClientResponseRegistration != null) {
            this.beforeClientResponseRegistration.remove();
            this.beforeClientResponseRegistration = null;
        }
    }

    @Override
    public void beforeClientResponse(boolean initial) {
    }

    @Override
    public void markAsDirty() {
        assert (this.getSession() == null || this.getSession().hasLock());
        if (this.beforeClientResponseRegistration == null && this.isAttached()) {
            this.getUI().ifPresent(ui -> {
                this.beforeClientResponseRegistration = ui.beforeClientResponse((Component)this, this::internalBeforeClientResponse);
            });
        }
    }

    @Override
    public void markAsDirtyRecursive() {
        this.markAsDirty();
        this.getChildren().forEach(AbstractClientConnector::markAsDirtyRecursive);
    }

    private static void markAsDirtyRecursive(Component child) {
        if (child instanceof AbstractClientConnector) {
            ((AbstractClientConnector)child).markAsDirtyRecursive();
        } else {
            child.getChildren().forEach(AbstractClientConnector::markAsDirtyRecursive);
        }
    }

    private void internalBeforeClientResponse(ExecutionContext executionContext) {
        this.beforeClientResponse(this.initialResponse);
        this.initialResponse = false;
        this.beforeClientResponseRegistration = null;
    }

    @Override
    public Registration addLegacyAttachListener(ClientConnector.AttachListener listener) {
        return this.addListener(ClientConnector.AttachEvent.class, listener);
    }

    @Override
    public Registration addLegacyDetachListener(ClientConnector.DetachListener listener) {
        return this.addListener(ClientConnector.DetachEvent.class, listener);
    }

    protected boolean hasListeners(Class<? extends ComponentEvent> eventType) {
        return this.hasListener(eventType);
    }

    @Override
    public void attach() {
        this.markAsDirty();
        this.fireEvent(new ClientConnector.AttachEvent(this));
    }

    @Override
    public void detach() {
        this.fireEvent(new ClientConnector.DetachEvent(this));
    }

    @Override
    public boolean isAttached() {
        return super.isAttached();
    }

    @Override
    public boolean isConnectorEnabled() {
        return this.isAttached() && this.isVisible() && this.getElement().isEnabled();
    }

    protected VaadinSession getSession() {
        return this.getUI().map(UI::getSession).orElse(null);
    }

    @Deprecated
    protected void addExtension(Extension extension) {
        Helpers.logUnsupportedApiCall(this.getClass(), "addExtension(Extension)");
    }

    @Deprecated
    public Registration addListener(Class<?> eventType, SerializableEventListener listener, Method method) {
        Class<?> aClass = this.getClass();
        Helpers.logUnsupportedApiCall(aClass, "addListener(Class<?>, SerializableEventListener, Method)");
        return (Registration & Serializable)() -> Helpers.logUnsupportedApiCall(aClass, "Registration.remove() returned by " + aClass.getName() + ".addListener");
    }

    @Deprecated
    protected Registration addListener(String eventIdentifier, Class<?> eventType, SerializableEventListener listener, Method method) {
        Class<?> aClass = this.getClass();
        Helpers.logUnsupportedApiCall(aClass, "addListener(String, Class<?>, SerializableEventListener, Method)");
        return (Registration & Serializable)() -> Helpers.logUnsupportedApiCall(aClass, "Registration.remove() returned by " + aClass.getName() + ".addListener");
    }

    @Deprecated
    protected void addMethodInvocationToQueue(String interfaceName, Method method, Object[] parameters) {
        Helpers.logUnsupportedApiCall(this.getClass(), "addMethodInvocationToQueue(String, Method, Object[])");
    }

    @Deprecated
    protected SharedState createState() {
        Helpers.logUnsupportedApiCall(this.getClass(), "createState()");
        return new SharedState();
    }

    @Deprecated
    public static Iterable<? extends ClientConnector> getAllChildrenIterable(ClientConnector connector) {
        Helpers.logUnsupportedApiCall(AbstractClientConnector.class, "getAllChildrenIterable(ClientConnector)");
        return (Iterable)((Object)Collections.emptyIterator());
    }

    @Deprecated
    public String getConnectorId() {
        Helpers.logUnsupportedApiCall(this.getClass(), "getConnectorId()");
        return "";
    }

    @Deprecated
    public ErrorHandler getErrorHandler() {
        Class<?> aClass = this.getClass();
        Helpers.logUnsupportedApiCall(aClass, "getErrorHandler()");
        return (ErrorHandler & Serializable)errorEvent -> Helpers.logUnsupportedApiCall(aClass, "ErrorHandler::onError(ErrorEvent) returned by " + aClass.getName() + ".getErrorHandler()");
    }

    @Deprecated
    public Collection<Extension> getExtensions() {
        Helpers.logUnsupportedApiCall(this.getClass(), "getExtension()");
        return Collections.emptyList();
    }

    @Deprecated
    protected Resource getResource(String key) {
        final Class<?> aClass = this.getClass();
        Helpers.logUnsupportedApiCall(aClass, "getResource(String)");
        return new Resource(){

            @Override
            public String getMIMEType() {
                Helpers.logUnsupportedApiCall(aClass, "Resource::getMIMEType() returned by " + aClass.getName() + ".getResource()");
                return "";
            }
        };
    }

    @Deprecated
    protected SharedState getState() {
        Helpers.logUnsupportedApiCall(this.getClass(), "getState()");
        return new SharedState();
    }

    @Deprecated
    protected SharedState getState(boolean markAsDirty) {
        Helpers.logUnsupportedApiCall(this.getClass(), "getState(boolean)");
        return new SharedState();
    }

    @Deprecated
    public boolean handleConnectorRequest(VaadinRequest request, VaadinResponse response, String path) {
        Helpers.logUnsupportedApiCall(this.getClass(), "handleConnectorRequest(VaadinRequest, VaadinResponse, String");
        return false;
    }

    @Deprecated
    protected <T extends ServerRpc> void registerRpc(T implementation) {
        Helpers.logUnsupportedApiCall(this.getClass(), "registerRpc(T)");
    }

    @Deprecated
    protected <T extends ServerRpc> void registerRpc(T implementation, Class<T> rpcInterfaceType) {
        Helpers.logUnsupportedApiCall(this.getClass(), "registerRpc(T, Class<T>)");
    }

    @Deprecated
    public void removeExtension(Extension extension) {
        Helpers.logUnsupportedApiCall(this.getClass(), "removeExtension(Extension)");
    }

    @Deprecated
    public void setErrorHandler(ErrorHandler errorHandler) {
        Helpers.logUnsupportedApiCall(this.getClass(), "setErrorHandler(ErrorHandler)");
    }

    @Deprecated
    protected void setResource(String key, Resource resource) {
        Helpers.logUnsupportedApiCall(this.getClass(), "setResource(String, Resource)");
    }

    @Deprecated
    protected void updateDiffstate(String propertyName, JsonValue newValue) {
        Helpers.logUnsupportedApiCall(this.getClass(), "updateDiffstate(String, JsonValue)");
    }

    static {
        String projectVersion = Helpers.getProperty(PROJECT_VERSION_PROP);
        Helpers.checkLicense(PROJECT_NAME, projectVersion);
        UsageStatistics.markAsUsed((String)PROJECT_NAME, (String)projectVersion);
    }
}

