/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.shared.ui;

import java.io.Serializable;

public final class AlignmentInfo
implements Serializable {
    public static final AlignmentInfo LEFT = new AlignmentInfo(1);
    public static final AlignmentInfo RIGHT = new AlignmentInfo(2);
    public static final AlignmentInfo TOP = new AlignmentInfo(4);
    public static final AlignmentInfo BOTTOM = new AlignmentInfo(8);
    public static final AlignmentInfo CENTER = new AlignmentInfo(16);
    public static final AlignmentInfo MIDDLE = new AlignmentInfo(32);
    public static final AlignmentInfo TOP_LEFT = new AlignmentInfo(5);
    private final int bitMask;

    public AlignmentInfo(int bitMask) {
        this.bitMask = bitMask;
    }

    public AlignmentInfo(AlignmentInfo horizontal, AlignmentInfo vertical) {
        this(horizontal.getBitMask() + vertical.getBitMask());
    }

    public int getBitMask() {
        return this.bitMask;
    }

    public boolean isTop() {
        return (this.bitMask & 4) == 4;
    }

    public boolean isBottom() {
        return (this.bitMask & 8) == 8;
    }

    public boolean isLeft() {
        return (this.bitMask & 1) == 1;
    }

    public boolean isRight() {
        return (this.bitMask & 2) == 2;
    }

    public boolean isVerticalCenter() {
        return (this.bitMask & 0x20) == 32;
    }

    public boolean isHorizontalCenter() {
        return (this.bitMask & 0x10) == 16;
    }

    public String getVerticalAlignment() {
        if (this.isBottom()) {
            return "bottom";
        }
        if (this.isVerticalCenter()) {
            return "middle";
        }
        return "top";
    }

    public String getHorizontalAlignment() {
        if (this.isRight()) {
            return "right";
        }
        if (this.isHorizontalCenter()) {
            return "center";
        }
        return "left";
    }

    public static class Bits
    implements Serializable {
        public static final int ALIGNMENT_LEFT = 1;
        public static final int ALIGNMENT_RIGHT = 2;
        public static final int ALIGNMENT_TOP = 4;
        public static final int ALIGNMENT_BOTTOM = 8;
        public static final int ALIGNMENT_HORIZONTAL_CENTER = 16;
        public static final int ALIGNMENT_VERTICAL_CENTER = 32;
    }
}

