/*
 * Copyright (c) 2000-2022 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */

package com.vaadin.classic.v8.ui;
/**
 * Legacy version of Listener interface that resembles Vaadin 7/8's
 * <code>Component.Focusable</code> API as closely as possible in order to
 * facilitate migration to newer versions of Vaadin.
 *
 * A sub-interface implemented by components that can obtain input focus. This
 * includes all {@code LegacyField} components as well as some other components,
 * such as {@code Upload}.
 *
 */
public interface Focusable {

    /**
     * Sets the focus to this component.
     */
    void focus();

    /**
     * Gets the <i>tabulator index</i> of the {@code Focusable} component.
     *
     * @return tab index set for the {@code Focusable} component
     * @see #setTabIndex(int)
     */
    int getTabIndex();

    /**
     * Sets the <i>tabulator index</i> of the {@code Focusable} component. The
     * tab index property is used to specify the order in which the fields are
     * focused when the user presses the Tab key. Components with a defined tab
     * index are focused sequentially first, and then the components with no tab
     * index.
     *
     * <p>
     * After all focusable user interface components are done, the browser can
     * begin again from the component with the smallest tab index, or it can
     * take the focus out of the page, for example, to the location bar.
     * </p>
     *
     * <p>
     * If the tab index is not set (is set to zero), the default tab order is
     * used. The order is somewhat browser-dependent, but generally follows the
     * HTML structure of the page.
     * </p>
     *
     * <p>
     * A negative value means that the component is completely removed from the
     * tabulation order and can not be reached by pressing the Tab key at all.
     * </p>
     *
     * @param tabIndex
     *            the tab order of this component. Indexes usually start from 1.
     *            Zero means that default tab order should be used. A negative
     *            value means that the field should not be included in the
     *            tabbing sequence.
     * @see #getTabIndex()
     */
    void setTabIndex(int tabIndex);

}
