/*
 * Copyright (c) 2000-2022 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */

package com.vaadin.classic.v8.ui;

import com.vaadin.classic.v8.server.Helpers;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;

/**
 * Legacy version of HorizontalLayout that resembles Vaadin 7/8's
 * HorizontalLayout API as closely as possible in order to facilitate migration
 * to newer versions of Vaadin.
 * <p>
 * <code>HorizontalLayout</code> is a component container, which shows the
 * subcomponents in the order of their addition (horizontally).
 *
 * @author Vaadin Ltd.
 */
@Tag(Tag.DIV)
@CssImport("./ordered-layout.css")
@CssImport("./margin.css")
public class HorizontalLayout extends AbstractOrderedLayout {

    /**
     * Constructs an empty HorizontalLayout.
     */
    public HorizontalLayout() {
        super(false);
        setPrimaryStyleName("v-horizontallayout");
        if (!Helpers.isVaadin7Defaults()) {
            setSpacing(true);
        }
    }

    /**
     * Constructs a HorizontalLayout with the given components. The components
     * are added in the given order.
     *
     * @param children
     *            The components to add.
     * @see AbstractOrderedLayout#addComponents(Component...)
     */
    public HorizontalLayout(Component... children) {
        this();
        addComponents(children);
    }

    /**
     * Adds the given components to this layout and sets them as expanded. The
     * width of this layout is set to 100% if it is currently undefined.
     * <p>
     * The components are added in the provided order to the end of this layout.
     * Any components that are already children of this layout will be moved to
     * new positions.
     *
     * @param components
     *            the components to set, not <code>null</code>
     */
    @Override
    public void addComponentsAndExpand(Component... components) {
        super.addComponentsAndExpand(components);
    }
}
