/*
 * Copyright (c) 2000-2022 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */
package com.vaadin.classic.v8.ui;

import java.util.List;
import java.util.stream.Collectors;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;

/**
 * A component based in the Table &lt;table&gt; element.
 */
@Tag("table")
class Table extends AbstractComponentContainer {

    /**
     * Creates an empty Table.
     */
    public Table() {
    }

    /**
     * Creates a Table with a list of rows.
     *
     * @param rows the list of rows to add to the Table.
     */
    public Table(List<TableRow> rows) {
        this();
        for (TableRow row : rows) {
            add(row);
        }
    }

    @Override
    public void replaceComponent(Component oldComponent, Component newComponent) {
        int index = getChildren().collect(Collectors.toList()).indexOf(oldComponent);
        if (index >= 0) {
            addComponentAtIndex(index, newComponent);
            removeComponent(oldComponent);
        }
    }

    @Override
    public int getComponentCount() {
        return (int) getChildren().count();
    }
}
