/*
 * Copyright (c) 2000-2022 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */
package com.vaadin.classic.v8.ui;

import java.util.List;
import java.util.stream.Collectors;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;

/**
 * A component based in the Table Row &lt;tr&gt; element.
 */
@Tag("tr")
class TableRow extends AbstractComponentContainer {

    /**
     * Creates an empty Table Row.
     */
    public TableRow() {}

    /**
     * Creates a Table Row with a list of cells as its content.
     *
     * @param cells the cells of the row.
     */
    public TableRow(List<TableDataCell> cells) {
        for (TableDataCell cell : cells) {
            this.add(cell);
        }
    }

    @Override
    public void replaceComponent(Component oldComponent, Component newComponent) {
        int index = getChildren().collect(Collectors.toList()).indexOf(oldComponent);
        if (index >= 0) {
            addComponentAtIndex(index, newComponent);
            removeComponent(oldComponent);
        }
    }

    @Override
    public int getComponentCount() {
        return (int) getChildren().count();
    }
}
