/*
 * Copyright (c) 2000-2022 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */

package com.vaadin.classic.v8.ui;
/**
 * Legacy version of ValoTheme to facilitate migration
 * <p>
 * Additional style names which can be used with the Valo theme.
 *
 * @author Vaadin Ltd
 */
public class ValoTheme {
    /***************************************************************************
     *
     * Label styles
     *
     **************************************************************************/

    /**
     * Header style for main application headings. Can be combined with any
     * other Label style.
     */
    public static final String LABEL_H1 = "h1";

    /**
     * Header style for different sections in the application. Can be combined
     * with any other Label style.
     */
    public static final String LABEL_H2 = "h2";

    /**
     * Header style for different sub-sections in the application. Can be
     * combined with any other Label style.
     */
    public static final String LABEL_H3 = "h3";

    /**
     * Header style for different sub-sections in the application. Can be
     * combined with any other Label style.
     */
    public static final String LABEL_H4 = "h4";

    /**
     * A utility style that can be combined with the {@link #LABEL_H1},
     * {@link #LABEL_H2}, {@link #LABEL_H3} and {@link #LABEL_H4} styles to
     * remove the default margins from the header.
     */
    public static final String LABEL_NO_MARGIN = "no-margin";

    /**
     * Tiny font size. Suitable for additional/supplementary UI text. Can be
     * combined with any other Label style.
     */
    public static final String LABEL_TINY = "tiny";

    /**
     * Small font size. Suitable for additional/supplementary UI text. Can be
     * combined with any other Label style.
     */
    public static final String LABEL_SMALL = "small";

    /**
     * Large font size. Suitable for important/prominent UI text. Can be
     * combined with any other Label style.
     */
    public static final String LABEL_LARGE = "large";

    /**
     * Huge font size. Suitable for important/prominent UI text. Can be combined
     * with any other Label style.
     */
    public static final String LABEL_HUGE = "huge";

    /**
     * Lighter font weight. Suitable for additional/supplementary UI text. Can
     * be combined with any other Label style.
     */
    public static final String LABEL_LIGHT = "light";

    /**
     * Bolder font weight. Suitable for important/prominent UI text. Can be
     * combined with any other Label style.
     */
    public static final String LABEL_BOLD = "bold";

    /**
     * Colored text. Can be combined with any other Label style.
     */
    public static final String LABEL_COLORED = "colored";

    /**
     * Success badge style. Adds a border around the label and an icon next to
     * the text. Suitable for UI notifications that need to in the direct
     * context of some component. Can be combined with any other Label style.
     */
    public static final String LABEL_SUCCESS = "success";

    /**
     * Failure badge style. Adds a border around the label and an icon next to
     * the text. Suitable for UI notifications that need to in the direct
     * context of some component. Can be combined with any other Label style.
     */
    public static final String LABEL_FAILURE = "failure";

    /**
     * Spinner style. Add this style name to an empty Label to create a spinner.
     *
     * <h4>Example</h4>
     *
     * <pre>
     * Label spinner = new Label();
     * spinner.addStyleName(ValoTheme.LABEL_SPINNER);
     * </pre>
     */
    public static final String LABEL_SPINNER = "spinner";

    /***************************************************************************
     *
     * Panel styles
     *
     **************************************************************************/

    /**
     * Remove borders and the background color of the panel. Can be combined
     * with any other Panel style.
     */
    public static final String PANEL_BORDERLESS = "borderless";

    /**
     * Show a divider between the panel caption and content when the content
     * area is scrolled. Suitable with the {@link #PANEL_BORDERLESS} style. Can
     * be combined with any other Panel style.
     */
    public static final String PANEL_SCROLL_INDICATOR = "scroll-divider";

    /**
     * Inset panel style. Can be combined with any other Panel style.
     */
    public static final String PANEL_WELL = "well";
}
