/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.server;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.pro.licensechecker.LicenseChecker;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helpers
implements Serializable {
    public static final String UNSUPPORTED_API_LOGGER_NAME = "Unsupported API";
    public static final String VAADIN_7_SYSTEM_PROPERTY = "vaadin.classic-components.vaadin7defaults";
    private static final String VAADIN_7_DEFAULTS = System.getProperty("vaadin.classic-components.vaadin7defaults");
    private static final CustomSecurityManager CUSTOM_SECURITY_MANAGER = new CustomSecurityManager();

    private Helpers() {
    }

    static Properties getProperties(VaadinService service) {
        Properties properties = new Properties();
        try {
            properties.load(service.getClassLoader().getResourceAsStream("vaadin-classic-components-version.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    static boolean isProductionMode(VaadinService service) {
        return service.getDeploymentConfiguration().isProductionMode();
    }

    static VaadinService getService() {
        return VaadinService.getCurrent();
    }

    static void checkLicense(String projectName, String version) {
        VaadinService service = Helpers.getService();
        if (service != null && !Helpers.isProductionMode(service)) {
            LicenseChecker.checkLicenseFromStaticBlock((String)projectName, (String)version);
        }
    }

    static String getProperty(String property) {
        VaadinService service = Helpers.getService();
        if (service == null) {
            return null;
        }
        Properties properties = Helpers.getProperties(service);
        return properties.getProperty(property);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)UNSUPPORTED_API_LOGGER_NAME);
    }

    public static void logUnsupportedApiCall(Class<?> clazz, String methodName) {
        boolean productionMode = true;
        String callerClassName = null;
        String calledClassName = null;
        try {
            productionMode = Helpers.isProductionMode(Helpers.getService());
            if (!productionMode) {
                callerClassName = CUSTOM_SECURITY_MANAGER.getFirstNonLegacyClassInCallStack();
                calledClassName = clazz.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!productionMode) {
            StringBuilder message = new StringBuilder("Calling: '");
            if (calledClassName != null) {
                message.append(calledClassName).append(".");
            }
            message.append(methodName);
            if (callerClassName != null) {
                message.append("'\nfrom app class: '").append(callerClassName);
            }
            message.append("'. This call has no effect.");
            Helpers.getLogger().warn(message.toString());
        }
    }

    public static boolean isVaadin7Defaults() {
        return VAADIN_7_DEFAULTS != null;
    }

    private static class CustomSecurityManager
    extends SecurityManager {
        private CustomSecurityManager() {
        }

        public String getFirstNonLegacyClassInCallStack() {
            Class<?>[] classContext = this.getClassContext();
            for (int i = 2; i < classContext.length; ++i) {
                String name = classContext[i].getName();
                if (name.contains("com.vaadin.classic")) continue;
                return name;
            }
            return null;
        }
    }
}

