/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.ui;

import com.vaadin.classic.v8.event.LayoutEvents;
import com.vaadin.classic.v8.server.Helpers;
import com.vaadin.classic.v8.server.Sizeable;
import com.vaadin.classic.v8.ui.AbstractLayout;
import com.vaadin.classic.v8.ui.AbstractSingleComponentContainer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Tag(value="div")
@CssImport(value="./absolute-layout.css")
public class AbsoluteLayout
extends AbstractLayout
implements LayoutEvents.LayoutClickNotifier {
    public static final String CLASSNAME = "v-absolutelayout";
    private final LinkedHashSet<Wrapper> children = new LinkedHashSet();

    public AbsoluteLayout() {
        this.setSizeFull();
        this.setPrimaryStyleName(CLASSNAME);
        this.setStyleName("v-layout");
    }

    @Override
    public void addComponent(Component c) {
        this.addComponent(c, new ComponentPosition());
    }

    public void addComponent(Component c, String cssPosition) {
        ComponentPosition position = new ComponentPosition();
        position.setCSSString(cssPosition);
        this.addComponent(c, position);
    }

    private void addComponent(Component c, ComponentPosition position) throws IllegalArgumentException {
        boolean isChildOfThis = c.getParent().flatMap(Component::getParent).map(this::equals).orElse(false);
        if (isChildOfThis) {
            this.removeComponent(c);
        }
        Wrapper wrapper = new Wrapper(c, position);
        this.children.add(wrapper);
        this.markAsDirty();
        try {
            super.addComponent(wrapper);
        }
        catch (IllegalArgumentException e) {
            this.children.remove(wrapper);
            throw e;
        }
    }

    @Override
    public void removeComponent(Component component) {
        Optional<Wrapper> childOptional = this.children.stream().filter(child -> child.getContent().equals(component)).findFirst();
        if (childOptional.isPresent()) {
            Wrapper wrapper = childOptional.orElseThrow();
            this.children.remove(wrapper);
            super.removeComponent(wrapper);
        }
    }

    @Override
    public void replaceComponent(Component oldComponent, Component newComponent) {
        ComponentPosition position = this.getPosition(oldComponent);
        this.removeComponent(oldComponent);
        this.addComponent(newComponent, position);
    }

    @Override
    public int getComponentCount() {
        return this.children.size();
    }

    @Override
    public Iterator<Component> iterator() {
        return this.children.stream().map(AbstractSingleComponentContainer::getContent).collect(Collectors.toUnmodifiableList()).iterator();
    }

    public ComponentPosition getPosition(Component component) {
        return this.children.stream().filter(wrapper -> wrapper.getContent().equals(component)).findFirst().map(Wrapper::getPosition).orElse(null);
    }

    public void setPosition(Component component, ComponentPosition position) {
        Wrapper wrapper = this.children.stream().filter(c -> c.getContent().equals(component)).findFirst().orElseThrow(() -> new IllegalArgumentException("Component must be a child of this layout"));
        wrapper.setPosition(position);
        this.markAsDirty();
    }

    @Override
    public Registration addLayoutClickListener(LayoutEvents.LayoutClickListener listener) {
        return this.addListener("lClick", LayoutEvents.LayoutClickEvent.class, null, null);
    }

    @Deprecated
    public void removeLayoutClickListener(LayoutEvents.LayoutClickListener listener) {
        Helpers.logUnsupportedApiCall(this.getClass(), "removeLayoutClickListener");
    }

    public class ComponentPosition
    implements Serializable {
        private int zIndex = -1;
        private Float topValue = null;
        private Float rightValue = null;
        private Float bottomValue = null;
        private Float leftValue = null;
        private Sizeable.Unit topUnits = Sizeable.Unit.PIXELS;
        private Sizeable.Unit rightUnits = Sizeable.Unit.PIXELS;
        private Sizeable.Unit bottomUnits = Sizeable.Unit.PIXELS;
        private Sizeable.Unit leftUnits = Sizeable.Unit.PIXELS;

        public void setCSSString(String css) {
            this.leftValue = null;
            this.bottomValue = null;
            this.rightValue = null;
            this.topValue = null;
            this.bottomUnits = this.leftUnits = Sizeable.Unit.PIXELS;
            this.rightUnits = this.leftUnits;
            this.topUnits = this.leftUnits;
            this.zIndex = -1;
            if (css == null) {
                return;
            }
            for (String cssProperty : css.split(";")) {
                String[] keyValuePair = cssProperty.split(":");
                String key = keyValuePair[0].trim();
                if (key.isEmpty()) continue;
                if (key.equals("z-index")) {
                    this.zIndex = Integer.parseInt(keyValuePair[1].trim());
                    continue;
                }
                String value = keyValuePair.length > 1 ? keyValuePair[1].trim() : "";
                String symbol = value.replaceAll("[0-9\\.\\-]+", "");
                if (!symbol.isEmpty()) {
                    value = value.substring(0, value.indexOf(symbol)).trim();
                }
                float v = Float.parseFloat(value);
                Sizeable.Unit unit = Sizeable.Unit.getUnitFromSymbol(symbol);
                if (key.equals("top")) {
                    this.topValue = Float.valueOf(v);
                    this.topUnits = unit;
                    continue;
                }
                if (key.equals("right")) {
                    this.rightValue = Float.valueOf(v);
                    this.rightUnits = unit;
                    continue;
                }
                if (key.equals("bottom")) {
                    this.bottomValue = Float.valueOf(v);
                    this.bottomUnits = unit;
                    continue;
                }
                if (!key.equals("left")) continue;
                this.leftValue = Float.valueOf(v);
                this.leftUnits = unit;
            }
            AbsoluteLayout.this.markAsDirty();
        }

        public String getCSSString() {
            Object s = "";
            if (this.topValue != null) {
                s = (String)s + "top:" + this.topValue + this.topUnits.getSymbol() + ";";
            }
            if (this.rightValue != null) {
                s = (String)s + "right:" + this.rightValue + this.rightUnits.getSymbol() + ";";
            }
            if (this.bottomValue != null) {
                s = (String)s + "bottom:" + this.bottomValue + this.bottomUnits.getSymbol() + ";";
            }
            if (this.leftValue != null) {
                s = (String)s + "left:" + this.leftValue + this.leftUnits.getSymbol() + ";";
            }
            if (this.zIndex >= 0) {
                s = (String)s + "z-index:" + this.zIndex + ";";
            }
            return s;
        }

        public void setTop(Float topValue, Sizeable.Unit topUnits) {
            this.topValue = topValue;
            this.topUnits = topUnits;
            AbsoluteLayout.this.markAsDirty();
        }

        public void setRight(Float rightValue, Sizeable.Unit rightUnits) {
            this.rightValue = rightValue;
            this.rightUnits = rightUnits;
            AbsoluteLayout.this.markAsDirty();
        }

        public void setBottom(Float bottomValue, Sizeable.Unit bottomUnits) {
            this.bottomValue = bottomValue;
            this.bottomUnits = bottomUnits;
            AbsoluteLayout.this.markAsDirty();
        }

        public void setLeft(Float leftValue, Sizeable.Unit leftUnits) {
            this.leftValue = leftValue;
            this.leftUnits = leftUnits;
            AbsoluteLayout.this.markAsDirty();
        }

        public void setZIndex(int zIndex) {
            this.zIndex = zIndex;
            AbsoluteLayout.this.markAsDirty();
        }

        public void setTopValue(Float topValue) {
            this.topValue = topValue;
            AbsoluteLayout.this.markAsDirty();
        }

        public Float getTopValue() {
            return this.topValue;
        }

        public Float getRightValue() {
            return this.rightValue;
        }

        public void setRightValue(Float rightValue) {
            this.rightValue = rightValue;
            AbsoluteLayout.this.markAsDirty();
        }

        public Float getBottomValue() {
            return this.bottomValue;
        }

        public void setBottomValue(Float bottomValue) {
            this.bottomValue = bottomValue;
            AbsoluteLayout.this.markAsDirty();
        }

        public Float getLeftValue() {
            return this.leftValue;
        }

        public void setLeftValue(Float leftValue) {
            this.leftValue = leftValue;
            AbsoluteLayout.this.markAsDirty();
        }

        public Sizeable.Unit getTopUnits() {
            return this.topUnits;
        }

        public void setTopUnits(Sizeable.Unit topUnits) {
            this.topUnits = topUnits;
            AbsoluteLayout.this.markAsDirty();
        }

        public Sizeable.Unit getRightUnits() {
            return this.rightUnits;
        }

        public void setRightUnits(Sizeable.Unit rightUnits) {
            this.rightUnits = rightUnits;
            AbsoluteLayout.this.markAsDirty();
        }

        public Sizeable.Unit getBottomUnits() {
            return this.bottomUnits;
        }

        public void setBottomUnits(Sizeable.Unit bottomUnits) {
            this.bottomUnits = bottomUnits;
            AbsoluteLayout.this.markAsDirty();
        }

        public Sizeable.Unit getLeftUnits() {
            return this.leftUnits;
        }

        public void setLeftUnits(Sizeable.Unit leftUnits) {
            this.leftUnits = leftUnits;
            AbsoluteLayout.this.markAsDirty();
        }

        public int getZIndex() {
            return this.zIndex;
        }

        public String toString() {
            return this.getCSSString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentPosition position = (ComponentPosition)o;
            return this.zIndex == position.zIndex && Objects.equals(this.topValue, position.topValue) && Objects.equals(this.rightValue, position.rightValue) && Objects.equals(this.bottomValue, position.bottomValue) && Objects.equals(this.leftValue, position.leftValue) && this.topUnits == position.topUnits && this.rightUnits == position.rightUnits && this.bottomUnits == position.bottomUnits && this.leftUnits == position.leftUnits;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.zIndex, this.topValue, this.rightValue, this.bottomValue, this.leftValue, this.topUnits, this.rightUnits, this.bottomUnits, this.leftUnits});
        }
    }

    @Tag(value="div")
    private class Wrapper
    extends AbstractSingleComponentContainer {
        private String css;
        private ComponentPosition position;

        Wrapper(Component content, ComponentPosition position) {
            this.addStyleName("v-absolutelayout-wrapper");
            this.addStyleName("v-absolutelayout-wrapper-absolutelayout-childcomponent");
            this.setContent(content);
            this.setPosition(position);
        }

        void setPosition(String cssPosition) {
            if (this.css == null || !this.css.equals(cssPosition)) {
                this.position.setCSSString(cssPosition);
                this.css = cssPosition;
                String zIndex = null;
                String left = null;
                String bottom = null;
                String right = null;
                String top = null;
                if (!this.css.isEmpty()) {
                    block14: for (String property : this.css.split(";")) {
                        String[] keyValue = property.split(":");
                        String key = keyValue[0];
                        String value = keyValue[1];
                        switch (key) {
                            case "left": {
                                left = value;
                                continue block14;
                            }
                            case "top": {
                                top = value;
                                continue block14;
                            }
                            case "right": {
                                right = value;
                                continue block14;
                            }
                            case "bottom": {
                                bottom = value;
                                continue block14;
                            }
                            case "z-index": {
                                zIndex = value;
                            }
                        }
                    }
                }
                this.getElement().getStyle().set("z-index", zIndex).set("top", top).set("left", left).set("right", right).set("bottom", bottom);
            }
        }

        ComponentPosition getPosition() {
            return this.position;
        }

        void setPosition(ComponentPosition position) {
            this.position = position;
            this.setPosition(position.getCSSString());
        }
    }
}

