/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.ui;

import com.vaadin.classic.v8.event.ActionManager;
import com.vaadin.classic.v8.event.ShortcutListener;
import com.vaadin.classic.v8.server.AbstractClientConnector;
import com.vaadin.classic.v8.server.ComponentSizeValidator;
import com.vaadin.classic.v8.server.ErrorMessage;
import com.vaadin.classic.v8.server.Helpers;
import com.vaadin.classic.v8.server.Resource;
import com.vaadin.classic.v8.server.SizeWithUnit;
import com.vaadin.classic.v8.server.Sizeable;
import com.vaadin.classic.v8.shared.AbstractComponentState;
import com.vaadin.classic.v8.shared.ui.ContentMode;
import com.vaadin.classic.v8.ui.AbstractComponentContainer;
import com.vaadin.classic.v8.ui.AbstractOrderedLayout;
import com.vaadin.classic.v8.ui.Event;
import com.vaadin.classic.v8.ui.HasComponents;
import com.vaadin.classic.v8.ui.Listener;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.data.binder.ErrorLevel;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public abstract class AbstractComponent
extends AbstractClientConnector
implements Sizeable,
HasEnabled {
    private static final String HAS_HEIGHT_STYLE = "v-has-height";
    private static final String HAS_WIDTH_STYLE = "v-has-width";
    private SizeWithUnit cachedWidth;
    private SizeWithUnit cachedHeight;
    private String primaryStyleName;
    private List<String> customStyles;
    private List<String> internalStyles = new ArrayList<String>();
    private Locale locale;

    public AbstractComponent() {
        this.internalStyles.add("v-widget");
        this.internalStyles.add("v-lcp");
    }

    @Override
    public void beforeClientResponse(boolean initial) {
        super.beforeClientResponse(initial);
        if (this.getHeight() >= 0.0f && (this.getHeightUnits() != Sizeable.Unit.PERCENTAGE || ComponentSizeValidator.parentCanDefineHeight(this))) {
            this.getElement().getStyle().set("height", this.getCSSHeight());
            this.addInternalStyles(HAS_HEIGHT_STYLE);
        } else {
            this.getElement().getStyle().set("height", null);
            this.removeInternalStyles(HAS_HEIGHT_STYLE);
        }
        if (this.getWidth() >= 0.0f && (this.getWidthUnits() != Sizeable.Unit.PERCENTAGE || ComponentSizeValidator.parentCanDefineWidth(this))) {
            this.getElement().getStyle().set("width", this.getCSSWidth());
            this.addInternalStyles(HAS_WIDTH_STYLE);
        } else {
            this.getElement().getStyle().set("width", null);
            this.removeInternalStyles(HAS_WIDTH_STYLE);
        }
        String styleName = this.createClassName();
        this.getElement().setAttribute("class", styleName);
    }

    public void setParent(HasComponents parent) {
        Component oldParent = this.getParent().orElse(null);
        if (parent != null && oldParent != null) {
            throw new IllegalStateException(this.getClass().getName() + " already has a parent.");
        }
        if (Objects.equals(oldParent, parent)) {
            return;
        }
        if (oldParent instanceof AbstractComponent) {
            ((AbstractComponent)oldParent).markAsDirtyRecursive();
        }
    }

    protected void fireComponentEvent() {
        this.fireEvent(new Event(this));
    }

    protected void focus() {
    }

    protected boolean isOrHasAncestor(Component content) {
        if (content instanceof com.vaadin.flow.component.HasComponents || content instanceof HasComponents) {
            if (Objects.equals(this, content)) {
                return true;
            }
            Optional optionalParent = this.getParent();
            while (optionalParent.isPresent()) {
                Component parent = (Component)optionalParent.get();
                if (parent.equals(content)) {
                    return true;
                }
                optionalParent = parent.getParent();
            }
        }
        return false;
    }

    @Override
    public void setWidth(String width) {
        SizeWithUnit parsedWidth = SizeWithUnit.parseStringSize(width);
        if (parsedWidth != null) {
            this.setWidth(parsedWidth.getSize(), parsedWidth.getUnit());
        } else {
            this.setWidth(-1.0f, Sizeable.Unit.PIXELS);
        }
    }

    @Override
    public void setWidth(float width, Sizeable.Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit can not be null");
        }
        this.doSetWidth(new SizeWithUnit(width, unit));
    }

    @Override
    public float getWidth() {
        return this.cachedWidth == null ? -1.0f : this.cachedWidth.getSize();
    }

    @Override
    public Sizeable.Unit getWidthUnits() {
        return this.cachedWidth == null ? Sizeable.Unit.PIXELS : this.cachedWidth.getUnit();
    }

    @Override
    public void setHeight(String height) {
        SizeWithUnit parsedHeight = SizeWithUnit.parseStringSize(height);
        if (parsedHeight != null) {
            this.setHeight(parsedHeight.getSize(), parsedHeight.getUnit());
        } else {
            this.setHeight(-1.0f, Sizeable.Unit.PIXELS);
        }
    }

    @Override
    public void setHeight(float height, Sizeable.Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit can not be null");
        }
        this.doSetHeight(new SizeWithUnit(height, unit));
    }

    @Override
    public float getHeight() {
        return this.cachedHeight == null ? -1.0f : this.cachedHeight.getSize();
    }

    @Override
    public Sizeable.Unit getHeightUnits() {
        return this.cachedHeight == null ? Sizeable.Unit.PIXELS : this.cachedHeight.getUnit();
    }

    @Override
    public void setSizeFull() {
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
    }

    @Override
    public void setWidthFull() {
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
    }

    @Override
    public void setHeightFull() {
        this.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
    }

    @Override
    public void setSizeUndefined() {
        this.setWidthUndefined();
        this.setHeightUndefined();
    }

    @Override
    public void setWidthUndefined() {
        this.setWidth(-1.0f, Sizeable.Unit.PIXELS);
    }

    @Override
    public void setHeightUndefined() {
        this.setHeight(-1.0f, Sizeable.Unit.PIXELS);
    }

    private String getCSSHeight() {
        return this.getHeight() + this.getHeightUnits().getSymbol();
    }

    private String getCSSWidth() {
        return this.getWidth() + this.getWidthUnits().getSymbol();
    }

    protected void doSetWidth(SizeWithUnit width) {
        this.cachedWidth = width;
        this.getParent().ifPresent(parent -> {
            if (parent instanceof AbstractComponentContainer) {
                ((AbstractComponentContainer)parent).markAsDirtyRecursive();
            } else {
                this.markAsDirty();
            }
        });
    }

    protected void doSetHeight(SizeWithUnit height) {
        this.cachedHeight = height;
        this.getParent().ifPresent(parent -> {
            if (parent instanceof AbstractComponentContainer) {
                ((AbstractComponentContainer)parent).markAsDirtyRecursive();
            } else {
                this.markAsDirty();
            }
        });
    }

    public String getStyleName() {
        return this.customStyles == null ? "" : this.customStyles.stream().collect(Collectors.joining(" "));
    }

    public void setStyleName(String style) {
        if (style == null || style.isEmpty()) {
            this.customStyles = null;
            this.markAsDirty();
            return;
        }
        if (this.customStyles == null) {
            this.customStyles = new ArrayList<String>();
        } else {
            this.customStyles.clear();
        }
        StringTokenizer tokenizer = new StringTokenizer(style, " ");
        while (tokenizer.hasMoreTokens()) {
            this.customStyles.add(tokenizer.nextToken());
        }
        this.markAsDirty();
        this.notifyParentAboutStyleChanges();
    }

    public void setStyleName(String style, boolean add) {
        if (add) {
            this.addStyleName(style);
        } else {
            this.removeStyleName(style);
        }
    }

    public void addStyleName(String style) {
        if (style == null || style.isEmpty()) {
            return;
        }
        if (this.customStyles != null && this.customStyles.contains(style)) {
            return;
        }
        if (style.contains(" ")) {
            StringTokenizer tokenizer = new StringTokenizer(style, " ");
            while (tokenizer.hasMoreTokens()) {
                this.addStyleName(tokenizer.nextToken());
            }
            return;
        }
        if (this.customStyles == null) {
            this.customStyles = new ArrayList<String>();
        }
        this.customStyles.add(style);
        this.markAsDirty();
        this.notifyParentAboutStyleChanges();
    }

    public void addStyleNames(String ... styles) {
        for (String style : styles) {
            this.addStyleName(style);
        }
    }

    public void removeStyleName(String style) {
        StringTokenizer tokenizer = new StringTokenizer(style, " ");
        while (tokenizer.hasMoreTokens()) {
            this.customStyles.remove(tokenizer.nextToken());
        }
        this.markAsDirty();
        this.notifyParentAboutStyleChanges();
    }

    public void removeStyleNames(String ... styles) {
        for (String style : styles) {
            this.removeStyleName(style);
        }
    }

    public String getPrimaryStyleName() {
        return this.primaryStyleName;
    }

    public void setPrimaryStyleName(String style) {
        if (!Objects.equals(style, this.primaryStyleName)) {
            this.primaryStyleName = style;
            this.markAsDirty();
        }
    }

    protected void notifyParentAboutStyleChanges() {
        this.getParent().ifPresent(parent -> {
            if (parent instanceof AbstractOrderedLayout) {
                ((AbstractOrderedLayout)parent).markAsDirty();
            }
        });
    }

    protected void addInternalStyles(String ... internalStyles) {
        this.internalStyles.addAll(Arrays.asList(internalStyles));
        this.markAsDirty();
    }

    protected void removeInternalStyles(String ... internalStyles) {
        this.internalStyles.removeAll(Arrays.asList(internalStyles));
        this.markAsDirty();
    }

    protected Collection<String> getInternalStyles() {
        if (this.internalStyles == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.internalStyles);
    }

    protected Collection<String> getCustomStyles() {
        if (this.customStyles == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.customStyles);
    }

    private String createClassName() {
        StringBuilder builder = new StringBuilder();
        String primaryStyleName = this.getPrimaryStyleName();
        if (primaryStyleName != null) {
            builder.append(primaryStyleName);
        }
        if (!this.internalStyles.isEmpty()) {
            builder.append(" ").append(this.internalStyles.stream().collect(Collectors.joining(" ")));
        }
        if (this.customStyles != null) {
            this.customStyles.forEach(style -> {
                if (primaryStyleName != null) {
                    builder.append(" ").append(primaryStyleName).append("-").append((String)style);
                }
                builder.append(" ").append((String)style);
            });
        }
        return builder.toString();
    }

    public Registration addListener(Listener listener) {
        return this.addListener(Event.class, listener);
    }

    public void onEnabledStateChanged(boolean enabled) {
        if (!enabled) {
            this.addInternalStyles("v-disabled");
        } else {
            this.removeInternalStyles("v-disabled");
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public void setData(Object data) {
        ComponentUtil.setData((Component)this, DataKey.class, (Object)new DataKey(data));
    }

    public Object getData() {
        DataKey data = (DataKey)ComponentUtil.getData((Component)this, DataKey.class);
        if (data != null) {
            return data.getValue();
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.markAsDirty();
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        Optional<AbstractComponent> parent = this.getFirstAbstractComponentParent(this);
        if (parent.isPresent()) {
            return parent.get().getLocale();
        }
        VaadinSession session = this.getSession();
        if (session != null) {
            return session.getLocale();
        }
        return null;
    }

    private Optional<AbstractComponent> getFirstAbstractComponentParent(Component component) {
        Optional parent = component.getParent();
        if (parent.isPresent() && parent.get() instanceof AbstractComponent) {
            return Optional.of((AbstractComponent)parent.get());
        }
        if (parent.isPresent()) {
            return this.getFirstAbstractComponentParent((Component)parent.get());
        }
        return Optional.empty();
    }

    public boolean isVisible() {
        return super.isVisible();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Deprecated
    public Registration addShortcutListener(ShortcutListener shortcut) {
        Class<?> aClass = this.getClass();
        Helpers.logUnsupportedApiCall(aClass, "addShortcutListener(ShortcutListener)");
        return (Registration & Serializable)() -> Helpers.logUnsupportedApiCall(aClass, "Registration.remove() returned by " + aClass + ".addShortcutListener(ShortcutListener)");
    }

    @Deprecated
    public Resource getIcon() {
        final Class<?> aClass = this.getClass();
        Helpers.logUnsupportedApiCall(aClass, "getIcon()");
        return new Resource(){

            @Override
            public String getMIMEType() {
                Helpers.logUnsupportedApiCall(aClass, "Resource.getMIMEType() obtained via " + aClass.getName() + ".getIcon()");
                return "";
            }
        };
    }

    @Deprecated
    protected void fireComponentErrorEvent() {
        Helpers.logUnsupportedApiCall(this.getClass(), "fireComponentErrorEvent()");
    }

    @Deprecated
    protected ActionManager getActionManager() {
        Helpers.logUnsupportedApiCall(this.getClass(), "getActionManager()");
        return new ActionManager();
    }

    @Deprecated
    public String getCaption() {
        Helpers.logUnsupportedApiCall(this.getClass(), "getCaption()");
        return "";
    }

    @Deprecated
    public ErrorMessage getComponentError() {
        final Class<?> aClass = this.getClass();
        Helpers.logUnsupportedApiCall(aClass, "getComponentError");
        return new ErrorMessage(){

            @Override
            public ErrorLevel getErrorLevel() {
                Helpers.logUnsupportedApiCall(aClass, "ErrorMessage.getErrorLevel() obtained via " + aClass + ".getComponentError()");
                return ErrorLevel.INFO;
            }

            @Override
            public String getFormattedHtmlMessage() {
                Helpers.logUnsupportedApiCall(aClass, "ErrorMessage.getFormattedHtmlMessage() obtained via " + aClass + ".getComponentError()");
                return "";
            }
        };
    }

    @Deprecated
    protected Collection<String> getCustomAttributes() {
        Helpers.logUnsupportedApiCall(this.getClass(), "getCustomAttributes()");
        return Collections.emptyList();
    }

    @Deprecated
    public String getDescription() {
        Helpers.logUnsupportedApiCall(this.getClass(), "getDescription()");
        return "";
    }

    @Deprecated
    public ErrorMessage getErrorMessage() {
        final Class<?> aClass = this.getClass();
        Helpers.logUnsupportedApiCall(aClass, "getErrorMessage()");
        return new ErrorMessage(){

            @Override
            public ErrorLevel getErrorLevel() {
                Helpers.logUnsupportedApiCall(aClass, "ErrorMessage.getErrorLevel() obtained via " + aClass + ".getErrorMessage()");
                return ErrorLevel.INFO;
            }

            @Override
            public String getFormattedHtmlMessage() {
                Helpers.logUnsupportedApiCall(aClass, "ErrorMessage.getFormattedHtmlMessage() obtained via " + aClass + ".getErrorMessage()");
                return "";
            }
        };
    }

    @Override
    @Deprecated
    protected AbstractComponentState getState() {
        Helpers.logUnsupportedApiCall(this.getClass(), "getState()");
        return new AbstractComponentState();
    }

    @Override
    @Deprecated
    protected AbstractComponentState getState(boolean markAsDirty) {
        Helpers.logUnsupportedApiCall(this.getClass(), "getState(boolean)");
        return new AbstractComponentState();
    }

    @Deprecated
    public boolean isCaptionAsHtml() {
        Helpers.logUnsupportedApiCall(this.getClass(), "isCaptionAsHtml()");
        return false;
    }

    @Deprecated
    protected boolean isReadOnly() {
        Helpers.logUnsupportedApiCall(this.getClass(), "isReadOnly()");
        return false;
    }

    @Deprecated
    protected boolean isRequiredIndicatorVisible() {
        Helpers.logUnsupportedApiCall(this.getClass(), "isRequireIndicatorVisible()");
        return false;
    }

    @Deprecated
    public boolean isResponsive() {
        Helpers.logUnsupportedApiCall(this.getClass(), "isResponsive()");
        return false;
    }

    @Deprecated
    public void setCaption(String caption) {
        Helpers.logUnsupportedApiCall(this.getClass(), "setCaption(String)");
    }

    @Deprecated
    public void setCaptionAsHtml(boolean captionAsHtml) {
        Helpers.logUnsupportedApiCall(this.getClass(), "setCaptionAsHtml(boolean)");
    }

    @Deprecated
    public void setComponentError(ErrorMessage componentError) {
        Helpers.logUnsupportedApiCall(this.getClass(), "setComponentError(ErrorMessage)");
    }

    @Deprecated
    public void setDescription(String description) {
        Helpers.logUnsupportedApiCall(this.getClass(), "setDescription(String)");
    }

    @Deprecated
    public void setDescription(String description, ContentMode mode) {
        Helpers.logUnsupportedApiCall(this.getClass(), "setDescription(String, ContentMode)");
    }

    @Deprecated
    public void setIcon(Resource icon) {
        Helpers.logUnsupportedApiCall(this.getClass(), "setIcon(Resource)");
    }

    @Deprecated
    protected void setReadOnly(boolean readOnly) {
        Helpers.logUnsupportedApiCall(this.getClass(), "setReadOnly(boolean)");
    }

    @Deprecated
    protected void setRequiredIndicatorVisible(boolean visible) {
        Helpers.logUnsupportedApiCall(this.getClass(), "setRequiredIndicatorVisible(boolean)");
    }

    @Deprecated
    public void setResponsive(boolean responsive) {
        Helpers.logUnsupportedApiCall(this.getClass(), "setResponsive(boolean)");
    }

    private static class DataKey {
        private final Object value;

        public DataKey(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

