/*
 * Copyright (c) 2000-2022 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */
package com.vaadin.classic.v8.ui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.html.Span;

/**
 * A component based in the Table Data Cell &lt;td&gt; element.
 */
@Tag("td")
class TableDataCell extends AbstractSingleComponentContainer {

    /**
     * Creates a new empty Table Data Cell.
     */
    public TableDataCell() {
    }

    /**
     * Creates a new Table Data Cell with some text in it.
     *
     * @param text the text to use as content of the cell.
     */
    public TableDataCell(String text) {
        this.setContent(new Span(text));
    }

    /**
     * Creates a new Table Data Cell with a component as its content.
     *
     * @param child the component to use as the content of the cell.
     */
    public TableDataCell(Component child) {
        super();
        this.setContent(child);
    }
}
