/*
 * Copyright (c) 2000-2022 Vaadin Ltd.
 *
 * This program is available under Vaadin Commercial License and Service Terms.
 *
 * See <https://vaadin.com/commercial-license-and-service-terms> for the full license.
 */
package com.vaadin.classic.v8.event;

import java.io.Serializable;

import com.vaadin.classic.v8.server.Helpers;
import com.vaadin.classic.v8.server.Resource;
import com.vaadin.flow.shared.Registration;

/**
 * Not supported. See Classic Component Pack documentation in
 * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
 * mitigation options.
 */
@Deprecated
public class Action implements Serializable {

    /**
     * Not supported. See Classic Component Pack documentation in
     * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
     * mitigation options.
     *
     * @param caption
     *            caption
     */
    @Deprecated
    public Action(String caption) {
        Helpers.logUnsupportedApiCall(getClass(), "Action(String)");
    }

    /**
     * Not supported. See Classic Component Pack documentation in
     * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
     * mitigation options.
     *
     * @param caption
     *            the caption for the new action.
     * @param icon
     *            the icon for the new action.
     */
    @Deprecated
    public Action(String caption, Resource icon) {
        Helpers.logUnsupportedApiCall(getClass(), "Action(String, Resource)");
    }

    /**
     * Not supported. See Classic Component Pack documentation in
     * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
     * mitigation options.
     *
     * @return empty string
     */
    @Deprecated
    public String getCaption() {
        Helpers.logUnsupportedApiCall(getClass(), "getCaption()");
        return "";
    }

    /**
     * Not supported. See Classic Component Pack documentation in
     * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
     * mitigation options.
     *
     * @return the action's Icon.
     */
    @Deprecated
    public Resource getIcon() {
        final Class<? extends Action> aClass = getClass();
        Helpers.logUnsupportedApiCall(aClass, "getIcon()");
        return new Resource() {
            @Override
            public String getMIMEType() {
                Helpers.logUnsupportedApiCall(aClass,
                        "Resource.getMIMEType() obtained via "
                                + aClass.getName() + ".getIcon()");
                return "";
            }
        };
    }

    /**
     * Not supported. See Classic Component Pack documentation in
     * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
     * mitigation options.
     */
    @Deprecated
    @FunctionalInterface
    public interface Listener extends Serializable {
        /**
         * Not supported. See Classic Component Pack documentation in
         * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack
         * for mitigation options.
         *
         * @param sender
         *            sender
         * @param target
         *            target
         */
        @Deprecated
        public void handleAction(Object sender, Object target);
    }

    /**
     * Not supported. See Classic Component Pack documentation in
     * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
     * mitigation options.
     */
    @Deprecated
    public interface Notifier extends Container {
        /**
         * Not supported. See Classic Component Pack documentation in
         * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack
         * for mitigation options.
         *
         * @param action
         *            action
         * @param <T>
         *            type
         */
        @Deprecated
        public <T extends Action & Action.Listener> void addAction(T action);

        /**
         * Not supported. See Classic Component Pack documentation in
         * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack
         * for mitigation options.
         *
         * @param action
         *            action
         * @param <T>
         *            type
         */
        @Deprecated
        public <T extends Action & Action.Listener> void removeAction(T action);
    }

    /**
     * Not supported. See Classic Component Pack documentation in
     * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
     * mitigation options.
     */
    @Deprecated
    public interface ShortcutNotifier extends Serializable {
        /**
         * Not supported. See Classic Component Pack documentation in
         * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack
         * for mitigation options.
         *
         * @param shortcut
         *            listener to add
         * @return registration for unregistering the listener
         */
        @Deprecated
        public Registration addShortcutListener(ShortcutListener shortcut);
    }

    /**
     * Not supported. See Classic Component Pack documentation in
     * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
     * mitigation options.
     */
    @Deprecated
    public interface Handler extends Serializable {

        /**
         * Not supported. See Classic Component Pack documentation in
         * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack
         * for mitigation options.
         *
         * @param target
         *            the target handler to list actions for. For item
         *            containers this is the item id.
         * @param sender
         *            the party that would be sending the actions. Most of this
         *            is the action container.
         * @return empty list
         */
        @Deprecated
        public Action[] getActions(Object target, Object sender);

        /**
         * Not supported. See Classic Component Pack documentation in
         * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack
         * for mitigation options.
         *
         * @param action
         *            the action to be handled.
         * @param sender
         *            the sender of the action. This is most often the action
         *            container.
         * @param target
         *            the target of the action. For item containers this is the
         *            item id.
         */
        @Deprecated
        public void handleAction(Action action, Object sender, Object target);
    }

    /**
     * Not supported. See Classic Component Pack documentation in
     * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
     * mitigation options.
     */
    @Deprecated
    public interface Container extends Serializable {

        /**
         * Not supported. See Classic Component Pack documentation in
         * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack
         * for mitigation options.
         *
         * @param actionHandler
         *            the new handler to be added.
         */
        @Deprecated
        public void addActionHandler(Action.Handler actionHandler);

        /**
         * Not supported. See Classic Component Pack documentation in
         * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack
         * for mitigation options.
         *
         * @param actionHandler
         *            the handler to be removed.
         */
        @Deprecated
        public void removeActionHandler(Action.Handler actionHandler);
    }

    /**
     * Not supported. See Classic Component Pack documentation in
     * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
     * mitigation options.
     *
     * @param caption
     *            the caption to set.
     */
    @Deprecated
    public void setCaption(String caption) {
        Helpers.logUnsupportedApiCall(getClass(), "setCaption(String)");
    }

    /**
     * Not supported. See Classic Component Pack documentation in
     * https://vaadin.com/docs/latest/flow/upgrading/legacy-component-pack for
     * mitigation options.
     *
     * @param icon
     *            the icon to set.
     */
    @Deprecated
    public void setIcon(Resource icon) {
        Helpers.logUnsupportedApiCall(getClass(), "setIcon(String)");
    }

}
