/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.classic.v8.ui;

import com.vaadin.classic.v8.ui.AbstractOrderedLayout;
import com.vaadin.classic.v8.ui.MarginInfo;
import com.vaadin.classic.v8.ui.Table;
import com.vaadin.classic.v8.ui.TableDataCell;
import com.vaadin.classic.v8.ui.TableRow;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import java.io.Serializable;
import java.util.stream.Stream;

@Tag(value="div")
@CssImport.Container(value={@CssImport(value="./ordered-layout.css"), @CssImport(value="./margin.css")})
@JsModule(value="./form-layout-styles.js")
public class FormLayout
extends AbstractOrderedLayout {
    private static final String CLASSNAME = "v-formlayout";
    public static final String IN_FORM_LAYOUT_THEME = "in-form-layout";
    private final Table table = new Table();

    public FormLayout() {
        super(true);
        this.add(this.table);
        this.setPrimaryStyleName(CLASSNAME);
        this.setMargin(new MarginInfo(true, false));
        this.addStyleName("outlined");
    }

    public FormLayout(Component ... children) {
        this();
        this.addComponents(children);
    }

    @Override
    @Deprecated
    public float getExpandRatio(Component component) {
        return 0.0f;
    }

    @Override
    public void setExpandRatio(Component component, float ratio) {
    }

    @Override
    public void addComponent(Component component) {
        if (component == this.table) {
            super.addComponent(component);
        } else {
            if (component instanceof HasTheme) {
                ((HasTheme)component).addThemeName(IN_FORM_LAYOUT_THEME);
            }
            FormRow row = new FormRow(component);
            this.table.addComponent(row);
        }
    }

    @Override
    public void removeComponent(Component component) {
        this.table.getChildren().map(row -> (FormRow)row).filter(row -> row.getContent().equals(component)).findFirst().ifPresent(xva$0 -> this.table.remove((Component)xva$0));
    }

    @Override
    public int getComponentIndex(Component component) {
        return this.table.getChildren().map(row -> (FormRow)row).map(FormRow::getContent).toList().indexOf(component);
    }

    @Override
    public Component getComponent(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.table.getComponentCount()) {
            throw new IndexOutOfBoundsException();
        }
        return this.table.getChildren().skip(index).findFirst().map(component -> (FormRow)component).map(FormRow::getContent).orElseThrow();
    }

    @Override
    public void addComponent(Component component, int index) throws IndexOutOfBoundsException {
        int componentCount = this.table.getComponentCount();
        if (index < 0 || index > componentCount) {
            throw new IndexOutOfBoundsException();
        }
        if (componentCount == 0 || index == componentCount) {
            this.add(component);
            return;
        }
        if (component instanceof HasTheme) {
            ((HasTheme)component).addThemeName(IN_FORM_LAYOUT_THEME);
        }
        FormRow row = new FormRow(component);
        this.table.addComponentAtIndex(index, row);
    }

    Table getTable() {
        return this.table;
    }

    @Override
    protected void setSlotClasses() {
    }

    @Override
    public Stream<Component> getChildren() {
        return this.table.getChildren().map(row -> (FormRow)row).map(FormRow::getContent);
    }

    private static final class FormRow
    extends TableRow {
        private final TableDataCell captionCell;
        private final TableDataCell contentCell;

        FormRow(Component component) {
            HasLabel labeledComponent;
            this.addStyleName("v-formlayout-row");
            this.captionCell = new TableDataCell();
            this.captionCell.addStyleName("v-formlayout-captioncell");
            this.contentCell = new TableDataCell(component);
            this.contentCell.addStyleName("v-formlayout-contentcell");
            String labelText = component instanceof HasLabel && (labeledComponent = (HasLabel)component).getLabel() != null && !labeledComponent.getLabel().isBlank() ? labeledComponent.getLabel() : "";
            component.getElement().executeJs("if (this.hasAttribute('required')) { this.closest('tr').firstChild.innerHTML = `<span>` + $0 + `</span><span class=\"v-required-field-indicator\">*</span>` } else { this.closest('tr').firstChild.innerHTML = `<span>` + $0 + `</span>`; }if (this.tagName.toLowerCase() === 'vaadin-checkbox') { this.closest('tr').firstChild.innerText = ''; }", new Serializable[]{labelText});
            this.add(this.captionCell, this.contentCell);
        }

        Component getContent() {
            return this.contentCell.getContent();
        }
    }
}

