/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.debugging.sourcemap;

import com.google.gwt.thirdparty.debugging.sourcemap.Base64;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class SourceMapLineDecoder {
    static List<Integer> decodeLine(String lineSource) {
        return SourceMapLineDecoder.decodeLine(new StringParser(lineSource));
    }

    private SourceMapLineDecoder() {
    }

    static LineEntry decodeLineEntry(String in, int lastId) {
        return SourceMapLineDecoder.decodeLineEntry(new StringParser(in), lastId);
    }

    private static LineEntry decodeLineEntry(StringParser reader, int lastId) {
        int value;
        char digit;
        int repDigits = 0;
        char peek = reader.peek();
        while (peek == '!') {
            ++repDigits;
            reader.next();
            peek = reader.peek();
        }
        int idDigits = 0;
        int reps = 0;
        if (repDigits == 0) {
            digit = reader.next();
            value = SourceMapLineDecoder.addBase64Digit(digit, 0);
            reps = value >> 2;
            idDigits = value & 3;
        } else {
            digit = reader.next();
            idDigits = SourceMapLineDecoder.addBase64Digit(digit, 0);
            value = 0;
            int i = 0;
            while (i < repDigits) {
                digit = reader.next();
                value = SourceMapLineDecoder.addBase64Digit(digit, value);
                ++i;
            }
            reps = value;
        }
        ++reps;
        ++idDigits;
        int value2 = 0;
        int i = 0;
        while (i < idDigits) {
            char digit2 = reader.next();
            value2 = SourceMapLineDecoder.addBase64Digit(digit2, value2);
            ++i;
        }
        int mappingId = SourceMapLineDecoder.getIdFromRelativeId(value2, idDigits, lastId);
        return new LineEntry(mappingId, reps);
    }

    private static List<Integer> decodeLine(StringParser reader) {
        ArrayList result = Lists.newArrayListWithCapacity((int)512);
        int lastId = 0;
        while (reader.hasNext()) {
            LineEntry entry = SourceMapLineDecoder.decodeLineEntry(reader, lastId);
            lastId = entry.id;
            int i = 0;
            while (i < entry.reps) {
                result.add(entry.id);
                ++i;
            }
        }
        return result;
    }

    private static int addBase64Digit(char digit, int previousValue) {
        return previousValue * 64 + Base64.fromBase64(digit);
    }

    static int getIdFromRelativeId(int rawId, int digits, int lastId) {
        int base = 1 << digits * 6;
        return (rawId >= base / 2 ? rawId - base : rawId) + lastId;
    }

    static class LineEntry {
        final int id;
        final int reps;

        public LineEntry(int id, int reps) {
            this.id = id;
            this.reps = reps;
        }
    }

    static class StringParser {
        final String content;
        int current = 0;

        StringParser(String content) {
            this.content = content;
        }

        char next() {
            return this.content.charAt(this.current++);
        }

        char peek() {
            return this.content.charAt(this.current);
        }

        boolean hasNext() {
            return this.current < this.content.length() - 1;
        }
    }
}

