/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.debugging.sourcemap;

import java.io.IOException;
import java.nio.charset.CharsetEncoder;

class Util {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    Util() {
    }

    static String escapeString(String s) {
        return Util.escapeString(s, '\"', "\\\"", "'", "\\\\", null);
    }

    static String escapeString(String s, char quote, String doublequoteEscape, String singlequoteEscape, String backslashEscape, CharsetEncoder outputCharsetEncoder) {
        StringBuilder sb = new StringBuilder(s.length() + 2);
        sb.append(quote);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\\': {
                    sb.append(backslashEscape);
                    break;
                }
                case '\"': {
                    sb.append(doublequoteEscape);
                    break;
                }
                case '\'': {
                    sb.append(singlequoteEscape);
                    break;
                }
                case '>': {
                    if (i >= 2 && (s.charAt(i - 1) == '-' && s.charAt(i - 2) == '-' || s.charAt(i - 1) == ']' && s.charAt(i - 2) == ']')) {
                        sb.append("\\>");
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case '<': {
                    String END_SCRIPT = "/script";
                    String START_COMMENT = "!--";
                    if (s.regionMatches(true, i + 1, "/script", 0, "/script".length())) {
                        sb.append("<\\");
                        break;
                    }
                    if (s.regionMatches(false, i + 1, "!--", 0, "!--".length())) {
                        sb.append("<\\");
                        break;
                    }
                    sb.append(c);
                    break;
                }
                default: {
                    if (outputCharsetEncoder != null) {
                        if (outputCharsetEncoder.canEncode(c)) {
                            sb.append(c);
                            break;
                        }
                        Util.appendCharAsHex(sb, c);
                        break;
                    }
                    if (c > '\u001f' && c <= '\u007f') {
                        sb.append(c);
                        break;
                    }
                    Util.appendCharAsHex(sb, c);
                }
            }
            ++i;
        }
        sb.append(quote);
        return sb.toString();
    }

    private static void appendCharAsHex(StringBuilder sb, char c) {
        try {
            Util.appendHexJavaScriptRepresentation(sb, c);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void appendHexJavaScriptRepresentation(Appendable out, int codePoint) throws IOException {
        if (Character.isSupplementaryCodePoint(codePoint)) {
            char[] surrogates = Character.toChars(codePoint);
            Util.appendHexJavaScriptRepresentation(out, surrogates[0]);
            Util.appendHexJavaScriptRepresentation(out, surrogates[1]);
            return;
        }
        out.append("\\u").append(HEX_CHARS[codePoint >>> 12 & 0xF]).append(HEX_CHARS[codePoint >>> 8 & 0xF]).append(HEX_CHARS[codePoint >>> 4 & 0xF]).append(HEX_CHARS[codePoint & 0xF]);
    }
}

