/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.rhino.Node;

class AnonymousFunctionNamingCallback
extends NodeTraversal.AbstractPostOrderCallback {
    private final FunctionNamer namer;

    AnonymousFunctionNamingCallback(FunctionNamer namer) {
        this.namer = namer;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 105: {
                Node functionNameNode = n.getFirstChild();
                String functionName = functionNameNode.getString();
                if (functionName.length() != 0) break;
                if (parent.isAssign()) {
                    Node lhs = parent.getFirstChild();
                    String name = this.namer.getName(lhs);
                    this.namer.setFunctionName(name, n);
                    break;
                }
                if (!parent.isName()) break;
                String name = this.namer.getName(parent);
                this.namer.setFunctionName(name, n);
                break;
            }
            case 86: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                if (!rhs.isObjectLit()) break;
                this.nameObjectLiteralMethods(rhs, this.namer.getName(lhs));
            }
        }
    }

    private void nameObjectLiteralMethods(Node objectLiteral, String context) {
        Node keyNode = objectLiteral.getFirstChild();
        while (keyNode != null) {
            Node valueNode = keyNode.getFirstChild();
            if (keyNode.isStringKey()) {
                String name = this.namer.getCombinedName(context, this.namer.getName(keyNode));
                int type = valueNode.getType();
                if (type == 105) {
                    Node functionNameNode = valueNode.getFirstChild();
                    String functionName = functionNameNode.getString();
                    if (functionName.isEmpty()) {
                        this.namer.setFunctionName(name, valueNode);
                    }
                } else if (type == 64) {
                    this.nameObjectLiteralMethods(valueNode, name);
                }
            }
            keyNode = keyNode.getNext();
        }
    }

    static interface FunctionNamer {
        public String getName(Node var1);

        public void setFunctionName(String var1, Node var2);

        public String getCombinedName(String var1, String var2);
    }
}

