/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CheckLevel;
import com.google.gwt.thirdparty.javascript.jscomp.ControlFlowGraph;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.graph.GraphNode;
import com.google.gwt.thirdparty.javascript.jscomp.graph.GraphReachability;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.jstype.TernaryValue;

class CheckUnreachableCode
implements NodeTraversal.ScopedCallback {
    static final DiagnosticType UNREACHABLE_CODE = DiagnosticType.error("JSC_UNREACHABLE_CODE", "unreachable code");
    private final AbstractCompiler compiler;
    private final CheckLevel level;

    CheckUnreachableCode(AbstractCompiler compiler, CheckLevel level) {
        this.compiler = compiler;
        this.level = level;
    }

    @Override
    public void enterScope(NodeTraversal t) {
        this.initScope(t.getControlFlowGraph());
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        GraphNode gNode = t.getControlFlowGraph().getNode(n);
        if (gNode != null && gNode.getAnnotation() != GraphReachability.REACHABLE && n.getLineno() != -1 && !n.isEmpty() && !n.isBreak()) {
            this.compiler.report(t.makeError(n, this.level, UNREACHABLE_CODE, new String[0]));
            new GraphReachability(t.getControlFlowGraph()).recompute(n);
            return false;
        }
        return true;
    }

    private void initScope(ControlFlowGraph<Node> controlFlowGraph) {
        new GraphReachability<Node, ControlFlowGraph.Branch>(controlFlowGraph, new ReachablePredicate()).compute((Node)controlFlowGraph.getEntry().getValue());
    }

    @Override
    public void exitScope(NodeTraversal t) {
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
    }

    private final class ReachablePredicate
    implements Predicate<GraphReachability.EdgeTuple<Node, ControlFlowGraph.Branch>> {
        private ReachablePredicate() {
        }

        public boolean apply(GraphReachability.EdgeTuple<Node, ControlFlowGraph.Branch> input) {
            TernaryValue val;
            ControlFlowGraph.Branch branch = (ControlFlowGraph.Branch)((Object)input.edge);
            if (!branch.isConditional()) {
                return true;
            }
            Node predecessor = (Node)input.sourceNode;
            Node condition = NodeUtil.getConditionExpression(predecessor);
            if (condition != null && (val = NodeUtil.getImpureBooleanValue(condition)) != TernaryValue.UNKNOWN) {
                return val.toBoolean(true) == (branch == ControlFlowGraph.Branch.ON_TRUE);
            }
            return true;
        }
    }
}

