/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.javascript.rhino.Node;

abstract class CodeConsumer {
    boolean statementNeedsEnded = false;
    boolean statementStarted = false;
    boolean sawFunction = false;

    CodeConsumer() {
    }

    void startSourceMapping(Node node) {
    }

    void endSourceMapping(Node node) {
    }

    boolean continueProcessing() {
        return true;
    }

    abstract char getLastChar();

    void addIdentifier(String identifier) {
        this.add(identifier);
    }

    abstract void append(String var1);

    void appendBlockStart() {
        this.append("{");
    }

    void appendBlockEnd() {
        this.append("}");
    }

    void startNewLine() {
    }

    void maybeLineBreak() {
        this.maybeCutLine();
    }

    void maybeCutLine() {
    }

    void endLine() {
    }

    void notePreferredLineBreak() {
    }

    void beginBlock() {
        if (this.statementNeedsEnded) {
            this.append(";");
            this.maybeLineBreak();
        }
        this.appendBlockStart();
        this.endLine();
        this.statementNeedsEnded = false;
    }

    void endBlock() {
        this.endBlock(false);
    }

    void endBlock(boolean shouldEndLine) {
        this.appendBlockEnd();
        if (shouldEndLine) {
            this.endLine();
        }
        this.statementNeedsEnded = false;
    }

    void listSeparator() {
        this.add(",");
        this.maybeLineBreak();
    }

    void endStatement() {
        this.endStatement(false);
    }

    void endStatement(boolean needSemiColon) {
        if (needSemiColon) {
            this.append(";");
            this.maybeLineBreak();
            this.statementNeedsEnded = false;
        } else if (this.statementStarted) {
            this.statementNeedsEnded = true;
        }
    }

    void maybeEndStatement() {
        if (this.statementNeedsEnded) {
            this.append(";");
            this.maybeLineBreak();
            this.endLine();
            this.statementNeedsEnded = false;
        }
        this.statementStarted = true;
    }

    void endFunction() {
        this.endFunction(false);
    }

    void endFunction(boolean statementContext) {
        this.sawFunction = true;
        if (statementContext) {
            this.endLine();
        }
    }

    void beginCaseBody() {
        this.append(":");
    }

    void endCaseBody() {
    }

    void add(String newcode) {
        this.maybeEndStatement();
        if (newcode.length() == 0) {
            return;
        }
        char c = newcode.charAt(0);
        if ((CodeConsumer.isWordChar(c) || c == '\\') && CodeConsumer.isWordChar(this.getLastChar())) {
            this.append(" ");
        } else if (c == '/' && this.getLastChar() == '/') {
            this.append(" ");
        } else if (c == '\"' && CodeConsumer.isWordChar(this.getLastChar())) {
            this.maybeInsertSpace();
        }
        this.append(newcode);
    }

    void appendOp(String op, boolean binOp) {
        this.append(op);
    }

    void addOp(String op, boolean binOp) {
        this.maybeEndStatement();
        char first = op.charAt(0);
        char prev = this.getLastChar();
        if ((first == '+' || first == '-') && prev == first) {
            this.append(" ");
        } else if (Character.isLetter(first) && CodeConsumer.isWordChar(prev)) {
            this.append(" ");
        } else if (prev == '-' && first == '>') {
            this.append(" ");
        }
        this.appendOp(op, binOp);
        if (binOp) {
            this.maybeCutLine();
        }
    }

    void addNumber(double x) {
        char prev = this.getLastChar();
        boolean negativeZero = CodeConsumer.isNegativeZero(x);
        if ((x < 0.0 || negativeZero) && prev == '-') {
            this.add(" ");
        }
        if (negativeZero) {
            this.addConstant("-0");
        } else if ((double)((long)x) == x) {
            long value;
            long mantissa = value = (long)x;
            int exp = 0;
            if (Math.abs(x) >= 100.0) {
                while ((double)(mantissa / 10L) * Math.pow(10.0, exp + 1) == (double)value) {
                    mantissa /= 10L;
                    ++exp;
                }
            }
            if (exp > 2) {
                this.addConstant(String.valueOf(Long.toString(mantissa)) + "E" + Integer.toString(exp));
            } else {
                long valueAbs = Math.abs(value);
                if (Long.toHexString(valueAbs).length() + 2 < Long.toString(valueAbs).length()) {
                    this.addConstant(String.valueOf(value < 0L ? "-" : "") + "0x" + Long.toHexString(valueAbs));
                } else {
                    this.addConstant(Long.toString(value));
                }
            }
        } else {
            this.addConstant(String.valueOf(x).replace(".0E", "E"));
        }
    }

    void addConstant(String newcode) {
        this.add(newcode);
    }

    static boolean isNegativeZero(double x) {
        return x == 0.0 && Math.copySign(1.0, x) == -1.0;
    }

    static boolean isWordChar(char ch) {
        return ch == '_' || ch == '$' || Character.isLetterOrDigit(ch);
    }

    boolean shouldPreserveExtraBlocks() {
        return false;
    }

    void maybeInsertSpace() {
    }

    boolean breakAfterBlockFor(Node n, boolean statementContext) {
        return statementContext;
    }

    void endFile() {
    }
}

