/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.HotSwapCompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.List;

final class CombinedCompilerPass
implements HotSwapCompilerPass,
NodeTraversal.ScopedCallback {
    private final CallbackWrapper[] callbacks;
    private final AbstractCompiler compiler;

    CombinedCompilerPass(AbstractCompiler compiler, NodeTraversal.Callback ... callbacks) {
        this(compiler, Lists.newArrayList((Object[])callbacks));
    }

    CombinedCompilerPass(AbstractCompiler compiler, List<NodeTraversal.Callback> callbacks) {
        this.compiler = compiler;
        this.callbacks = new CallbackWrapper[callbacks.size()];
        int i = 0;
        while (i < callbacks.size()) {
            this.callbacks[i] = new CallbackWrapper(callbacks.get(i));
            ++i;
        }
    }

    static void traverse(AbstractCompiler compiler, Node root, List<NodeTraversal.Callback> callbacks) {
        if (callbacks.size() == 1) {
            NodeTraversal.traverse(compiler, root, callbacks.get(0));
        } else {
            new CombinedCompilerPass(compiler, callbacks).process(null, root);
        }
    }

    @Override
    public final void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        CallbackWrapper[] callbackWrapperArray = this.callbacks;
        int n2 = this.callbacks.length;
        int n3 = 0;
        while (n3 < n2) {
            CallbackWrapper callback = callbackWrapperArray[n3];
            callback.shouldTraverseIfActive(t, n, parent);
            ++n3;
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        CallbackWrapper[] callbackWrapperArray = this.callbacks;
        int n2 = this.callbacks.length;
        int n3 = 0;
        while (n3 < n2) {
            CallbackWrapper callback = callbackWrapperArray[n3];
            callback.visitOrMaybeActivate(t, n, parent);
            ++n3;
        }
    }

    @Override
    public void enterScope(NodeTraversal t) {
        CallbackWrapper[] callbackWrapperArray = this.callbacks;
        int n = this.callbacks.length;
        int n2 = 0;
        while (n2 < n) {
            CallbackWrapper callback = callbackWrapperArray[n2];
            callback.enterScopeIfActive(t);
            ++n2;
        }
    }

    @Override
    public void exitScope(NodeTraversal t) {
        CallbackWrapper[] callbackWrapperArray = this.callbacks;
        int n = this.callbacks.length;
        int n2 = 0;
        while (n2 < n) {
            CallbackWrapper callback = callbackWrapperArray[n2];
            callback.exitScopeIfActive(t);
            ++n2;
        }
    }

    private static class CallbackWrapper {
        private final NodeTraversal.Callback callback;
        private final NodeTraversal.ScopedCallback scopedCallback;
        private Node waiting = null;

        private CallbackWrapper(NodeTraversal.Callback callback) {
            this.callback = callback;
            this.scopedCallback = callback instanceof NodeTraversal.ScopedCallback ? (NodeTraversal.ScopedCallback)callback : null;
        }

        void visitOrMaybeActivate(NodeTraversal t, Node n, Node parent) {
            if (this.isActive()) {
                this.callback.visit(t, n, parent);
            } else if (this.waiting == n) {
                this.waiting = null;
            }
        }

        void shouldTraverseIfActive(NodeTraversal t, Node n, Node parent) {
            if (this.isActive() && !this.callback.shouldTraverse(t, n, parent)) {
                this.waiting = n;
            }
        }

        void enterScopeIfActive(NodeTraversal t) {
            if (this.isActive() && this.scopedCallback != null) {
                this.scopedCallback.enterScope(t);
            }
        }

        void exitScopeIfActive(NodeTraversal t) {
            if (this.isActive() && this.scopedCallback != null) {
                this.scopedCallback.exitScope(t);
            }
        }

        boolean isActive() {
            return this.waiting == null;
        }
    }
}

