/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.CoverageInstrumentationCallback;
import com.google.gwt.thirdparty.javascript.jscomp.FileInstrumentationData;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Map;

class CoverageInstrumentationPass
implements CompilerPass {
    final AbstractCompiler compiler;
    private Map<String, FileInstrumentationData> instrumentationData;
    private CoverageReach reach;
    private static final String JS_INSTRUMENTATION_EXTERNS_CODE = "var JSCompiler_lcov_executedLines;\nvar JSCompiler_lcov_instrumentedLines;\nvar JSCompiler_lcov_fileNames;\n";

    public CoverageInstrumentationPass(AbstractCompiler compiler, CoverageReach reach) {
        this.compiler = compiler;
        this.reach = reach;
        this.instrumentationData = Maps.newLinkedHashMap();
    }

    private void addHeaderCode(Node script) {
        script.addChildToFront(this.createConditionalVarDecl("JSCompiler_lcov_executedLines"));
        script.addChildToFront(this.createConditionalVarDecl("JSCompiler_lcov_instrumentedLines"));
        script.addChildToFront(this.createConditionalVarDecl("JSCompiler_lcov_fileNames"));
    }

    private Node getInstrumentationExternsNode() {
        Node externsNode = this.compiler.parseSyntheticCode("ExternsCodeForCoverageInstrumentation", JS_INSTRUMENTATION_EXTERNS_CODE);
        return externsNode;
    }

    @Override
    public void process(Node externsNode, Node rootNode) {
        if (rootNode.hasChildren()) {
            NodeTraversal.traverse(this.compiler, rootNode, new CoverageInstrumentationCallback(this.instrumentationData, this.reach));
            Node firstScript = rootNode.getFirstChild();
            Preconditions.checkState((boolean)firstScript.isScript());
            this.addHeaderCode(firstScript);
        }
        externsNode.addChildToBack(this.getInstrumentationExternsNode());
    }

    private Node createConditionalVarDecl(String name) {
        Node var = IR.var(IR.name(name), IR.or(IR.name(name), IR.arraylit(new Node[0])));
        var.addSuppression("duplicate");
        return var;
    }

    public static enum CoverageReach {
        ALL,
        CONDITIONAL;

    }
}

