/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CodingConvention;
import com.google.gwt.thirdparty.javascript.jscomp.DefinitionSite;
import com.google.gwt.thirdparty.javascript.jscomp.DefinitionsRemover;
import com.google.gwt.thirdparty.javascript.jscomp.JSModule;
import com.google.gwt.thirdparty.javascript.jscomp.JSModuleGraph;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.OptimizeCalls;
import com.google.gwt.thirdparty.javascript.jscomp.SimpleDefinitionFinder;
import com.google.gwt.thirdparty.javascript.jscomp.SpecializationAwareCompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.SpecializeModule;
import com.google.gwt.thirdparty.javascript.jscomp.UseSite;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.jstype.FunctionType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeNative;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSTypeRegistry;
import com.google.gwt.thirdparty.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Collection;

class DevirtualizePrototypeMethods
implements OptimizeCalls.CallGraphCompilerPass,
SpecializationAwareCompilerPass {
    private final AbstractCompiler compiler;
    private SpecializeModule.SpecializationState specializationState;

    DevirtualizePrototypeMethods(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void enableSpecialization(SpecializeModule.SpecializationState state) {
        this.specializationState = state;
    }

    @Override
    public void process(Node externs, Node root) {
        SimpleDefinitionFinder defFinder = new SimpleDefinitionFinder(this.compiler);
        defFinder.process(externs, root);
        this.process(externs, root, defFinder);
    }

    @Override
    public void process(Node externs, Node root, SimpleDefinitionFinder definitions) {
        for (DefinitionSite defSite : definitions.getDefinitionSites()) {
            this.rewriteDefinitionIfEligible(defSite, definitions);
        }
    }

    private static boolean isCall(UseSite site) {
        Node node = site.node;
        Node parent = node.getParent();
        return parent.getFirstChild() == node && parent.isCall();
    }

    private static boolean isPrototypeMethodDefinition(Node node) {
        Node parent = node.getParent();
        if (parent == null) {
            return false;
        }
        Node gramp = parent.getParent();
        if (gramp == null) {
            return false;
        }
        if (node.isGetProp()) {
            if (parent.getFirstChild() != node) {
                return false;
            }
            if (!NodeUtil.isExprAssign(gramp)) {
                return false;
            }
            Node functionNode = parent.getLastChild();
            if (functionNode == null || !functionNode.isFunction()) {
                return false;
            }
            Node nameNode = node.getFirstChild();
            return nameNode.isGetProp() && nameNode.getLastChild().getString().equals("prototype");
        }
        if (node.isStringKey()) {
            Preconditions.checkState((boolean)parent.isObjectLit());
            if (!gramp.isAssign()) {
                return false;
            }
            if (gramp.getLastChild() != parent) {
                return false;
            }
            Node greatGramp = gramp.getParent();
            if (greatGramp == null || !greatGramp.isExprResult()) {
                return false;
            }
            Node functionNode = node.getFirstChild();
            if (functionNode == null || !functionNode.isFunction()) {
                return false;
            }
            Node target = gramp.getFirstChild();
            return target.isGetProp() && target.getLastChild().getString().equals("prototype");
        }
        return false;
    }

    private String getMethodName(Node node) {
        if (node.isGetProp()) {
            return node.getLastChild().getString();
        }
        if (node.isStringKey()) {
            return node.getString();
        }
        throw new IllegalStateException("unexpected");
    }

    private String getRewrittenMethodName(String originalMethodName) {
        return "JSCompiler_StaticMethods_" + originalMethodName;
    }

    private void rewriteDefinitionIfEligible(DefinitionSite defSite, SimpleDefinitionFinder defFinder) {
        if (defSite.inExterns || !defSite.inGlobalScope || !this.isEligibleDefinition(defFinder, defSite)) {
            return;
        }
        Node node = defSite.node;
        if (!DevirtualizePrototypeMethods.isPrototypeMethodDefinition(node)) {
            return;
        }
        Node ancestor = node.getParent();
        while (ancestor != null) {
            if (NodeUtil.isControlStructure(ancestor)) {
                return;
            }
            ancestor = ancestor.getParent();
        }
        String newMethodName = this.getRewrittenMethodName(this.getMethodName(node));
        this.rewriteDefinition(node, newMethodName);
        this.rewriteCallSites(defFinder, defSite.definition, newMethodName);
    }

    private boolean isEligibleDefinition(SimpleDefinitionFinder defFinder, DefinitionSite definitionSite) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        JSModule definitionModule = definitionSite.module;
        Node rValue = definition.getRValue();
        if (rValue == null || !rValue.isFunction() || NodeUtil.isVarArgsFunction(rValue)) {
            return false;
        }
        Node lValue = definition.getLValue();
        if (lValue == null || !lValue.isGetProp()) {
            return false;
        }
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        if (codingConvention.isExported(lValue.getLastChild().getString())) {
            return false;
        }
        Collection<UseSite> useSites = defFinder.getUseSites(definition);
        if (useSites.isEmpty()) {
            return false;
        }
        JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
        for (UseSite site : useSites) {
            if (!DevirtualizePrototypeMethods.isCall(site)) {
                return false;
            }
            Node nameNode = site.node;
            if (this.specializationState != null && !this.specializationState.canFixupSpecializedFunctionContainingNode(nameNode)) {
                return false;
            }
            Collection<DefinitionsRemover.Definition> singleSiteDefinitions = defFinder.getDefinitionsReferencedAt(nameNode);
            if (singleSiteDefinitions.size() > 1) {
                return false;
            }
            Preconditions.checkState((!singleSiteDefinitions.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)singleSiteDefinitions.contains(definition));
            JSModule callModule = site.module;
            if (definitionModule == callModule || callModule != null && moduleGraph.dependsOn(callModule, definitionModule)) continue;
            return false;
        }
        return true;
    }

    private void rewriteCallSites(SimpleDefinitionFinder defFinder, DefinitionsRemover.Definition definition, String newMethodName) {
        Collection<UseSite> useSites = defFinder.getUseSites(definition);
        for (UseSite site : useSites) {
            Node node = site.node;
            Node parent = node.getParent();
            Node objectNode = node.getFirstChild();
            node.removeChild(objectNode);
            parent.replaceChild(node, objectNode);
            parent.addChildToFront(IR.name(newMethodName).srcref(node));
            Preconditions.checkState((boolean)parent.isCall());
            parent.putBooleanProp(50, true);
            this.compiler.reportCodeChange();
            if (this.specializationState == null) continue;
            this.specializationState.reportSpecializedFunctionContainingNode(parent);
        }
    }

    private void rewriteDefinition(Node node, String newMethodName) {
        Node functionNode;
        boolean isObjLitDefKey = node.isStringKey();
        Node parent = node.getParent();
        Node refNode = isObjLitDefKey ? node : parent.getFirstChild();
        Node newNameNode = IR.name(newMethodName).copyInformationFrom(refNode);
        Node newVarNode = IR.var(newNameNode).copyInformationFrom(refNode);
        if (!isObjLitDefKey) {
            Preconditions.checkState((boolean)parent.isAssign());
            functionNode = parent.getLastChild();
            Node expr = parent.getParent();
            Node block = expr.getParent();
            parent.removeChild(functionNode);
            newNameNode.addChildToFront(functionNode);
            block.replaceChild(expr, newVarNode);
            if (this.specializationState != null) {
                this.specializationState.reportRemovedFunction(functionNode, block);
            }
        } else {
            Preconditions.checkState((boolean)parent.isObjectLit());
            functionNode = node.getFirstChild();
            Node assign = parent.getParent();
            Node expr = assign.getParent();
            Node block = expr.getParent();
            node.removeChild(functionNode);
            parent.removeChild(node);
            newNameNode.addChildToFront(functionNode);
            block.addChildAfter(newVarNode, expr);
            if (this.specializationState != null) {
                this.specializationState.reportRemovedFunction(functionNode, block);
            }
        }
        String self = String.valueOf(newMethodName) + "$self";
        Node argList = functionNode.getFirstChild().getNext();
        argList.addChildToFront(IR.name(self).copyInformationFrom(functionNode));
        Node body = functionNode.getLastChild();
        this.replaceReferencesToThis(body, self);
        this.fixFunctionType(functionNode);
        this.compiler.reportCodeChange();
    }

    private void fixFunctionType(Node functionNode) {
        FunctionType type = JSType.toMaybeFunctionType(functionNode.getJSType());
        if (type != null) {
            JSTypeRegistry typeRegistry = this.compiler.getTypeRegistry();
            ArrayList parameterTypes = Lists.newArrayList();
            parameterTypes.add(type.getTypeOfThis());
            for (Node param : type.getParameters()) {
                parameterTypes.add(param.getJSType());
            }
            ObjectType thisType = typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
            JSType returnType = type.getReturnType();
            JSType newType = typeRegistry.createFunctionType(thisType, returnType, parameterTypes);
            functionNode.setJSType(newType);
        }
    }

    private void replaceReferencesToThis(Node node, String name) {
        if (node.isFunction()) {
            return;
        }
        for (Node child : node.children()) {
            if (child.isThis()) {
                Node newName = IR.name(name);
                newName.setJSType(child.getJSType());
                node.replaceChild(child, newName);
                continue;
            }
            this.replaceReferencesToThis(child, name);
        }
    }
}

