/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.javascript.jscomp.ControlFlowGraph;
import com.google.gwt.thirdparty.javascript.jscomp.graph.DiGraph;
import com.google.gwt.thirdparty.javascript.jscomp.graph.GraphvizGraph;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.Token;
import com.google.gwt.thirdparty.javascript.rhino.jstype.JSType;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class DotFormatter {
    private static final String INDENT = "  ";
    private static final String ARROW = " -> ";
    private static final String LINE = " -- ";
    private final HashMap<Node, Integer> assignments = new HashMap();
    private int keyCount = 0;
    private final Appendable builder;
    private final ControlFlowGraph<Node> cfg;
    private final boolean printAnnotations;

    private DotFormatter() {
        this.builder = new StringBuilder();
        this.cfg = null;
        this.printAnnotations = false;
    }

    private DotFormatter(Node n, ControlFlowGraph<Node> cfg, Appendable builder, boolean printAnnotations) throws IOException {
        this.cfg = cfg;
        this.builder = builder;
        this.printAnnotations = printAnnotations;
        this.formatPreamble();
        this.traverseNodes(n);
        this.formatConclusion();
    }

    public static String toDot(Node n) throws IOException {
        return DotFormatter.toDot(n, null);
    }

    static String toDot(Node n, ControlFlowGraph<Node> inCFG, boolean printAnnotations) throws IOException {
        StringBuilder builder = new StringBuilder();
        new DotFormatter(n, inCFG, builder, printAnnotations);
        return builder.toString();
    }

    static String toDot(Node n, ControlFlowGraph<Node> inCFG) throws IOException {
        StringBuilder builder = new StringBuilder();
        new DotFormatter(n, inCFG, builder, false);
        return builder.toString();
    }

    static void appendDot(Node n, ControlFlowGraph<Node> inCFG, Appendable builder) throws IOException {
        new DotFormatter(n, inCFG, builder, false);
    }

    static DotFormatter newInstanceForTesting() {
        return new DotFormatter();
    }

    private void traverseNodes(Node parent) throws IOException {
        int keyParent = this.key(parent);
        Node child = parent.getFirstChild();
        while (child != null) {
            int keyChild = this.key(child);
            this.builder.append(INDENT);
            this.builder.append(this.formatNodeName(keyParent));
            this.builder.append(ARROW);
            this.builder.append(this.formatNodeName(keyChild));
            this.builder.append(" [weight=1];\n");
            this.traverseNodes(child);
            child = child.getNext();
        }
        if (this.cfg != null && this.cfg.hasNode(parent)) {
            List outEdges = this.cfg.getOutEdges(parent);
            Object[] edgeList = new String[outEdges.size()];
            int i = 0;
            while (i < edgeList.length) {
                DiGraph.DiGraphEdge edge = outEdges.get(i);
                DiGraph.DiGraphNode succ = edge.getDestination();
                String toNode = null;
                if (succ == this.cfg.getImplicitReturn()) {
                    toNode = "RETURN";
                } else {
                    int keySucc = this.key((Node)succ.getValue());
                    toNode = this.formatNodeName(keySucc);
                }
                edgeList[i] = String.valueOf(this.formatNodeName(keyParent)) + ARROW + toNode + " [label=\"" + ((ControlFlowGraph.Branch)((Object)edge.getValue())).toString() + "\", " + "fontcolor=\"red\", " + "weight=0.01, color=\"red\"];\n";
                ++i;
            }
            Arrays.sort(edgeList);
            i = 0;
            while (i < edgeList.length) {
                this.builder.append(INDENT);
                this.builder.append((CharSequence)edgeList[i]);
                ++i;
            }
        }
    }

    int key(Node n) throws IOException {
        Integer key = this.assignments.get(n);
        if (key == null) {
            Object annotation;
            key = this.keyCount++;
            this.assignments.put(n, key);
            this.builder.append(INDENT);
            this.builder.append(this.formatNodeName(key));
            this.builder.append(" [label=\"");
            this.builder.append(this.name(n));
            JSType type = n.getJSType();
            if (type != null) {
                this.builder.append(" : ");
                this.builder.append(type.toString());
            }
            if (this.printAnnotations && this.cfg != null && this.cfg.hasNode(n) && (annotation = this.cfg.getNode(n).getAnnotation()) != null) {
                this.builder.append("\\n");
                this.builder.append(annotation.toString());
            }
            this.builder.append("\"");
            if (n.getJSDocInfo() != null) {
                this.builder.append(" color=\"green\"");
            }
            this.builder.append("];\n");
        }
        return key;
    }

    private String name(Node n) {
        int type = n.getType();
        switch (type) {
            case 122: {
                return "VOID";
            }
        }
        return Token.name(type);
    }

    private String formatNodeName(Integer key) {
        return "node" + key;
    }

    private void formatPreamble() throws IOException {
        this.builder.append("digraph AST {\n");
        this.builder.append(INDENT);
        this.builder.append("node [color=lightblue2, style=filled];\n");
    }

    private void formatConclusion() throws IOException {
        this.builder.append("}\n");
    }

    public static String toDot(GraphvizGraph graph) {
        StringBuilder builder = new StringBuilder();
        builder.append(graph.isDirected() ? "digraph" : "graph");
        builder.append(INDENT);
        builder.append(graph.getName());
        builder.append(" {\n");
        builder.append(INDENT);
        builder.append("node [color=lightblue2, style=filled];\n");
        String edgeSymbol = graph.isDirected() ? ARROW : LINE;
        List<GraphvizGraph.GraphvizNode> nodes = graph.getGraphvizNodes();
        Object[] nodeNames = new String[nodes.size()];
        int i = 0;
        while (i < nodeNames.length) {
            GraphvizGraph.GraphvizNode gNode = nodes.get(i);
            nodeNames[i] = String.valueOf(gNode.getId()) + " [label=\"" + gNode.getLabel() + "\" color=\"" + gNode.getColor() + "\"]";
            ++i;
        }
        Arrays.sort(nodeNames);
        Object[] objectArray = nodeNames;
        int n = nodeNames.length;
        int gNode = 0;
        while (gNode < n) {
            Object nodeName = objectArray[gNode];
            builder.append(INDENT);
            builder.append((String)nodeName);
            builder.append(";\n");
            ++gNode;
        }
        List<GraphvizGraph.GraphvizEdge> edges = graph.getGraphvizEdges();
        Object[] edgeNames = new String[edges.size()];
        int i2 = 0;
        while (i2 < edgeNames.length) {
            GraphvizGraph.GraphvizEdge edge = edges.get(i2);
            edgeNames[i2] = String.valueOf(edge.getNode1Id()) + edgeSymbol + edge.getNode2Id();
            ++i2;
        }
        Arrays.sort(edgeNames);
        Object[] objectArray2 = edgeNames;
        int n2 = edgeNames.length;
        int n3 = 0;
        while (n3 < n2) {
            Object edgeName = objectArray2[n3];
            builder.append(INDENT);
            builder.append((String)edgeName);
            builder.append(";\n");
            ++n3;
        }
        builder.append("}\n");
        return builder.toString();
    }
}

