/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.Node;

class ExploitAssigns
extends AbstractPeepholeOptimization {
    ExploitAssigns() {
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        Node child = subtree.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (NodeUtil.isExprAssign(child)) {
                this.collapseAssign(child.getFirstChild(), child, subtree);
            }
            child = next;
        }
        return subtree;
    }

    private void collapseAssign(Node assign, Node expr, Node exprParent) {
        Node leftValue = assign.getFirstChild();
        Node rightValue = leftValue.getNext();
        if (ExploitAssigns.isCollapsibleValue(leftValue, true) && this.collapseAssignEqualTo(expr, exprParent, leftValue)) {
            this.reportCodeChange();
        } else if (ExploitAssigns.isCollapsibleValue(rightValue, false) && this.collapseAssignEqualTo(expr, exprParent, rightValue)) {
            this.reportCodeChange();
        } else if (rightValue.isAssign()) {
            this.collapseAssign(rightValue, expr, exprParent);
        }
    }

    private static boolean isCollapsibleValue(Node value, boolean isLValue) {
        switch (value.getType()) {
            case 33: {
                return !isLValue || value.getFirstChild().isThis();
            }
            case 38: {
                return true;
            }
        }
        return NodeUtil.isImmutableValue(value);
    }

    private boolean collapseAssignEqualTo(Node expr, Node exprParent, Node value) {
        Node assign = expr.getFirstChild();
        Node parent = exprParent;
        Node next = expr.getNext();
        while (next != null) {
            switch (next.getType()) {
                case 4: 
                case 98: 
                case 100: 
                case 101: 
                case 108: 
                case 130: {
                    parent = next;
                    next = next.getFirstChild();
                    break;
                }
                case 118: {
                    if (next.getFirstChild().hasChildren()) {
                        parent = next.getFirstChild();
                        next = parent.getFirstChild();
                        break;
                    }
                    return false;
                }
                case 33: 
                case 38: {
                    if (next.isQualifiedName()) {
                        String nextName = next.getQualifiedName();
                        if (value.isQualifiedName() && nextName.equals(value.getQualifiedName())) {
                            if (!this.isSafeReplacement(next, assign)) {
                                return false;
                            }
                            exprParent.removeChild(expr);
                            expr.removeChild(assign);
                            parent.replaceChild(next, assign);
                            return true;
                        }
                    }
                    return false;
                }
                case 86: {
                    Node leftSide = next.getFirstChild();
                    if (leftSide.isName() || leftSide.isGetProp() && leftSide.getFirstChild().isThis()) {
                        parent = next;
                        next = leftSide.getNext();
                        break;
                    }
                    return false;
                }
                default: {
                    if (NodeUtil.isImmutableValue(next) && next.isEquivalentTo(value)) {
                        exprParent.removeChild(expr);
                        expr.removeChild(assign);
                        parent.replaceChild(next, assign);
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private boolean isSafeReplacement(Node node, Node replacement) {
        if (node.isName()) {
            return true;
        }
        Preconditions.checkArgument((boolean)node.isGetProp());
        while (node.isGetProp()) {
            node = node.getFirstChild();
        }
        return !node.isName() || !this.isNameAssignedTo(node.getString(), replacement);
    }

    private boolean isNameAssignedTo(String name, Node node) {
        Node parent;
        Node c = node.getFirstChild();
        while (c != null) {
            if (this.isNameAssignedTo(name, c)) {
                return true;
            }
            c = c.getNext();
        }
        return node.isName() && (parent = node.getParent()).isAssign() && parent.getFirstChild() == node && name.equals(node.getString());
    }
}

