/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.HashBasedTable;
import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.RhinoErrorReporter;
import com.google.gwt.thirdparty.javascript.jscomp.TypeCheck;
import com.google.gwt.thirdparty.javascript.jscomp.TypeValidator;
import com.google.gwt.thirdparty.javascript.jscomp.VarCheck;
import com.google.gwt.thirdparty.javascript.jscomp.VariableReferenceCheck;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.JSType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.JSTypeCreatorFromJSDoc;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.NominalType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.ObjectType;
import com.google.gwt.thirdparty.javascript.jscomp.newtypes.TypeUtils;
import com.google.gwt.thirdparty.javascript.rhino.JSDocInfo;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GlobalTypeInfo
implements CompilerPass {
    static final DiagnosticType DUPLICATE_JSDOC = DiagnosticType.warning("JSC_DUPLICATE_JSDOC", "Found two JsDoc comments for variable: {0}.\n");
    static final DiagnosticType DUPLICATE_PROPERTY_JSDOC = DiagnosticType.warning("JSC_DUPLICATE_PROPERTY_JSDOC", "Found two JsDoc comments for property {0} of type {1}.\n");
    static final DiagnosticType INVALID_PROP_OVERRIDE = DiagnosticType.warning("JSC_INVALID_PROP_OVERRIDE", "Invalid redeclaration of property {0}.\ninherited type  : {1}\noverriding type : {2}\n");
    static final DiagnosticType EXTENDS_NOT_ON_CTOR_OR_INTERF = DiagnosticType.warning("JSC_EXTENDS_NOT_ON_CTOR_OR_INTERF", "@extends used without @constructor or @interface for {0}.\n");
    static final DiagnosticType EXTENDS_NON_OBJECT = DiagnosticType.warning("JSC_EXTENDS_NON_OBJECT", "{0} extends non-object type {1}.\n");
    static final DiagnosticType CTOR_IN_DIFFERENT_SCOPE = DiagnosticType.warning("JSC_CTOR_IN_DIFFERENT_SCOPE", "Modifying the prototype is only allowed if the constructor is in the same scope\n");
    static final DiagnosticType UNRECOGNIZED_TYPE_NAME = DiagnosticType.warning("JSC_UNRECOGNIZED_TYPE_NAME", "Type annotation references non-existent type {0}.");
    static final DiagnosticType INTERFACE_WITH_A_BODY = DiagnosticType.warning("JSC_INTERFACE_WITH_A_BODY", "Interface definitions should have an empty body.");
    private final Deque<Scope> scopes = Lists.newLinkedList();
    private Scope globalScope;
    private final Deque<Scope> scopeWorkset = Lists.newLinkedList();
    private final Set<JSError> warnings = Sets.newHashSet();
    private final JSTypeCreatorFromJSDoc typeParser = new JSTypeCreatorFromJSDoc();
    private final AbstractCompiler compiler;
    private final Map<Node, String> anonFunNames = Maps.newHashMap();
    private int funCounter = 1;
    private Map<Node, NominalType> nominaltypesByNode = Maps.newHashMap();
    private HashBasedTable<NominalType, String, PropertyDef> propertyDefs = HashBasedTable.create();

    GlobalTypeInfo(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    Collection<Scope> getScopes() {
        return this.scopes;
    }

    Scope getGlobalScope() {
        return this.globalScope;
    }

    Collection<JSError> getWarnings() {
        return this.warnings;
    }

    String getFunInternalName(Node n) {
        Preconditions.checkState((boolean)n.isFunction());
        String nonAnonFnName = NodeUtil.getFunctionName(n);
        if (nonAnonFnName != null && TypeUtils.isIdentifier(nonAnonFnName)) {
            return nonAnonFnName;
        }
        return this.anonFunNames.get(n);
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkArgument((boolean)externs.isSyntheticBlock());
        Preconditions.checkArgument((boolean)root.isSyntheticBlock());
        this.globalScope = new Scope(root, null, new ArrayList(), null);
        this.scopes.addFirst(this.globalScope);
        CollectNamedTypes rootCnt = new CollectNamedTypes(this.globalScope);
        new NodeTraversal(this.compiler, rootCnt).traverse(externs);
        new NodeTraversal(this.compiler, rootCnt).traverse(root);
        ProcessScope rootPs = new ProcessScope(this.globalScope);
        new NodeTraversal(this.compiler, rootPs).traverse(externs);
        new NodeTraversal(this.compiler, rootPs).traverse(root);
        rootPs.finishProcessingScope();
        while (!this.scopeWorkset.isEmpty()) {
            Scope s = this.scopeWorkset.removeFirst();
            Node scopeBody = s.getBody();
            new NodeTraversal(this.compiler, new CollectNamedTypes(s)).traverse(scopeBody);
            ProcessScope ps = new ProcessScope(s);
            new NodeTraversal(this.compiler, ps).traverse(scopeBody);
            ps.finishProcessingScope();
        }
        this.reportInheritanceErrors();
        this.nominaltypesByNode = null;
        this.propertyDefs = null;
        for (Scope s : this.scopes) {
            s.finalizeScope();
        }
        for (String warningText : this.typeParser.getWarnings()) {
            this.warnings.add(JSError.make(root, RhinoErrorReporter.BAD_JSDOC_ANNOTATION, warningText));
        }
        this.compiler.setSymbolTable(this);
    }

    private void reportInheritanceErrors() {
        LinkedList workset = Lists.newLinkedList(this.nominaltypesByNode.keySet());
        block0: while (!workset.isEmpty()) {
            Node funNode = (Node)workset.removeFirst();
            NominalType nominalType = this.nominaltypesByNode.get(funNode);
            NominalType superClass = nominalType.getSuperClass();
            if (superClass != null && !superClass.isFinalized()) {
                workset.addLast(funNode);
                continue;
            }
            for (NominalType superInterf : nominalType.getInterfaces()) {
                if (superInterf.isFinalized()) continue;
                workset.addLast(funNode);
                continue block0;
            }
            if (superClass != null) {
                for (String pname : superClass.getAllPropsOfClass()) {
                    JSType localPropType;
                    JSType inheritedPropType;
                    PropertyDef propDef = (PropertyDef)this.propertyDefs.get((Object)nominalType, (Object)pname);
                    PropertyDef inheritedPropDef = (PropertyDef)this.propertyDefs.get((Object)superClass, (Object)pname);
                    if (inheritedPropDef != null && inheritedPropDef.methodScope != null) {
                        DeclaredFunctionType propDeclType;
                        if (propDef == null || propDef.methodScope == null) {
                            propDeclType = inheritedPropDef.methodScope.getDeclaredType();
                        } else {
                            DeclaredFunctionType funDeclType = propDef.methodScope.getDeclaredType();
                            DeclaredFunctionType inheritedFunDeclType = inheritedPropDef.methodScope.getDeclaredType();
                            propDeclType = funDeclType.withTypeInfoFromSuper(inheritedFunDeclType);
                            propDef.methodScope.setDeclaredType(propDeclType);
                        }
                        nominalType.addProtoProperty(pname, JSType.fromFunctionType(propDeclType.toFunctionType()));
                    }
                    if ((inheritedPropType = superClass.getPropDeclaredType(pname)) == null || (localPropType = nominalType.getPropDeclaredType(pname)).isSubtypeOf(inheritedPropType)) continue;
                    this.warnings.add(JSError.make(((PropertyDef)this.propertyDefs.get((Object)nominalType, (Object)pname)).defSite, INVALID_PROP_OVERRIDE, pname, inheritedPropType.toString(), localPropType.toString()));
                }
            }
            for (NominalType superInterf : nominalType.getInterfaces()) {
                for (String pname : superInterf.getAllPropsOfInterface()) {
                    PropertyDef inheritedPropDef = (PropertyDef)this.propertyDefs.get((Object)superInterf, (Object)pname);
                    JSType inheritedPropType = superInterf.getPropDeclaredType(pname);
                    if (!nominalType.mayHaveProp(pname)) {
                        this.warnings.add(JSError.make(inheritedPropDef.defSite, TypeValidator.INTERFACE_METHOD_NOT_IMPLEMENTED, pname, superInterf.toString(), nominalType.toString()));
                        continue;
                    }
                    PropertyDef propDef = (PropertyDef)this.propertyDefs.get((Object)nominalType, (Object)pname);
                    JSType localPropType = nominalType.getPropDeclaredType(pname);
                    if (localPropType != null && !localPropType.isSubtypeOf(inheritedPropType)) {
                        this.warnings.add(JSError.make(propDef.defSite, INVALID_PROP_OVERRIDE, pname, inheritedPropType.toString(), localPropType.toString()));
                        continue;
                    }
                    if (!nominalType.isClass()) continue;
                    if (localPropType == null) {
                        nominalType.addProtoProperty(pname, inheritedPropType);
                        continue;
                    }
                    if (propDef.methodScope == null) continue;
                    DeclaredFunctionType propDeclType = propDef.methodScope.getDeclaredType();
                    propDeclType = propDeclType.withTypeInfoFromSuper(inheritedPropDef.methodScope.getDeclaredType());
                    propDef.methodScope.setDeclaredType(propDeclType);
                    nominalType.addProtoProperty(pname, JSType.fromFunctionType(propDeclType.toFunctionType()));
                }
            }
            nominalType.finalizeNominalType();
        }
    }

    private JSType getTypeDeclarationFromJsdoc(Node n, Scope s) {
        return this.typeParser.getNodeTypeDeclaration(n.getJSDocInfo(), s);
    }

    private class CollectNamedTypes
    extends NodeTraversal.AbstractShallowCallback {
        private final Scope currentScope;

        CollectNamedTypes(Scope s) {
            this.currentScope = s;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isFunction()) {
                this.initFnScope(n, this.currentScope);
            }
        }

        private void initFnScope(Node fn, Scope parentScope) {
            JSDocInfo fnDoc;
            String qname = NodeUtil.getFunctionName(fn);
            if (qname == null || !TypeUtils.isIdentifier(qname)) {
                GlobalTypeInfo.this.anonFunNames.put(fn, "%anon_fun" + GlobalTypeInfo.this.funCounter);
                GlobalTypeInfo globalTypeInfo = GlobalTypeInfo.this;
                globalTypeInfo.funCounter = globalTypeInfo.funCounter + 1;
            }
            if ((fnDoc = NodeUtil.getFunctionJSDocInfo(fn)) != null && (fnDoc.isConstructor() || fnDoc.isInterface())) {
                NominalType klass = fnDoc.isInterface() ? NominalType.makeInterface(qname) : NominalType.makeClass(qname);
                GlobalTypeInfo.this.nominaltypesByNode.put(fn, klass);
                parentScope.addClassType(qname, klass);
            }
        }
    }

    private class ProcessScope
    extends NodeTraversal.AbstractShallowCallback {
        private final Scope currentScope;
        private final Multimap<String, Node> undeclaredVars;

        ProcessScope(Scope currentScope) {
            this.currentScope = currentScope;
            this.undeclaredVars = HashMultimap.create();
        }

        void finishProcessingScope() {
            for (Node nameNode : this.undeclaredVars.values()) {
                GlobalTypeInfo.this.warnings.add(JSError.make(nameNode, VarCheck.UNDEFINED_VAR_ERROR, nameNode.getQualifiedName()));
            }
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getType()) {
                case 105: {
                    Node grandparent = parent.getParent();
                    if (grandparent != null && (grandparent.isVar() || NodeUtil.isPrototypePropertyDeclaration(grandparent))) break;
                    this.visitFunctionDef(n);
                    break;
                }
                case 38: {
                    String name = n.getQualifiedName();
                    if (name == null || "undefined".equals(name) || parent.isFunction()) {
                        return;
                    }
                    if (parent.isVar() || parent.isCatch()) {
                        if (this.currentScope.isDefinedLocally(name)) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(n, VariableReferenceCheck.REDECLARED_VARIABLE, name));
                            break;
                        }
                        for (Node useBeforeDeclNode : this.undeclaredVars.get((Object)name)) {
                            GlobalTypeInfo.this.warnings.add(JSError.make(useBeforeDeclNode, VariableReferenceCheck.UNDECLARED_REFERENCE, name));
                        }
                        this.undeclaredVars.removeAll((Object)name);
                        Node initializer = n.getFirstChild();
                        if (initializer != null && initializer.isFunction()) {
                            this.visitFunctionDef(initializer);
                            break;
                        }
                        if (initializer != null && NodeUtil.isNamespaceDecl((Node)n)) {
                            this.currentScope.addNamespace(name);
                            break;
                        }
                        this.currentScope.addLocal(name, parent.isVar() ? this.getVarTypeFromAnnotation(n) : JSType.UNKNOWN);
                        break;
                    }
                    if (this.currentScope.isOuterVarEarly(name)) {
                        this.currentScope.addOuterVar(name);
                        break;
                    }
                    if (this.currentScope.isDefinedLocally(name)) break;
                    this.undeclaredVars.put((Object)name, (Object)n);
                    break;
                }
                case 33: {
                    if (!NodeUtil.isPrototypeProperty(n) || !parent.isExprResult()) break;
                    this.visitPrototypePropertyDeclaration(parent);
                    break;
                }
                case 86: {
                    Node lvalue = n.getFirstChild();
                    if (!lvalue.isGetProp()) {
                        return;
                    }
                    if (lvalue.getFirstChild().isThis() && (this.currentScope.isConstructor() || this.currentScope.isPrototypeMethod())) {
                        this.visitClassPropertyDeclaration(lvalue);
                        return;
                    }
                    if (NodeUtil.isPrototypePropertyDeclaration(parent)) {
                        this.visitPrototypePropertyDeclaration(parent);
                        return;
                    }
                    String receiverObjName = lvalue.getFirstChild().getQualifiedName();
                    if (this.currentScope.isLocalFunDef(receiverObjName) && this.currentScope.getScope(receiverObjName).getDeclaredType().getClassType() != null) {
                        this.visitConstructorPropertyDeclaration(n);
                        return;
                    }
                    if (receiverObjName == null || !this.currentScope.isNamespace(receiverObjName)) break;
                    this.visitNamespacePropertyDeclaration(n);
                }
            }
        }

        private Scope visitFunctionDef(Node fn) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            Scope fnScope = this.computeFnDeclaredType(fn, this.currentScope);
            GlobalTypeInfo.this.scopes.addFirst(fnScope);
            String fnName = NodeUtil.getFunctionName(fn);
            String internalName = GlobalTypeInfo.this.getFunInternalName(fn);
            if (this.currentScope.isDefinedLocally(fnName)) {
                GlobalTypeInfo.this.warnings.add(JSError.make(fn, VariableReferenceCheck.REDECLARED_VARIABLE, fnName));
            } else {
                this.currentScope.addLocalFunDef(internalName, fnScope);
                if (fnName != null && !TypeUtils.isIdentifier(fnName)) {
                    this.currentScope.addLocalFunDef(fnName, fnScope);
                }
            }
            if (fnName != null && TypeUtils.isIdentifier(fnName)) {
                this.undeclaredVars.removeAll((Object)fnName);
            }
            GlobalTypeInfo.this.scopeWorkset.add(fnScope);
            return fnScope;
        }

        private void visitPrototypePropertyDeclaration(Node exprResult) {
            Node initializer;
            Node getPropNode;
            Node expr = exprResult.getFirstChild();
            if (expr.isAssign()) {
                getPropNode = expr.getFirstChild();
                initializer = expr.getLastChild();
            } else {
                getPropNode = expr;
                initializer = null;
            }
            Node ctorNameNode = NodeUtil.getPrototypeClassName(getPropNode);
            String ctorName = ctorNameNode.getQualifiedName();
            if (this.currentScope.isDefinedLocally(ctorName)) {
                JSType propDeclType;
                NominalType classType = this.currentScope.getNominalType(ctorName);
                if (classType == null) {
                    return;
                }
                String pname = NodeUtil.getPrototypePropertyName(getPropNode);
                Scope methodScope = null;
                if (initializer != null && initializer.isFunction()) {
                    methodScope = this.visitFunctionDef(initializer);
                    propDeclType = JSType.fromFunctionType(methodScope.getDeclaredType().toFunctionType());
                } else {
                    propDeclType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(expr, this.currentScope);
                }
                GlobalTypeInfo.this.propertyDefs.put((Object)classType, (Object)pname, (Object)new PropertyDef(exprResult, methodScope));
                if (propDeclType != null) {
                    if (this.mayWarnAboutExistingProp(classType, pname, expr)) {
                        return;
                    }
                    classType.addProtoProperty(pname, propDeclType);
                } else {
                    classType.addUndeclaredProtoProperty(pname);
                }
            } else {
                GlobalTypeInfo.this.warnings.add(JSError.make(expr, CTOR_IN_DIFFERENT_SCOPE, new String[0]));
            }
        }

        private void visitConstructorPropertyDeclaration(Node assignNode) {
            Node getPropNode = assignNode.getFirstChild();
            String ctorName = getPropNode.getFirstChild().getQualifiedName();
            Preconditions.checkState((boolean)this.currentScope.isLocalFunDef(ctorName));
            NominalType classType = this.currentScope.getNominalType(ctorName);
            String pname = getPropNode.getLastChild().getString();
            JSType propDeclType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(assignNode, this.currentScope);
            if (propDeclType != null) {
                if (classType.mayHaveCtorProp(pname) && classType.getCtorPropDeclaredType(pname) != null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(assignNode, DUPLICATE_PROPERTY_JSDOC, pname, classType.toString()));
                    return;
                }
                classType.addCtorProperty(pname, propDeclType);
            } else {
                classType.addUndeclaredCtorProperty(pname);
            }
        }

        private void visitNamespacePropertyDeclaration(Node assignNode) {
            Node lvalue = assignNode.getFirstChild();
            String qname = lvalue.getQualifiedName();
            String leftmost = TypeUtils.getQnameRoot(qname);
            JSType declType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(assignNode, this.currentScope);
            JSType newType = this.currentScope.getDeclaredTypeOf(leftmost);
            newType = declType == null ? newType.withProperty(TypeUtils.getPropPath(qname), JSType.UNKNOWN) : newType.withDeclaredProperty(TypeUtils.getPropPath(qname), declType);
            this.currentScope.updateTypeOfLocal(leftmost, newType);
        }

        private void visitClassPropertyDeclaration(Node getPropNode) {
            NominalType thisType = this.currentScope.getDeclaredType().getThisType();
            String pname = getPropNode.getLastChild().getString();
            JSType declaredType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(getPropNode.getParent(), this.currentScope);
            if (declaredType != null) {
                this.mayWarnAboutExistingProp(thisType, pname, getPropNode);
                thisType.addClassProperty(pname, declaredType);
            } else {
                thisType.addUndeclaredClassProperty(pname);
            }
            GlobalTypeInfo.this.propertyDefs.put((Object)thisType, (Object)pname, (Object)new PropertyDef(getPropNode.getParent().getParent(), null));
        }

        private boolean mayWarnAboutExistingProp(NominalType classType, String pname, Node propCreationNode) {
            if (classType.mayHaveOwnProp(pname) && classType.getPropDeclaredType(pname) != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(propCreationNode, DUPLICATE_PROPERTY_JSDOC, pname, classType.toString()));
                return true;
            }
            return false;
        }

        private Scope computeFnDeclaredType(Node fn, Scope parentScope) {
            Preconditions.checkArgument((boolean)fn.isFunction());
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(fn);
            ArrayList formals = Lists.newArrayList();
            Node param = NodeUtil.getFunctionParameters(fn).getFirstChild();
            while (param != null) {
                formals.add(param.getQualifiedName());
                param = param.getNext();
            }
            FunctionTypeBuilder builder = GlobalTypeInfo.this.typeParser.getFunctionType(fnDoc, fn, parentScope);
            String functionName = GlobalTypeInfo.this.getFunInternalName(fn);
            if (fnDoc != null) {
                NominalType parentClass = null;
                if (fnDoc.hasBaseType()) {
                    if (!fnDoc.isConstructor()) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(fn, EXTENDS_NOT_ON_CTOR_OR_INTERF, functionName));
                    } else {
                        Node docNode = fnDoc.getBaseType().getRootNode();
                        if (GlobalTypeInfo.this.typeParser.hasKnownType(docNode, parentScope)) {
                            parentClass = GlobalTypeInfo.this.typeParser.getClassType(docNode, parentScope);
                            if (parentClass == null) {
                                GlobalTypeInfo.this.warnings.add(JSError.make(fn, EXTENDS_NON_OBJECT, functionName, docNode.toStringTree()));
                            }
                        } else {
                            GlobalTypeInfo.this.warnings.add(JSError.make(fn, UNRECOGNIZED_TYPE_NAME, docNode.toStringTree()));
                        }
                    }
                }
                NominalType nominalType = (NominalType)GlobalTypeInfo.this.nominaltypesByNode.get(fn);
                if (fnDoc.isConstructor()) {
                    if (parentClass != null) {
                        nominalType.addSuperClass(parentClass);
                    }
                    nominalType.addInterfaces(GlobalTypeInfo.this.typeParser.getImplementedInterfaces(fnDoc, parentScope));
                    builder.addClass(nominalType);
                } else if (fnDoc.isInterface()) {
                    if (!NodeUtil.isEmptyBlock(NodeUtil.getFunctionBody(fn))) {
                        GlobalTypeInfo.this.warnings.add(JSError.make(fn, INTERFACE_WITH_A_BODY, new String[0]));
                    }
                    nominalType.addInterfaces(GlobalTypeInfo.this.typeParser.getExtendedInterfaces(fnDoc, parentScope));
                    builder.addClass(nominalType);
                }
            }
            if (NodeUtil.isPrototypeMethod((Node)fn)) {
                Node lhsNode = fn.getParent().getFirstChild();
                String className = NodeUtil.getPrototypeClassName(lhsNode).getQualifiedName();
                builder.addReceiverType(parentScope.getScope(className).getDeclaredType().getClassType());
            }
            return new Scope(fn, parentScope, formals, builder.buildDeclaration());
        }

        private JSType getVarTypeFromAnnotation(Node nameNode) {
            Preconditions.checkArgument((boolean)nameNode.getParent().isVar());
            Node varNode = nameNode.getParent();
            JSType varType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(varNode, this.currentScope);
            if (varNode.getChildCount() > 1 && varType != null) {
                GlobalTypeInfo.this.warnings.add(JSError.make(varNode, TypeCheck.MULTIPLE_VAR_DEF, new String[0]));
            }
            String varName = nameNode.getQualifiedName();
            JSType nameNodeType = GlobalTypeInfo.this.getTypeDeclarationFromJsdoc(nameNode, this.currentScope);
            if (nameNodeType != null) {
                if (varType != null) {
                    GlobalTypeInfo.this.warnings.add(JSError.make(nameNode, DUPLICATE_JSDOC, varName));
                }
                return nameNodeType;
            }
            return varType;
        }
    }

    private static class PropertyDef {
        Node defSite;
        Scope methodScope;

        PropertyDef(Node defSite, Scope methodScope) {
            this.defSite = defSite;
            this.methodScope = methodScope;
        }
    }

    static class Scope
    implements DeclaredTypeRegistry {
        private final Scope parent;
        private final Node root;
        private final String name;
        private final Map<String, JSType> locals = Maps.newHashMap();
        private final ArrayList<String> formals;
        private final Set<String> outerVars = Sets.newHashSet();
        private final Map<String, Scope> localFunDefs = Maps.newHashMap();
        private Map<String, NominalType> localClassDefs = Maps.newHashMap();
        private Set<String> localNamespaces = Sets.newHashSet();
        private DeclaredFunctionType declaredType;

        private Scope(Node root, Scope parent, ArrayList<String> formals, DeclaredFunctionType declaredType) {
            this.name = parent == null ? null : NodeUtil.getFunctionName(root);
            this.root = root;
            this.parent = parent;
            this.formals = formals;
            this.declaredType = declaredType;
        }

        Node getRoot() {
            return this.root;
        }

        private Node getBody() {
            if (this.root.isFunction()) {
                return NodeUtil.getFunctionBody(this.root);
            }
            return this.root;
        }

        String getReadableName() {
            return this.name;
        }

        private void setDeclaredType(DeclaredFunctionType declaredType) {
            this.declaredType = declaredType;
        }

        DeclaredFunctionType getDeclaredType() {
            return this.declaredType;
        }

        boolean isFunction() {
            return this.root.isFunction();
        }

        boolean isConstructor() {
            if (!this.root.isFunction()) {
                return false;
            }
            JSDocInfo fnDoc = NodeUtil.getFunctionJSDocInfo(this.root);
            return fnDoc != null && fnDoc.isConstructor();
        }

        boolean isPrototypeMethod() {
            Preconditions.checkState((this.root != null ? 1 : 0) != 0);
            return NodeUtil.isPrototypeMethod((Node)this.root);
        }

        private void addLocalFunDef(String name, Scope scope) {
            this.localFunDefs.put(name, scope);
        }

        boolean isFormalParam(String name) {
            return this.formals.contains(name);
        }

        boolean isLocalVar(String name) {
            return this.locals.containsKey(name);
        }

        boolean isLocalFunDef(String name) {
            return this.localFunDefs.containsKey(name);
        }

        boolean isDefinedLocally(String name) {
            return this.locals.containsKey(name) || this.formals.contains(name) || this.localFunDefs.containsKey(name) || "this".equals(name);
        }

        boolean isNamespace(String name) {
            return this.localNamespaces.contains(name);
        }

        boolean isVisibleInScope(String name) {
            return this.isDefinedLocally(name) || this.parent != null && this.parent.isVisibleInScope(name);
        }

        private boolean isOuterVarEarly(String name) {
            return !this.isDefinedLocally(name) && this.isVisibleInScope(name);
        }

        boolean isUndeclaredFormal(String name) {
            return this.formals.contains(name) && this.getDeclaredTypeOf(name) == null;
        }

        List<String> getFormals() {
            return Lists.newArrayList(this.formals);
        }

        Set<String> getOuterVars() {
            return Sets.newHashSet(this.outerVars);
        }

        Set<String> getLocalFunDefs() {
            return Sets.newHashSet(this.localFunDefs.keySet());
        }

        boolean isOuterVar(String name) {
            return this.outerVars.contains(name);
        }

        boolean hasThis() {
            return this.isFunction() && this.getDeclaredType().getThisType() != null;
        }

        private NominalType getNominalType(String name) {
            Preconditions.checkState((this.localClassDefs != null ? 1 : 0) != 0);
            NominalType klass = this.localClassDefs.get(name);
            if (klass != null) {
                return klass;
            }
            if (this.parent != null) {
                return this.parent.getNominalType(name);
            }
            return null;
        }

        @Override
        public JSType getNominalTypeAsJstype(String name) {
            Preconditions.checkState((this.localClassDefs != null ? 1 : 0) != 0);
            NominalType klass = this.getNominalType(name);
            if (klass != null) {
                return JSType.join(JSType.fromObjectType(ObjectType.fromClass(klass)), JSType.NULL);
            }
            return null;
        }

        JSType getDeclaredTypeOf(String name) {
            if ("this".equals(name)) {
                if (!this.hasThis()) {
                    return null;
                }
                return JSType.fromObjectType(ObjectType.fromClass(this.getDeclaredType().getThisType()));
            }
            int formalIndex = this.formals.indexOf(name);
            if (formalIndex != -1) {
                JSType formalType = this.declaredType.getFormalType(formalIndex);
                if (formalType != null && formalType.isBottom()) {
                    return null;
                }
                return formalType;
            }
            JSType localType = this.locals.get(name);
            if (localType != null) {
                return localType;
            }
            Scope s = this.localFunDefs.get(name);
            if (s != null) {
                return JSType.fromFunctionType(s.getDeclaredType().toFunctionType());
            }
            if (this.parent != null) {
                return this.parent.getDeclaredTypeOf(name);
            }
            return null;
        }

        private Scope getScopeHelper(String fnName) {
            Scope s = this.localFunDefs.get(fnName);
            if (s != null) {
                return s;
            }
            if (this.parent != null) {
                return this.parent.getScopeHelper(fnName);
            }
            return null;
        }

        boolean isKnownFunction(String fnName) {
            return this.getScopeHelper(fnName) != null;
        }

        Scope getScope(String fnName) {
            Scope s = this.getScopeHelper(fnName);
            Preconditions.checkState((s != null ? 1 : 0) != 0);
            return s;
        }

        Set<String> getLocals() {
            return ImmutableSet.copyOf(this.locals.keySet());
        }

        void addLocal(String name, JSType declType) {
            Preconditions.checkState((!this.isDefinedLocally(name) ? 1 : 0) != 0);
            this.locals.put(name, declType);
        }

        void addNamespace(String name) {
            Preconditions.checkState((!this.isDefinedLocally(name) ? 1 : 0) != 0);
            this.locals.put(name, JSType.TOP_OBJECT);
            this.localNamespaces.add(name);
        }

        void updateTypeOfLocal(String name, JSType newDeclType) {
            this.locals.put(name, newDeclType);
        }

        void addOuterVar(String name) {
            this.outerVars.add(name);
        }

        void addClassType(String name, NominalType klass) {
            this.localClassDefs.put(name, klass);
        }

        void finalizeScope() {
            Iterator<String> it = this.localFunDefs.keySet().iterator();
            while (it.hasNext()) {
                String name = it.next();
                if (TypeUtils.isIdentifier(name)) continue;
                it.remove();
            }
            this.localNamespaces = null;
            this.localClassDefs = null;
        }
    }
}

