/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import com.google.gwt.thirdparty.javascript.rhino.TokenStream;

class NodeNameExtractor {
    private final char delimiter;
    private int nextUniqueInt = 0;

    NodeNameExtractor(char delimiter) {
        this.delimiter = delimiter;
    }

    String getName(Node node) {
        switch (node.getType()) {
            case 105: {
                Node functionNameNode = node.getFirstChild();
                return functionNameNode.getString();
            }
            case 33: {
                Node lhsOfDot = node.getFirstChild();
                Node rhsOfDot = lhsOfDot.getNext();
                String lhsOfDotName = this.getName(lhsOfDot);
                String rhsOfDotName = this.getName(rhsOfDot);
                if ("prototype".equals(rhsOfDotName)) {
                    return String.valueOf(lhsOfDotName) + this.delimiter;
                }
                return String.valueOf(lhsOfDotName) + this.delimiter + rhsOfDotName;
            }
            case 35: {
                Node outsideBrackets = node.getFirstChild();
                Node insideBrackets = outsideBrackets.getNext();
                String nameOutsideBrackets = this.getName(outsideBrackets);
                String nameInsideBrackets = this.getName(insideBrackets);
                if ("prototype".equals(nameInsideBrackets)) {
                    return String.valueOf(nameOutsideBrackets) + this.delimiter;
                }
                return String.valueOf(nameOutsideBrackets) + this.delimiter + nameInsideBrackets;
            }
            case 38: {
                return node.getString();
            }
            case 40: 
            case 154: {
                return TokenStream.isJSIdentifier(node.getString()) ? node.getString() : "__" + this.nextUniqueInt++;
            }
            case 39: {
                return NodeUtil.getStringValue(node);
            }
            case 42: {
                return "this";
            }
            case 37: {
                return this.getName(node.getFirstChild());
            }
        }
        StringBuilder sb = new StringBuilder();
        Node child = node.getFirstChild();
        while (child != null) {
            if (sb.length() > 0) {
                sb.append(this.delimiter);
            }
            sb.append(this.getName(child));
            child = child.getNext();
        }
        return sb.toString();
    }
}

