/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.Scope;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Deque;
import java.util.List;

class OptimizeArgumentsArray
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private static final String ARGUMENTS = "arguments";
    private static final String PARAMETER_PREFIX = "JSCompiler_OptimizeArgumentsArray_p";
    private final String paramPredix;
    private int uniqueId = 0;
    private final AbstractCompiler compiler;
    private final Deque<List<Node>> argumentsAccessStack = Lists.newLinkedList();
    private List<Node> currentArgumentsAccess = null;

    OptimizeArgumentsArray(AbstractCompiler compiler) {
        this(compiler, PARAMETER_PREFIX);
    }

    OptimizeArgumentsArray(AbstractCompiler compiler, String paramPrefix) {
        this.compiler = (AbstractCompiler)Preconditions.checkNotNull((Object)compiler);
        this.paramPredix = (String)Preconditions.checkNotNull((Object)paramPrefix);
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, (Node)Preconditions.checkNotNull((Object)root), this);
    }

    @Override
    public void enterScope(NodeTraversal traversal) {
        Preconditions.checkNotNull((Object)traversal);
        Node function = traversal.getScopeRoot();
        if (!function.isFunction()) {
            return;
        }
        if (this.currentArgumentsAccess != null) {
            this.argumentsAccessStack.push(this.currentArgumentsAccess);
        }
        this.currentArgumentsAccess = Lists.newLinkedList();
    }

    @Override
    public void exitScope(NodeTraversal traversal) {
        Preconditions.checkNotNull((Object)traversal);
        if (this.currentArgumentsAccess == null) {
            return;
        }
        if (this.tryReplaceArguments(traversal.getScope())) {
            traversal.getCompiler().reportCodeChange();
        }
        this.currentArgumentsAccess = !this.argumentsAccessStack.isEmpty() ? this.argumentsAccessStack.pop() : null;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node parent) {
        return true;
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        Preconditions.checkNotNull((Object)traversal);
        Preconditions.checkNotNull((Object)node);
        if (this.currentArgumentsAccess == null) {
            return;
        }
        if (node.isName() && ARGUMENTS.equals(node.getString())) {
            this.currentArgumentsAccess.add(node);
        }
    }

    private boolean tryReplaceArguments(Scope scope) {
        int value;
        Node parametersList = scope.getRootNode().getFirstChild().getNext();
        Preconditions.checkState((boolean)parametersList.isParamList());
        boolean changed = false;
        int numNamedParameter = parametersList.getChildCount();
        int highestIndex = numNamedParameter - 1;
        for (Node ref : this.currentArgumentsAccess) {
            Node getElem = ref.getParent();
            if (!getElem.isGetElem()) {
                return false;
            }
            Node index = ref.getNext();
            if (!index.isNumber()) {
                return false;
            }
            Node getElemParent = getElem.getParent();
            if (getElemParent.isCall() && getElemParent.getFirstChild() == getElem) {
                return false;
            }
            value = (int)index.getDouble();
            if (value <= highestIndex) continue;
            highestIndex = value;
        }
        int numExtraArgs = highestIndex - numNamedParameter + 1;
        String[] argNames = new String[numExtraArgs];
        int i = 0;
        while (i < numExtraArgs) {
            String name;
            argNames[i] = name = this.getNewName();
            parametersList.addChildrenToBack(IR.name(name));
            changed = true;
            ++i;
        }
        for (Node ref : this.currentArgumentsAccess) {
            Node index = ref.getNext();
            if (!index.isNumber()) continue;
            value = (int)index.getDouble();
            if (value >= numNamedParameter) {
                ref.getParent().getParent().replaceChild(ref.getParent(), IR.name(argNames[value - numNamedParameter]));
            } else {
                Node name = parametersList.getFirstChild();
                int i2 = 0;
                while (i2 < value) {
                    name = name.getNext();
                    ++i2;
                }
                ref.getParent().getParent().replaceChild(ref.getParent(), IR.name(name.getString()));
            }
            changed = true;
        }
        return changed;
    }

    private String getNewName() {
        return String.valueOf(this.paramPredix) + this.uniqueId++;
    }
}

