/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;

public class PeepholeCollectPropertyAssignments
extends AbstractPeepholeOptimization {
    /*
     * Unable to fully structure code
     */
    @Override
    Node optimizeSubtree(Node subtree) {
        if (!subtree.isScript() && !subtree.isBlock()) {
            return subtree;
        }
        codeChanged = false;
        child = subtree.getFirstChild();
        while (child != null) {
            block4: {
                if (!child.isVar() && !NodeUtil.isExprAssign(child) || !this.isPropertyAssignmentToName(child.getNext())) break block4;
                Preconditions.checkState((boolean)child.hasOneChild());
                name = this.getName(child);
                if (name.isName() && (value = this.getValue(child)) != null && this.isInterestingValue(value)) ** GOTO lbl13
                break block4;
                while (this.collectProperty(propertyCandidate, name.getString(), value)) {
                    codeChanged = true;
lbl13:
                    // 2 sources

                    if ((propertyCandidate = child.getNext()) != null) continue;
                }
            }
            child = child.getNext();
        }
        if (codeChanged) {
            this.reportCodeChange();
        }
        return subtree;
    }

    private Node getName(Node n) {
        if (n.isVar()) {
            return n.getFirstChild();
        }
        if (NodeUtil.isExprAssign(n)) {
            return n.getFirstChild().getFirstChild();
        }
        throw new IllegalStateException();
    }

    private Node getValue(Node n) {
        if (n.isVar()) {
            return n.getFirstChild().getFirstChild();
        }
        if (NodeUtil.isExprAssign(n)) {
            return n.getFirstChild().getLastChild();
        }
        throw new IllegalStateException();
    }

    boolean isInterestingValue(Node n) {
        return n.isObjectLit() || n.isArrayLit();
    }

    private boolean isPropertyAssignmentToName(Node propertyCandidate) {
        if (propertyCandidate == null) {
            return false;
        }
        if (!NodeUtil.isExprAssign(propertyCandidate)) {
            return false;
        }
        Node expr = propertyCandidate.getFirstChild();
        Node lhs = expr.getFirstChild();
        if (!NodeUtil.isGet(lhs)) {
            return false;
        }
        Node obj = lhs.getFirstChild();
        return obj.isName();
    }

    private boolean collectProperty(Node propertyCandidate, String name, Node value) {
        if (!this.isPropertyAssignmentToName(propertyCandidate)) {
            return false;
        }
        Node lhs = propertyCandidate.getFirstChild().getFirstChild();
        if (!name.equals(lhs.getFirstChild().getString())) {
            return false;
        }
        Node rhs = lhs.getNext();
        if (this.mayHaveSideEffects(rhs) || NodeUtil.canBeSideEffected(rhs)) {
            return false;
        }
        if (!NodeUtil.isLiteralValue(rhs, true) && PeepholeCollectPropertyAssignments.mightContainForwardReference(rhs, name)) {
            return false;
        }
        switch (value.getType()) {
            case 63: {
                if (this.collectArrayProperty(value, propertyCandidate)) break;
                return false;
            }
            case 64: {
                if (this.collectObjectProperty(value, propertyCandidate)) break;
                return false;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    private boolean collectArrayProperty(Node arrayLiteral, Node propertyCandidate) {
        Node assignment = propertyCandidate.getFirstChild();
        int sizeOfArrayAtStart = arrayLiteral.getChildCount();
        int maxIndexAssigned = sizeOfArrayAtStart - 1;
        Node lhs = assignment.getFirstChild();
        Node rhs = lhs.getNext();
        if (!lhs.isGetElem()) {
            return false;
        }
        Node obj = lhs.getFirstChild();
        Node property = obj.getNext();
        if (!property.isNumber()) {
            return false;
        }
        double dindex = property.getDouble();
        if (!(dindex >= 0.0) || Double.isInfinite(dindex) || dindex > 2.147483647E9) {
            return false;
        }
        int index = (int)dindex;
        if (dindex != (double)index) {
            return false;
        }
        if (maxIndexAssigned + 4 < index) {
            return false;
        }
        if (index > maxIndexAssigned) {
            while (maxIndexAssigned < index - 1) {
                Node emptyNode = IR.empty().srcref(arrayLiteral);
                arrayLiteral.addChildToBack(emptyNode);
                ++maxIndexAssigned;
            }
            arrayLiteral.addChildToBack(rhs.detachFromParent());
        } else {
            Node currentValue = arrayLiteral.getChildAtIndex(index);
            if (!currentValue.isEmpty()) {
                return false;
            }
            arrayLiteral.replaceChild(currentValue, rhs.detachFromParent());
        }
        propertyCandidate.detachFromParent();
        return true;
    }

    private boolean collectObjectProperty(Node objectLiteral, Node propertyCandidate) {
        Node assignment = propertyCandidate.getFirstChild();
        Node lhs = assignment.getFirstChild();
        Node rhs = lhs.getNext();
        Node obj = lhs.getFirstChild();
        Node property = obj.getNext();
        if (lhs.isGetElem() && !property.isString() && !property.isNumber()) {
            return false;
        }
        String propertyName = property.isNumber() ? NodeUtil.getStringValue(property) : property.getString();
        Node newProperty = IR.stringKey(propertyName).copyInformationFrom(property);
        if (lhs.isGetElem()) {
            newProperty.setQuotedString();
        }
        Node newValue = rhs.detachFromParent();
        newProperty.addChildToBack(newValue);
        objectLiteral.addChildToBack(newProperty);
        propertyCandidate.detachFromParent();
        return true;
    }

    private static boolean mightContainForwardReference(Node node, String varName) {
        if (node.isName()) {
            return varName.equals(node.getString());
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (PeepholeCollectPropertyAssignments.mightContainForwardReference(child, varName)) {
                return true;
            }
            child = child.getNext();
        }
        return false;
    }
}

