/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.gwt.thirdparty.javascript.jscomp.CodeGenerator;
import com.google.gwt.thirdparty.javascript.jscomp.CodingConvention;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.IR;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.regex.Pattern;

class PeepholeSubstituteAlternateSyntax
extends AbstractPeepholeOptimization {
    private static final CodeGenerator REGEXP_ESCAPER = CodeGenerator.forCostEstimation(null);
    private final boolean late;
    private static final int STRING_SPLIT_OVERHEAD = ".split('.')".length();
    static final DiagnosticType INVALID_REGULAR_EXPRESSION_FLAGS = DiagnosticType.warning("JSC_INVALID_REGULAR_EXPRESSION_FLAGS", "Invalid flags to RegExp constructor: {0}");
    private static final ImmutableSet<String> STANDARD_OBJECT_CONSTRUCTORS = ImmutableSet.of((Object)"Object", (Object)"Array", (Object)"RegExp", (Object)"Error");
    private static final Pattern REGEXP_FLAGS_RE = Pattern.compile("^[gmi]*$");

    PeepholeSubstituteAlternateSyntax(boolean late) {
        this.late = late;
    }

    @Override
    public Node optimizeSubtree(Node node) {
        switch (node.getType()) {
            case 43: 
            case 44: {
                return this.reduceTrueFalse(node);
            }
            case 30: {
                node = this.tryFoldStandardConstructors(node);
                if (!node.isCall()) {
                    return node;
                }
            }
            case 37: {
                Node result = this.tryFoldLiteralConstructor(node);
                if (result == node && (result = this.tryFoldSimpleFunctionCall(node)) == node) {
                    result = this.tryFoldImmediateCallToBoundFunction(node);
                }
                return result;
            }
            case 4: {
                return this.tryReduceReturn(node);
            }
            case 85: {
                return this.trySplitComma(node);
            }
            case 38: {
                return this.tryReplaceUndefined(node);
            }
            case 63: {
                return this.tryMinimizeArrayLiteral(node);
            }
            case 9: 
            case 10: 
            case 11: 
            case 23: 
            case 100: 
            case 101: {
                return this.tryRotateAssociativeOperator(node);
            }
        }
        return node;
    }

    private Node tryRotateAssociativeOperator(Node n) {
        if (!this.late) {
            return n;
        }
        Preconditions.checkArgument((boolean)NodeUtil.isAssociative(n.getType()));
        Node rhs = n.getLastChild();
        if (n.getType() == rhs.getType()) {
            Node first = n.getFirstChild().detachFromParent();
            Node second = rhs.getFirstChild().detachFromParent();
            Node third = rhs.getLastChild().detachFromParent();
            Node newLhs = new Node(n.getType(), first, second).copyInformationFrom(n);
            Node newRoot = new Node(rhs.getType(), newLhs, third).copyInformationFrom(rhs);
            n.getParent().replaceChild(n, newRoot);
            this.reportCodeChange();
            return newRoot;
        }
        if (NodeUtil.isCommutative(n.getType()) && !NodeUtil.mayHaveSideEffects(n)) {
            Node lhs = n.getFirstChild();
            while (lhs.getType() == n.getType()) {
                lhs = lhs.getFirstChild();
            }
            int precedence = NodeUtil.precedence(n.getType());
            int lhsPrecedence = NodeUtil.precedence(lhs.getType());
            int rhsPrecedence = NodeUtil.precedence(rhs.getType());
            if (rhsPrecedence == precedence && lhsPrecedence != precedence) {
                n.removeChild(rhs);
                lhs.getParent().replaceChild(lhs, rhs);
                n.addChildToBack(lhs);
                this.reportCodeChange();
                return n;
            }
        }
        return n;
    }

    private Node tryFoldSimpleFunctionCall(Node n) {
        Node value;
        Preconditions.checkState((boolean)n.isCall());
        Node callTarget = n.getFirstChild();
        if (callTarget != null && callTarget.isName() && callTarget.getString().equals("String") && (value = callTarget.getNext()) != null && value.getNext() == null && NodeUtil.isImmutableValue(value)) {
            Node addition = IR.add(IR.string("").srcref(callTarget), value.detachFromParent());
            n.getParent().replaceChild(n, addition);
            this.reportCodeChange();
            return addition;
        }
        return n;
    }

    private Node tryFoldImmediateCallToBoundFunction(Node n) {
        Preconditions.checkState((boolean)n.isCall());
        Node callTarget = n.getFirstChild();
        CodingConvention.Bind bind = this.getCodingConvention().describeFunctionBind(callTarget, false);
        if (bind != null) {
            bind.target.detachFromParent();
            n.replaceChild(callTarget, bind.target);
            callTarget = bind.target;
            this.addParameterAfter(bind.parameters, callTarget);
            if (bind.thisValue != null && !NodeUtil.isUndefined(bind.thisValue)) {
                Node newCallTarget = IR.getprop(callTarget.cloneTree(), IR.string("call").srcref(callTarget));
                n.replaceChild(callTarget, newCallTarget);
                n.addChildAfter(bind.thisValue.cloneTree(), newCallTarget);
                n.putBooleanProp(50, false);
            } else {
                n.putBooleanProp(50, true);
            }
            this.reportCodeChange();
        }
        return n;
    }

    private void addParameterAfter(Node parameterList, Node after) {
        if (parameterList != null) {
            this.addParameterAfter(parameterList.getNext(), after);
            after.getParent().addChildAfter(parameterList.cloneTree(), after);
        }
    }

    private Node trySplitComma(Node n) {
        if (this.late) {
            return n;
        }
        Node parent = n.getParent();
        Node left = n.getFirstChild();
        Node right = n.getLastChild();
        if (parent.isExprResult() && !parent.getParent().isLabel()) {
            n.detachChildren();
            parent.replaceChild(n, left);
            Node newStatement = IR.exprResult(right);
            newStatement.copyInformationFrom(n);
            parent.getParent().addChildAfter(newStatement, parent);
            this.reportCodeChange();
            return left;
        }
        return n;
    }

    private Node tryReplaceUndefined(Node n) {
        if (this.isASTNormalized() && NodeUtil.isUndefined(n) && !NodeUtil.isLValue(n)) {
            Node replacement = NodeUtil.newUndefinedNode(n);
            n.getParent().replaceChild(n, replacement);
            this.reportCodeChange();
            return replacement;
        }
        return n;
    }

    private Node tryReduceReturn(Node n) {
        Node result = n.getFirstChild();
        if (result != null) {
            switch (result.getType()) {
                case 122: {
                    Node operand = result.getFirstChild();
                    if (this.mayHaveSideEffects(operand)) break;
                    n.removeFirstChild();
                    this.reportCodeChange();
                    break;
                }
                case 38: {
                    String name = result.getString();
                    if (!name.equals("undefined")) break;
                    n.removeFirstChild();
                    this.reportCodeChange();
                }
            }
        }
        return n;
    }

    private Node tryFoldStandardConstructors(Node n) {
        String className;
        Preconditions.checkState((boolean)n.isNew());
        if (this.isASTNormalized() && n.getFirstChild().isName() && STANDARD_OBJECT_CONSTRUCTORS.contains((Object)(className = n.getFirstChild().getString()))) {
            n.setType(37);
            n.putBooleanProp(50, true);
            this.reportCodeChange();
        }
        return n;
    }

    private Node tryFoldLiteralConstructor(Node n) {
        Preconditions.checkArgument((n.isCall() || n.isNew() ? 1 : 0) != 0);
        Node constructorNameNode = n.getFirstChild();
        Node newLiteralNode = null;
        if (this.isASTNormalized() && 38 == constructorNameNode.getType()) {
            Node arg0;
            FoldArrayAction action;
            boolean constructorHasArgs;
            String className = constructorNameNode.getString();
            if ("RegExp".equals(className)) {
                return this.tryFoldRegularExpressionConstructor(n);
            }
            boolean bl = constructorHasArgs = constructorNameNode.getNext() != null;
            if ("Object".equals(className) && !constructorHasArgs) {
                newLiteralNode = IR.objectlit(new Node[0]);
            } else if ("Array".equals(className) && ((action = PeepholeSubstituteAlternateSyntax.isSafeToFoldArrayConstructor(arg0 = constructorNameNode.getNext())) == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS || action == FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS)) {
                newLiteralNode = IR.arraylit(new Node[0]);
                n.removeChildren();
                if (action == FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS) {
                    newLiteralNode.addChildrenToFront(arg0);
                }
            }
            if (newLiteralNode != null) {
                n.getParent().replaceChild(n, newLiteralNode);
                this.reportCodeChange();
                return newLiteralNode;
            }
        }
        return n;
    }

    private static FoldArrayAction isSafeToFoldArrayConstructor(Node arg) {
        FoldArrayAction action = FoldArrayAction.NOT_SAFE_TO_FOLD;
        if (arg == null) {
            action = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
        } else if (arg.getNext() != null) {
            action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
        } else {
            switch (arg.getType()) {
                case 40: {
                    action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                    break;
                }
                case 39: {
                    if (arg.getDouble() != 0.0) break;
                    action = FoldArrayAction.SAFE_TO_FOLD_WITHOUT_ARGS;
                    break;
                }
                case 63: {
                    action = FoldArrayAction.SAFE_TO_FOLD_WITH_ARGS;
                }
            }
        }
        return action;
    }

    private Node tryFoldRegularExpressionConstructor(Node n) {
        Node flags;
        Node parent = n.getParent();
        Node constructor = n.getFirstChild();
        Node pattern = constructor.getNext();
        Node node = flags = pattern != null ? pattern.getNext() : null;
        if (pattern == null || flags != null && flags.getNext() != null) {
            return n;
        }
        if (!(!pattern.isString() || "".equals(pattern.getString()) || pattern.getString().length() >= 100 || flags != null && !flags.isString() || !this.isEcmaScript5OrGreater() && PeepholeSubstituteAlternateSyntax.containsUnicodeEscape(pattern.getString()))) {
            Node regexLiteral;
            pattern = PeepholeSubstituteAlternateSyntax.makeForwardSlashBracketSafe(pattern);
            if (flags == null || "".equals(flags.getString())) {
                regexLiteral = IR.regexp(pattern);
            } else {
                if (!PeepholeSubstituteAlternateSyntax.areValidRegexpFlags(flags.getString())) {
                    this.report(INVALID_REGULAR_EXPRESSION_FLAGS, flags);
                    return n;
                }
                if (!this.areSafeFlagsToFold(flags.getString())) {
                    return n;
                }
                n.removeChild(flags);
                regexLiteral = IR.regexp(pattern, flags);
            }
            parent.replaceChild(n, regexLiteral);
            this.reportCodeChange();
            return regexLiteral;
        }
        return n;
    }

    private Node reduceTrueFalse(Node n) {
        if (this.late) {
            Node not = IR.not(IR.number(!n.isTrue() ? 1 : 0));
            not.copyInformationFromForTree(n);
            n.getParent().replaceChild(n, not);
            this.reportCodeChange();
            return not;
        }
        return n;
    }

    private Node tryMinimizeArrayLiteral(Node n) {
        boolean allStrings = true;
        Node cur = n.getFirstChild();
        while (cur != null) {
            if (!cur.isString()) {
                allStrings = false;
            }
            cur = cur.getNext();
        }
        if (allStrings) {
            return this.tryMinimizeStringArrayLiteral(n);
        }
        return n;
    }

    private Node tryMinimizeStringArrayLiteral(Node n) {
        if (!this.late) {
            return n;
        }
        int numElements = n.getChildCount();
        int saving = numElements * 2 - STRING_SPLIT_OVERHEAD;
        if (saving <= 0) {
            return n;
        }
        Object[] strings = new String[n.getChildCount()];
        int idx = 0;
        Node cur = n.getFirstChild();
        while (cur != null) {
            strings[idx++] = cur.getString();
            cur = cur.getNext();
        }
        String delimiter = PeepholeSubstituteAlternateSyntax.pickDelimiter((String[])strings);
        if (delimiter != null) {
            String template = Joiner.on((String)delimiter).join(strings);
            Node call = IR.call(IR.getprop(IR.string(template), IR.string("split")), IR.string(delimiter));
            call.copyInformationFromForTree(n);
            n.getParent().replaceChild(n, call);
            this.reportCodeChange();
            return call;
        }
        return n;
    }

    private static String pickDelimiter(String[] strings) {
        boolean allLength1 = true;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() != 1) {
                allLength1 = false;
                break;
            }
            ++n2;
        }
        if (allLength1) {
            return "";
        }
        String[] stringArray2 = new String[6];
        stringArray2[0] = " ";
        stringArray2[1] = ";";
        stringArray2[2] = ",";
        stringArray2[3] = "{";
        stringArray2[4] = "}";
        String[] delimiters = stringArray2;
        int i = 0;
        block1: while (delimiters[i] != null) {
            String[] stringArray3 = strings;
            int n3 = strings.length;
            int n4 = 0;
            while (n4 < n3) {
                String cur = stringArray3[n4];
                if (!cur.contains(delimiters[i])) {
                    ++n4;
                    continue;
                }
                ++i;
                continue block1;
            }
            break block1;
        }
        return delimiters[i];
    }

    private static boolean areValidRegexpFlags(String flags) {
        return REGEXP_FLAGS_RE.matcher(flags).matches();
    }

    private boolean areSafeFlagsToFold(String flags) {
        return this.isEcmaScript5OrGreater() || flags.indexOf(103) < 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Node makeForwardSlashBracketSafe(Node n) {
        String s = n.getString();
        StringBuilder sb = null;
        int pos = 0;
        boolean isEscaped = false;
        boolean inCharset = false;
        int i = 0;
        while (i < s.length()) {
            block19: {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\\': {
                        isEscaped = !isEscaped;
                        break block19;
                    }
                    case '/': {
                        if (isEscaped || inCharset) break;
                        if (sb == null) {
                            sb = new StringBuilder(s.length() + 16);
                        }
                        sb.append(s, pos, i).append('\\');
                        pos = i;
                        break;
                    }
                    case '[': {
                        if (isEscaped) break;
                        inCharset = true;
                        break;
                    }
                    case ']': {
                        if (isEscaped) break;
                        inCharset = false;
                        break;
                    }
                    case '\n': 
                    case '\r': 
                    case '\u2028': 
                    case '\u2029': {
                        if (sb == null) {
                            sb = new StringBuilder(s.length() + 16);
                        }
                        if (isEscaped) {
                            sb.append(s, pos, i - 1);
                        } else {
                            sb.append(s, pos, i);
                        }
                        switch (ch) {
                            case '\r': {
                                sb.append("\\r");
                                break;
                            }
                            case '\n': {
                                sb.append("\\n");
                                break;
                            }
                            case '\u2028': {
                                sb.append("\\u2028");
                                break;
                            }
                            case '\u2029': {
                                sb.append("\\u2029");
                                break;
                            }
                        }
                        pos = i + 1;
                    }
                }
                isEscaped = false;
            }
            ++i;
        }
        if (sb == null) {
            return n.cloneTree();
        }
        sb.append(s, pos, s.length());
        return IR.string(sb.toString()).srcref(n);
    }

    static boolean containsUnicodeEscape(String s) {
        String esc = REGEXP_ESCAPER.regexpEscape(s);
        int i = -1;
        while ((i = esc.indexOf("\\u", i + 1)) >= 0) {
            int nSlashes = 0;
            while (i - nSlashes > 0 && '\\' == esc.charAt(i - nSlashes - 1)) {
                ++nSlashes;
            }
            if ((nSlashes & 1) != 0) continue;
            return true;
        }
        return false;
    }

    private static enum FoldArrayAction {
        NOT_SAFE_TO_FOLD,
        SAFE_TO_FOLD_WITH_ARGS,
        SAFE_TO_FOLD_WITHOUT_ARGS;

    }
}

