/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.AnalyzePrototypeProperties;
import com.google.gwt.thirdparty.javascript.jscomp.SpecializationAwareCompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.SpecializeModule;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Collection;
import java.util.logging.Logger;

class RemoveUnusedPrototypeProperties
implements SpecializationAwareCompilerPass {
    private static final Logger logger = Logger.getLogger(RemoveUnusedPrototypeProperties.class.getName());
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;
    private final boolean anchorUnusedVars;
    private SpecializeModule.SpecializationState specializationState;

    RemoveUnusedPrototypeProperties(AbstractCompiler compiler, boolean canModifyExterns, boolean anchorUnusedVars) {
        this.compiler = compiler;
        this.canModifyExterns = canModifyExterns;
        this.anchorUnusedVars = anchorUnusedVars;
    }

    @Override
    public void enableSpecialization(SpecializeModule.SpecializationState state) {
        this.specializationState = state;
    }

    @Override
    public void process(Node externRoot, Node root) {
        AnalyzePrototypeProperties analyzer = new AnalyzePrototypeProperties(this.compiler, null, this.canModifyExterns, this.anchorUnusedVars);
        analyzer.process(externRoot, root);
        this.removeUnusedSymbols(analyzer.getAllNameInfo());
    }

    private void removeUnusedSymbols(Collection<AnalyzePrototypeProperties.NameInfo> allNameInfo) {
        for (AnalyzePrototypeProperties.NameInfo nameInfo : allNameInfo) {
            if (nameInfo.isReferenced()) continue;
            for (AnalyzePrototypeProperties.Symbol declaration : nameInfo.getDeclarations()) {
                boolean canRemove = false;
                if (this.specializationState == null) {
                    canRemove = true;
                } else {
                    Node specializableFunction = this.getSpecializableFunctionFromSymbol(declaration);
                    if (specializableFunction != null) {
                        this.specializationState.reportRemovedFunction(specializableFunction, null);
                        canRemove = true;
                    }
                }
                if (!canRemove) continue;
                declaration.remove(this.compiler);
            }
            logger.fine("Removed unused prototype property: " + nameInfo.name);
        }
    }

    private Node getSpecializableFunctionFromSymbol(AnalyzePrototypeProperties.Symbol symbol2) {
        Preconditions.checkNotNull((Object)this.specializationState);
        Node specializableFunction = null;
        if (symbol2 instanceof AnalyzePrototypeProperties.GlobalFunction) {
            specializableFunction = ((AnalyzePrototypeProperties.GlobalFunction)symbol2).getFunctionNode();
        } else if (symbol2 instanceof AnalyzePrototypeProperties.AssignmentProperty) {
            Node propertyValue = ((AnalyzePrototypeProperties.AssignmentProperty)symbol2).getValue();
            if (propertyValue.isFunction()) {
                specializableFunction = propertyValue;
            }
        } else {
            if (symbol2 instanceof AnalyzePrototypeProperties.LiteralProperty) {
                return null;
            }
            Preconditions.checkState((boolean)false, (Object)"Should be unreachable.");
        }
        if (specializableFunction != null && this.specializationState.canFixupFunction(specializableFunction)) {
            return specializableFunction;
        }
        return null;
    }
}

