/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CheckLevel;
import com.google.gwt.thirdparty.javascript.jscomp.DiagnosticType;
import com.google.gwt.thirdparty.javascript.jscomp.JSError;
import com.google.gwt.thirdparty.javascript.jscomp.SourceFile;
import com.google.gwt.thirdparty.javascript.rhino.ErrorReporter;
import com.google.gwt.thirdparty.javascript.rhino.SimpleErrorReporter;
import com.google.gwt.thirdparty.javascript.rhino.head.EvaluatorException;
import com.google.gwt.thirdparty.javascript.rhino.head.ScriptRuntime;
import com.google.gwt.thirdparty.javascript.rhino.head.ast.IdeErrorReporter;
import java.util.Map;
import java.util.regex.Pattern;

class RhinoErrorReporter {
    static final DiagnosticType PARSE_ERROR = DiagnosticType.error("JSC_PARSE_ERROR", "Parse error. {0}");
    static final DiagnosticType TYPE_PARSE_ERROR = DiagnosticType.warning("JSC_TYPE_PARSE_ERROR", "{0}");
    static final DiagnosticType TRAILING_COMMA = DiagnosticType.error("JSC_TRAILING_COMMA", "Parse error. IE8 (and below) will parse trailing commas in array and object literals incorrectly. If you are targeting newer versions of JS, set the appropriate language_in option.");
    static final DiagnosticType DUPLICATE_PARAM = DiagnosticType.error("JSC_DUPLICATE_PARAM", "Parse error. {0}");
    static final DiagnosticType BAD_JSDOC_ANNOTATION = DiagnosticType.warning("JSC_BAD_JSDOC_ANNOTATION", "Parse error. {0}");
    static final DiagnosticType MISPLACED_TYPE_ANNOTATION = DiagnosticType.warning("JSC_MISPLACED_TYPE_ANNOTATION", "Type annotations are not allowed here. Are you missing parentheses?");
    static final DiagnosticType INVALID_ES3_PROP_NAME = DiagnosticType.warning("JSC_INVALID_ES3_PROP_NAME", "Keywords and reserved words are not allowed as unquoted property names in older versions of JavaScript. If you are targeting newer versions of JavaScript, set the appropriate language_in option.");
    static final DiagnosticType PARSE_TREE_TOO_DEEP = DiagnosticType.error("PARSE_TREE_TOO_DEEP", "Parse tree too deep.");
    private final Map<Pattern, DiagnosticType> typeMap;
    final AbstractCompiler compiler;

    private Pattern replacePlaceHolders(String s) {
        s = Pattern.quote(s);
        return Pattern.compile(s.replaceAll("\\{\\d+\\}", "\\\\E.*\\\\Q"));
    }

    private RhinoErrorReporter(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.typeMap = ImmutableMap.builder().put((Object)this.replacePlaceHolders(ScriptRuntime.getMessage0("msg.extra.trailing.comma")), (Object)TRAILING_COMMA).put((Object)this.replacePlaceHolders(ScriptRuntime.getMessage0("msg.dup.parms")), (Object)DUPLICATE_PARAM).put((Object)this.replacePlaceHolders(SimpleErrorReporter.getMessage0("msg.bad.jsdoc.tag")), (Object)BAD_JSDOC_ANNOTATION).put((Object)Pattern.compile("^Type annotations are not allowed here.*"), (Object)MISPLACED_TYPE_ANNOTATION).put((Object)Pattern.compile("^Keywords and reserved words are not allowed as unquoted property.*"), (Object)INVALID_ES3_PROP_NAME).put((Object)Pattern.compile("^Bad type annotation.*"), (Object)TYPE_PARSE_ERROR).put((Object)this.replacePlaceHolders(ScriptRuntime.getMessage0("msg.too.deep.parser.recursion")), (Object)PARSE_TREE_TOO_DEEP).build();
    }

    public static com.google.gwt.thirdparty.javascript.rhino.head.ErrorReporter forNewRhino(AbstractCompiler compiler) {
        return new NewRhinoErrorReporter(compiler);
    }

    public static ErrorReporter forOldRhino(AbstractCompiler compiler) {
        return new OldRhinoErrorReporter(compiler);
    }

    void warningAtLine(String message, String sourceName, int line, int lineOffset) {
        this.compiler.report(this.makeError(message, sourceName, line, lineOffset, CheckLevel.WARNING));
    }

    void errorAtLine(String message, String sourceName, int line, int lineOffset) {
        this.compiler.report(this.makeError(message, sourceName, line, lineOffset, CheckLevel.ERROR));
    }

    protected DiagnosticType mapError(String message) {
        for (Map.Entry<Pattern, DiagnosticType> entry : this.typeMap.entrySet()) {
            if (!entry.getKey().matcher(message).matches()) continue;
            return entry.getValue();
        }
        return null;
    }

    private JSError makeError(String message, String sourceName, int line, int lineOffset, CheckLevel defaultLevel) {
        DiagnosticType type = this.mapError(message);
        if (type != null) {
            return JSError.make(sourceName, line, lineOffset, type, message);
        }
        return JSError.make(sourceName, line, lineOffset, defaultLevel, PARSE_ERROR, message);
    }

    /* synthetic */ RhinoErrorReporter(AbstractCompiler abstractCompiler, RhinoErrorReporter rhinoErrorReporter) {
        this(abstractCompiler);
    }

    private static class NewRhinoErrorReporter
    extends RhinoErrorReporter
    implements IdeErrorReporter {
        private NewRhinoErrorReporter(AbstractCompiler compiler) {
            super(compiler, null);
        }

        @Override
        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            DiagnosticType type = this.mapError(message);
            if (type != null) {
                super.errorAtLine(message, sourceName, line, lineOffset);
            }
            return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
        }

        @Override
        public void error(String message, String sourceName, int line, String sourceLine, int lineOffset) {
            super.errorAtLine(message, sourceName, line, lineOffset);
        }

        @Override
        public void error(String message, String sourceName, int offset, int length) {
            int line = 1;
            int column = 0;
            SourceFile file = this.compiler.getSourceFileByName(sourceName);
            if (file != null) {
                line = file.getLineOfOffset(offset);
                column = file.getColumnOfOffset(offset);
            }
            super.errorAtLine(message, sourceName, line, column);
        }

        @Override
        public void warning(String message, String sourceName, int line, String sourceLine, int lineOffset) {
            super.warningAtLine(message, sourceName, line, lineOffset);
        }

        @Override
        public void warning(String message, String sourceName, int offset, int length) {
            int line = 1;
            int column = 0;
            SourceFile file = this.compiler.getSourceFileByName(sourceName);
            if (file != null) {
                line = file.getLineOfOffset(offset);
                column = file.getColumnOfOffset(offset);
            }
            super.errorAtLine(message, sourceName, line, column);
        }
    }

    private static class OldRhinoErrorReporter
    extends RhinoErrorReporter
    implements ErrorReporter {
        private OldRhinoErrorReporter(AbstractCompiler compiler) {
            super(compiler, null);
        }

        @Override
        public void error(String message, String sourceName, int line, int lineOffset) {
            super.errorAtLine(message, sourceName, line, lineOffset);
        }

        @Override
        public void warning(String message, String sourceName, int line, int lineOffset) {
            super.warningAtLine(message, sourceName, line, lineOffset);
        }
    }
}

