/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.RenameVars;
import com.google.gwt.thirdparty.javascript.jscomp.Scope;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;

class ShadowVariables
implements CompilerPass {
    private final Multimap<Node, String> scopeUpRefMap = HashMultimap.create();
    private final Multimap<Scope.Var, Node> varToNameUsage = HashMultimap.create();
    private final AbstractCompiler compiler;
    private final SortedSet<RenameVars.Assignment> varsByFrequency;
    private final Map<String, RenameVars.Assignment> assignments;
    private final Map<Node, String> oldPseudoNameMap;
    private final Map<Node, String> deltaPseudoNameMap;

    ShadowVariables(AbstractCompiler compiler, Map<String, RenameVars.Assignment> assignments, SortedSet<RenameVars.Assignment> varsByFrequency, Map<Node, String> pseudoNameMap) {
        this.compiler = compiler;
        this.assignments = assignments;
        this.varsByFrequency = varsByFrequency;
        this.oldPseudoNameMap = pseudoNameMap;
        this.deltaPseudoNameMap = Maps.newLinkedHashMap();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new GatherReferenceInfo());
        NodeTraversal.traverse(this.compiler, root, new DoShadowVariables());
        if (this.oldPseudoNameMap != null) {
            this.oldPseudoNameMap.putAll(this.deltaPseudoNameMap);
        }
    }

    private class DoShadowVariables
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private DoShadowVariables() {
        }

        @Override
        public void enterScope(NodeTraversal t) {
            Scope s = t.getScope();
            if (!s.isLocal()) {
                return;
            }
            if (s.getParent().isGlobal()) {
                return;
            }
            Iterator<Scope.Var> vars = s.getVars();
            while (vars.hasNext()) {
                RenameVars.Assignment bestShadow;
                Scope.Var var = vars.next();
                if (var.isBleedingFunction() || ShadowVariables.this.compiler.getCodingConvention().isExported(var.name, s.isLocal()) || (bestShadow = this.findBestShadow(s)) == null) continue;
                RenameVars.Assignment localAssignment = (RenameVars.Assignment)ShadowVariables.this.assignments.get(var.getName());
                if (bestShadow.count < localAssignment.count) continue;
                this.doShadow(localAssignment, bestShadow, var);
                if (ShadowVariables.this.oldPseudoNameMap == null) continue;
                String targetPseudoName = (String)ShadowVariables.this.oldPseudoNameMap.get(s.getVar((String)bestShadow.oldName).nameNode);
                for (Node use : ShadowVariables.this.varToNameUsage.get((Object)var)) {
                    ShadowVariables.this.deltaPseudoNameMap.put(use, targetPseudoName);
                }
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
        }

        private RenameVars.Assignment findBestShadow(Scope curScope) {
            for (RenameVars.Assignment assignment : ShadowVariables.this.varsByFrequency) {
                if (!assignment.oldName.startsWith("L ") || ShadowVariables.this.scopeUpRefMap.get((Object)curScope.getRootNode()).contains(assignment.oldName) || !curScope.isDeclared(assignment.oldName, true)) continue;
                return assignment;
            }
            return null;
        }

        private void doShadow(RenameVars.Assignment original, RenameVars.Assignment toShadow, Scope.Var var) {
            Scope s = var.getScope();
            Collection references = ShadowVariables.this.varToNameUsage.get((Object)var);
            ShadowVariables.this.varsByFrequency.remove(original);
            ShadowVariables.this.varsByFrequency.remove(toShadow);
            original.count -= references.size();
            toShadow.count += references.size();
            ShadowVariables.this.varsByFrequency.add(original);
            ShadowVariables.this.varsByFrequency.add(toShadow);
            Scope.Var shadowed = s.getVar(toShadow.oldName);
            if (shadowed != null) {
                Scope curScope = s;
                while (curScope != shadowed.scope) {
                    ShadowVariables.this.scopeUpRefMap.put((Object)curScope.getRootNode(), (Object)toShadow.oldName);
                    curScope = curScope.getParent();
                }
            }
            for (Node n : references) {
                n.setString(toShadow.oldName);
                Node cur = n;
                while (cur != s.getRootNode()) {
                    if (!(cur = cur.getParent()).isFunction()) continue;
                    ShadowVariables.this.scopeUpRefMap.put((Object)cur, (Object)toShadow.oldName);
                }
            }
        }
    }

    private class GatherReferenceInfo
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherReferenceInfo() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return;
            }
            if (t.inGlobalScope()) {
                return;
            }
            Scope.Var var = t.getScope().getVar(n.getString());
            if (var == null) {
                return;
            }
            if (var.getScope().isGlobal()) {
                return;
            }
            if (var.getScope() != t.getScope()) {
                Scope s = t.getScope();
                while (s != var.getScope() && s.isLocal()) {
                    ShadowVariables.this.scopeUpRefMap.put((Object)s.getRootNode(), (Object)var.name);
                    s = s.getParent();
                }
            }
            if (var.getScope() == t.getScope()) {
                ShadowVariables.this.scopeUpRefMap.put((Object)t.getScopeRoot(), (Object)var.name);
            }
            ShadowVariables.this.varToNameUsage.put((Object)var, (Object)n);
        }
    }
}

