/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.LinkedHashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractCompiler;
import com.google.gwt.thirdparty.javascript.jscomp.CodingConvention;
import com.google.gwt.thirdparty.javascript.jscomp.CompilerPass;
import com.google.gwt.thirdparty.javascript.jscomp.DefinitionProvider;
import com.google.gwt.thirdparty.javascript.jscomp.DefinitionSite;
import com.google.gwt.thirdparty.javascript.jscomp.DefinitionsRemover;
import com.google.gwt.thirdparty.javascript.jscomp.NodeTraversal;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.UseSite;
import com.google.gwt.thirdparty.javascript.rhino.JSDocInfo;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

class SimpleDefinitionFinder
implements CompilerPass,
DefinitionProvider {
    private final AbstractCompiler compiler;
    private final Map<Node, DefinitionSite> definitionSiteMap;
    private final Multimap<String, DefinitionsRemover.Definition> nameDefinitionMultimap;
    private final Multimap<String, UseSite> nameUseSiteMultimap;

    public SimpleDefinitionFinder(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.definitionSiteMap = Maps.newLinkedHashMap();
        this.nameDefinitionMultimap = LinkedHashMultimap.create();
        this.nameUseSiteMultimap = LinkedHashMultimap.create();
    }

    public Collection<DefinitionSite> getDefinitionSites() {
        return this.definitionSiteMap.values();
    }

    private DefinitionSite getDefinitionAt(Node node) {
        return this.definitionSiteMap.get(node);
    }

    DefinitionSite getDefinitionForFunction(Node function) {
        Preconditions.checkState((boolean)function.isFunction());
        return this.getDefinitionAt(SimpleDefinitionFinder.getNameNodeFromFunctionNode(function));
    }

    @Override
    public Collection<DefinitionsRemover.Definition> getDefinitionsReferencedAt(Node useSite) {
        String name;
        String propName;
        if (this.definitionSiteMap.containsKey(useSite)) {
            return null;
        }
        if (useSite.isGetProp() && ((propName = useSite.getLastChild().getString()).equals("apply") || propName.equals("call"))) {
            useSite = useSite.getFirstChild();
        }
        if ((name = SimpleDefinitionFinder.getSimplifiedName(useSite)) != null) {
            Collection defs = this.nameDefinitionMultimap.get((Object)name);
            if (!defs.isEmpty()) {
                return defs;
            }
            return null;
        }
        return null;
    }

    @Override
    public void process(Node externs, Node source) {
        NodeTraversal.traverse(this.compiler, externs, new DefinitionGatheringCallback(true));
        NodeTraversal.traverse(this.compiler, source, new DefinitionGatheringCallback(false));
        NodeTraversal.traverse(this.compiler, source, new UseSiteGatheringCallback());
    }

    Collection<UseSite> getUseSites(DefinitionsRemover.Definition definition) {
        String name = SimpleDefinitionFinder.getSimplifiedName(definition.getLValue());
        return this.nameUseSiteMultimap.get((Object)name);
    }

    private static String getSimplifiedName(Node node) {
        if (node.isName()) {
            String name = node.getString();
            if (name != null && !name.isEmpty()) {
                return name;
            }
            return null;
        }
        if (node.isGetProp()) {
            return "this." + node.getLastChild().getString();
        }
        return null;
    }

    static boolean isCallOrNewSite(UseSite use) {
        Node call = use.node.getParent();
        if (call == null) {
            return false;
        }
        return NodeUtil.isCallOrNew(call) && call.getFirstChild() == use.node;
    }

    boolean canModifyDefinition(DefinitionsRemover.Definition definition) {
        if (this.isExported(definition)) {
            return false;
        }
        Collection<UseSite> useSites = this.getUseSites(definition);
        if (useSites.isEmpty()) {
            return false;
        }
        for (UseSite site : useSites) {
            Node nameNode = site.node;
            Collection<DefinitionsRemover.Definition> singleSiteDefinitions = this.getDefinitionsReferencedAt(nameNode);
            if (singleSiteDefinitions.size() > 1) {
                return false;
            }
            Preconditions.checkState((!singleSiteDefinitions.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)singleSiteDefinitions.contains(definition));
        }
        return true;
    }

    private boolean isExported(DefinitionsRemover.Definition definition) {
        String partialName;
        Node lValue = definition.getLValue();
        if (lValue == null) {
            return true;
        }
        if (lValue.isGetProp()) {
            partialName = lValue.getLastChild().getString();
        } else if (lValue.isName()) {
            partialName = lValue.getString();
        } else {
            return true;
        }
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        return codingConvention.isExported(partialName);
    }

    static boolean isSimpleFunctionDeclaration(Node fn) {
        String name;
        Node parent = fn.getParent();
        Node gramps = parent.getParent();
        Node nameNode = SimpleDefinitionFinder.getNameNodeFromFunctionNode(fn);
        if (nameNode != null && nameNode.isName() && ((name = nameNode.getString()).equals("JSCompiler_renameProperty") || name.equals("JSCompiler_ObjectPropertyString"))) {
            return false;
        }
        if (NodeUtil.isFunctionDeclaration(fn)) {
            return true;
        }
        return fn.getFirstChild().getString().isEmpty() && (NodeUtil.isExprAssign(gramps) || parent.isName());
    }

    static Node getNameNodeFromFunctionNode(Node function) {
        Preconditions.checkState((boolean)function.isFunction());
        if (NodeUtil.isFunctionDeclaration(function)) {
            return function.getFirstChild();
        }
        Node parent = function.getParent();
        if (NodeUtil.isVarDeclaration(parent)) {
            return parent;
        }
        if (parent.isAssign()) {
            return parent.getFirstChild();
        }
        if (NodeUtil.isObjectLitKey(parent)) {
            return parent;
        }
        return null;
    }

    void removeReferences(Node node) {
        if (DefinitionsRemover.isDefinitionNode(node)) {
            DefinitionsRemover.Definition def;
            String name;
            DefinitionSite defSite = this.definitionSiteMap.get(node);
            if (defSite != null && (name = SimpleDefinitionFinder.getSimplifiedName((def = defSite.definition).getLValue())) != null) {
                this.definitionSiteMap.remove(node);
                this.nameDefinitionMultimap.remove((Object)name, (Object)node);
            }
        } else {
            String name;
            String propName;
            Node useSite = node;
            if (useSite.isGetProp() && ((propName = useSite.getLastChild().getString()).equals("apply") || propName.equals("call"))) {
                useSite = useSite.getFirstChild();
            }
            if ((name = SimpleDefinitionFinder.getSimplifiedName(useSite)) != null) {
                this.nameUseSiteMultimap.remove((Object)name, (Object)new UseSite(useSite, null, null));
            }
        }
        for (Node child : node.children()) {
            this.removeReferences(child);
        }
    }

    private class DefinitionGatheringCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private boolean inExterns;

        DefinitionGatheringCallback(boolean inExterns) {
            this.inExterns = inExterns;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            String name;
            if (this.inExterns && node.isName() && parent.isParamList()) {
                return;
            }
            DefinitionsRemover.Definition def = DefinitionsRemover.getDefinition(node, this.inExterns);
            if (def != null && (name = SimpleDefinitionFinder.getSimplifiedName(def.getLValue())) != null) {
                Node rValue = def.getRValue();
                if (rValue != null && !NodeUtil.isImmutableValue(rValue) && !rValue.isFunction()) {
                    DefinitionsRemover.UnknownDefinition unknownDef = new DefinitionsRemover.UnknownDefinition(def.getLValue(), this.inExterns);
                    def = unknownDef;
                }
                if (this.inExterns) {
                    ArrayList stubsToRemove = Lists.newArrayList();
                    String qualifiedName = node.getQualifiedName();
                    if (qualifiedName != null) {
                        for (DefinitionsRemover.Definition prevDef : SimpleDefinitionFinder.this.nameDefinitionMultimap.get((Object)name)) {
                            String prevName;
                            if (!(prevDef instanceof DefinitionsRemover.ExternalNameOnlyDefinition) || this.jsdocContainsDeclarations(node) || !qualifiedName.equals(prevName = prevDef.getLValue().getQualifiedName())) continue;
                            stubsToRemove.add(prevDef);
                        }
                        for (DefinitionsRemover.Definition prevDef : stubsToRemove) {
                            SimpleDefinitionFinder.this.nameDefinitionMultimap.remove((Object)name, (Object)prevDef);
                        }
                    }
                }
                SimpleDefinitionFinder.this.nameDefinitionMultimap.put((Object)name, (Object)def);
                SimpleDefinitionFinder.this.definitionSiteMap.put(node, new DefinitionSite(node, def, traversal.getModule(), traversal.inGlobalScope(), this.inExterns));
            }
            if (this.inExterns && parent != null && parent.isExprResult() && (name = SimpleDefinitionFinder.getSimplifiedName(node)) != null) {
                String qualifiedName;
                boolean dropStub = false;
                if (!this.jsdocContainsDeclarations(node) && (qualifiedName = node.getQualifiedName()) != null) {
                    for (DefinitionsRemover.Definition prevDef : SimpleDefinitionFinder.this.nameDefinitionMultimap.get((Object)name)) {
                        String prevName = prevDef.getLValue().getQualifiedName();
                        if (!qualifiedName.equals(prevName)) continue;
                        dropStub = true;
                        break;
                    }
                }
                if (!dropStub) {
                    DefinitionsRemover.ExternalNameOnlyDefinition definition = new DefinitionsRemover.ExternalNameOnlyDefinition(node);
                    SimpleDefinitionFinder.this.nameDefinitionMultimap.put((Object)name, (Object)definition);
                    SimpleDefinitionFinder.this.definitionSiteMap.put(node, new DefinitionSite(node, definition, traversal.getModule(), traversal.inGlobalScope(), this.inExterns));
                }
            }
        }

        private boolean jsdocContainsDeclarations(Node node) {
            JSDocInfo info = node.getJSDocInfo();
            return info != null && info.containsDeclaration();
        }
    }

    private class UseSiteGatheringCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private UseSiteGatheringCallback() {
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
            Collection<DefinitionsRemover.Definition> defs = SimpleDefinitionFinder.this.getDefinitionsReferencedAt(node);
            if (defs == null) {
                return;
            }
            DefinitionsRemover.Definition first = defs.iterator().next();
            String name = SimpleDefinitionFinder.getSimplifiedName(first.getLValue());
            Preconditions.checkNotNull((Object)name);
            SimpleDefinitionFinder.this.nameUseSiteMultimap.put((Object)name, (Object)new UseSite(node, traversal.getScope(), traversal.getModule()));
        }
    }
}

