/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.javascript.jscomp.DefinitionSite;
import com.google.gwt.thirdparty.javascript.jscomp.DefinitionsRemover;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.jscomp.SimpleDefinitionFinder;
import com.google.gwt.thirdparty.javascript.jscomp.UseSite;
import com.google.gwt.thirdparty.javascript.rhino.Node;
import java.util.Set;

class SimpleFunctionAliasAnalysis {
    private Set<Node> aliasedFunctions;
    private Set<Node> functionsExposedToCallOrApply;

    SimpleFunctionAliasAnalysis() {
    }

    public boolean isAliased(Node functionNode) {
        Preconditions.checkNotNull(this.aliasedFunctions);
        Preconditions.checkArgument((boolean)functionNode.isFunction());
        return this.aliasedFunctions.contains(functionNode);
    }

    public boolean isExposedToCallOrApply(Node functionNode) {
        Preconditions.checkNotNull(this.functionsExposedToCallOrApply);
        Preconditions.checkArgument((boolean)functionNode.isFunction());
        return this.functionsExposedToCallOrApply.contains(functionNode);
    }

    public void analyze(SimpleDefinitionFinder finder) {
        Preconditions.checkState((this.aliasedFunctions == null ? 1 : 0) != 0);
        this.aliasedFunctions = Sets.newHashSet();
        this.functionsExposedToCallOrApply = Sets.newHashSet();
        for (DefinitionSite definitionSite : finder.getDefinitionSites()) {
            Node rValue;
            DefinitionsRemover.Definition definition = definitionSite.definition;
            if (definition.isExtern() || (rValue = definition.getRValue()) == null || !rValue.isFunction()) continue;
            for (UseSite useSite : finder.getUseSites(definition)) {
                this.updateFunctionForUse(rValue, useSite.node);
            }
        }
    }

    private void updateFunctionForUse(Node function, Node useNode) {
        Node useParent = useNode.getParent();
        int parentType = useParent.getType();
        if (parentType != 37 && parentType != 30 || useParent.getFirstChild() != useNode) {
            if (NodeUtil.isGet(useParent)) {
                Node gramps;
                if (useParent.isGetProp() && (NodeUtil.isFunctionObjectApply(gramps = useParent.getParent()) || NodeUtil.isFunctionObjectCall(gramps))) {
                    this.functionsExposedToCallOrApply.add(function);
                }
            } else {
                this.aliasedFunctions.add(function);
            }
        }
    }
}

