/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.javascript.jscomp;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.gwt.thirdparty.javascript.jscomp.NodeUtil;
import com.google.gwt.thirdparty.javascript.rhino.Node;

class StatementFusion
extends AbstractPeepholeOptimization {
    public static final boolean SHOULD_FAVOR_COMMA_OVER_SEMI_COLON = false;
    private final boolean favorsCommaOverSemiColon;

    public StatementFusion() {
        this(false);
    }

    public StatementFusion(boolean favorsCommaOverSemiColon) {
        this.favorsCommaOverSemiColon = favorsCommaOverSemiColon;
    }

    @Override
    Node optimizeSubtree(Node n) {
        if (this.favorsCommaOverSemiColon) {
            return this.tryFuseStatementsAggressively(n);
        }
        return this.tryFuseStatements(n);
    }

    Node tryFuseStatements(Node n) {
        if (!n.getParent().isFunction() && this.canFuseIntoOneStatement(n)) {
            Node start = n.getFirstChild();
            Node end = n.getLastChild();
            Node result = StatementFusion.fuseIntoOneStatement(n, start, end);
            this.fuseExpressionIntoControlFlowStatement(result, n.getLastChild());
            this.reportCodeChange();
        }
        return n;
    }

    Node tryFuseStatementsAggressively(Node n) {
        if (!NodeUtil.isStatementBlock(n)) {
            return n;
        }
        Node cur = n.getFirstChild();
        while (cur != null) {
            if (!cur.isExprResult()) {
                cur = cur.getNext();
                continue;
            }
            Node next = cur.getNext();
            while (next != null && next.isExprResult()) {
                next = next.getNext();
            }
            if (cur.getNext() != next) {
                cur = StatementFusion.fuseIntoOneStatement(n, cur, next);
                this.reportCodeChange();
            }
            if (cur.isExprResult() && next != null && this.isFusableControlStatement(next)) {
                this.fuseExpressionIntoControlFlowStatement(cur, next);
                this.reportCodeChange();
                next = next.getNext();
            }
            cur = next;
        }
        return n;
    }

    private boolean canFuseIntoOneStatement(Node block) {
        if (!this.favorsCommaOverSemiColon && !block.isBlock()) {
            return false;
        }
        if (!block.hasChildren() || block.hasOneChild()) {
            return false;
        }
        Node last = block.getLastChild();
        Node c = block.getFirstChild();
        while (c != null) {
            if (!c.isExprResult() && c != last) {
                return false;
            }
            c = c.getNext();
        }
        return this.isFusableControlStatement(last);
    }

    private boolean isFusableControlStatement(Node n) {
        switch (n.getType()) {
            case 49: 
            case 108: 
            case 110: 
            case 130: {
                return true;
            }
            case 4: {
                return n.hasChildren();
            }
            case 115: {
                if (NodeUtil.isForIn(n)) {
                    return !this.mayHaveSideEffects(n.getFirstChild());
                }
                return !n.getFirstChild().isVar();
            }
            case 126: {
                return this.isFusableControlStatement(n.getLastChild());
            }
            case 125: {
                return !n.isSyntheticBlock() && this.isFusableControlStatement(n.getFirstChild());
            }
        }
        return false;
    }

    private static Node fuseIntoOneStatement(Node parent, Node first, Node last) {
        if (first.getNext() == last) {
            return first;
        }
        Node commaTree = first.removeFirstChild();
        Node next = null;
        Node cur = first.getNext();
        while (cur != last) {
            commaTree = StatementFusion.fuseExpressionIntoExpression(commaTree, cur.removeFirstChild());
            next = cur.getNext();
            parent.removeChild(cur);
            cur = next;
        }
        first.addChildToBack(commaTree);
        return first;
    }

    private void fuseExpressionIntoControlFlowStatement(Node before, Node control) {
        Preconditions.checkArgument((boolean)before.isExprResult(), (Object)"before must be expression result");
        switch (control.getType()) {
            case 4: 
            case 49: 
            case 108: 
            case 110: 
            case 130: {
                before.getParent().removeChild(before);
                StatementFusion.fuseExpresssonIntoFirstChild(before.removeFirstChild(), control);
                return;
            }
            case 115: {
                before.getParent().removeChild(before);
                if (NodeUtil.isForIn(control)) {
                    StatementFusion.fuseExpresssonIntoSecondChild(before.removeFirstChild(), control);
                } else {
                    StatementFusion.fuseExpresssonIntoFirstChild(before.removeFirstChild(), control);
                }
                return;
            }
            case 126: {
                this.fuseExpressionIntoControlFlowStatement(before, control.getLastChild());
                return;
            }
            case 125: {
                this.fuseExpressionIntoControlFlowStatement(before, control.getFirstChild());
                return;
            }
        }
        throw new IllegalStateException("Statement fusion missing.");
    }

    protected static Node fuseExpressionIntoExpression(Node exp1, Node exp2) {
        if (exp2.isEmpty()) {
            return exp1;
        }
        Node comma = new Node(85, exp1);
        comma.copyInformationFrom(exp2);
        if (exp2.isComma()) {
            Node leftMostChild = exp2;
            while (leftMostChild.isComma()) {
                leftMostChild = leftMostChild.getFirstChild();
            }
            Node parent = leftMostChild.getParent();
            comma.addChildToBack(leftMostChild.detachFromParent());
            parent.addChildToFront(comma);
            return exp2;
        }
        comma.addChildToBack(exp2);
        return comma;
    }

    protected static void fuseExpresssonIntoFirstChild(Node exp, Node stmt) {
        Node val = stmt.removeFirstChild();
        Node comma = StatementFusion.fuseExpressionIntoExpression(exp, val);
        stmt.addChildToFront(comma);
    }

    protected static void fuseExpresssonIntoSecondChild(Node exp, Node stmt) {
        Node val = stmt.removeChildAfter(stmt.getFirstChild());
        Node comma = StatementFusion.fuseExpressionIntoExpression(exp, val);
        stmt.addChildAfter(comma, stmt.getFirstChild());
    }
}

